/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.dataquality.ExtractFailedRowsRecipePayloadParams;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.FailedRowsExtractRuleVisitor;
import com.dataiku.dip.dataquality.rules.AbstractColumnsInRangeRule;
import com.dataiku.dip.dataquality.rules.AbstractMultiColumnRule;
import com.dataiku.dip.dataquality.rules.ColumnEmptyRule;
import com.dataiku.dip.dataquality.rules.ColumnMeaningValidityRule;
import com.dataiku.dip.dataquality.rules.ColumnNotEmptyRule;
import com.dataiku.dip.dataquality.rules.ColumnUniqueValuesRule;
import com.dataiku.dip.dataquality.rules.ValuesInRangeRule;
import com.dataiku.dip.dataquality.rules.ValuesInSetRule;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.server.recipes.ExtractFailedRowsSchemaGenerator;
import com.dataiku.dip.sql.BigQuerySQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class ExtractFailedRowsQueryGenerator {
    private final ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
    private final ExtractFailedRowsRecipePayloadParams params;
    private final Dataset source;
    private final SQLUtils.SQLTable sqlTable;
    private final Dataset outputDataset;
    @Nullable
    private PartitioningScheme sourcePartitionScheme;
    @Nullable
    private List<Partition> sourcePartitions;
    @Nullable
    private PartitioningScheme targetPartitionScheme;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.dataquality");

    public ExtractFailedRowsQueryGenerator(ExtractFailedRowsRecipePayloadParams params, Dataset source, SQLUtils.SQLTable sqlTable, Dataset outputDataset) {
        Preconditions.checkNotNull((Object)params);
        Preconditions.checkNotNull((Object)source);
        this.source = source;
        this.sqlTable = sqlTable;
        this.outputDataset = outputDataset;
        this.params = params;
    }

    public void setPartitioning(PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions, PartitioningScheme targetPartitionScheme) {
        this.sourcePartitionScheme = sourcePartitionScheme;
        this.sourcePartitions = sourcePartitions;
        this.targetPartitionScheme = targetPartitionScheme;
        logger.info((Object)("Set partitioning: \nSource partition col: " + String.valueOf(sourcePartitionScheme) + "\nTarget partition col: " + String.valueOf(targetPartitionScheme)));
        logger.info((Object)("sourcePartitions: " + JSON.prettyLog(sourcePartitions)));
    }

    public String generateSQL(SQLDialect dialect) {
        return this.generateQuery(dialect).toSQL(dialect);
    }

    public SelectQueryBuilder generateQuery(SQLDialect dialect) {
        if (this.params == null) {
            throw ErrorContext.ice((String)"No parameters given to query generator");
        }
        ExtractFailedRowsSchemaGenerator schemaGenerator = new ExtractFailedRowsSchemaGenerator(this.source);
        schemaGenerator.checkRuleSelectionValidity(this.params, true);
        ExtractFailedRowsSchemaGenerator.FailedRowsSchemaDetails schemaDetails = schemaGenerator.generate(this.params, dialect == null ? null : Integer.valueOf(dialect.getIdentifiersMaxLength()));
        List<DataQualityRule> rules = schemaDetails.rules;
        SelectQueryBuilder subQueryBuilder = new SelectQueryBuilder();
        subQueryBuilder.from(this.sqlTable, this.sqlTable.getTable());
        if (this.sourcePartitionScheme != null && this.sqlTable.isTrueTable()) {
            Iterator partitionFilterExpression = ExpressionUtils.getPartitionFilterClause(this.sourcePartitionScheme, this.source, this.sourcePartitions, dialect);
            subQueryBuilder.where(new ExpressionBuilder[]{partitionFilterExpression});
        }
        for (SchemaColumn column : this.source.getSchema().columns) {
            String columnName = column.getName();
            subQueryBuilder.select(ExpressionUtils.getAdjustedColumn(this.ebf.col(columnName), columnName, this.source, dialect), columnName);
        }
        if (this.targetPartitionScheme != null) {
            for (String col : this.targetPartitionScheme.getDimensionNames()) {
                SchemaColumn sc = this.outputDataset.getSchema().getColumnOrDefault(col, Type.STRING);
                ExpressionBuilder expr = this.ebf.dstPartitionId(sc, this.targetPartitionScheme.getDimension(col));
                subQueryBuilder.replaceSelect(col, expr, col);
            }
        }
        EnrichedOutcomeColumnDetails outcomeColumnDetails = new EnrichedOutcomeColumnDetails(schemaDetails.outcomeColumnsDetails);
        RuleProcessor ruleProcessor = new RuleProcessor(dialect, outcomeColumnDetails, this.source);
        for (DataQualityRule rule : rules) {
            rule.accept(ruleProcessor);
        }
        outcomeColumnDetails.outcomeColumnExpressionBuilders.forEach((outcomeColumnKey, expressionBuilder) -> subQueryBuilder.select((ExpressionBuilder)expressionBuilder, outcomeColumnDetails.getOutcomeColumn((ExtractFailedRowsSchemaGenerator.OutcomeColumnKey)outcomeColumnKey)));
        SelectQueryBuilder selectQueryBuilder = new SelectQueryBuilder();
        selectQueryBuilder.from(subQueryBuilder, "__dku_inner");
        if (outcomeColumnDetails.outcomeColumnExpressionBuilders.isEmpty()) {
            selectQueryBuilder.where(this.ebf.cst(1).eq(this.ebf.cst(0)));
        } else {
            ExpressionBuilder whereExpressionBuilder = outcomeColumnDetails.outcomeColumnExpressionBuilders.keySet().stream().map(outcomeColumnKey -> {
                String outcomeColumn = outcomeColumnDetails.getOutcomeColumn((ExtractFailedRowsSchemaGenerator.OutcomeColumnKey)outcomeColumnKey);
                return this.ebf.col("__dku_inner", outcomeColumn).eq(AbstractCheckContext.CheckOutcome.ERROR.name()).or(this.ebf.col("__dku_inner", outcomeColumn).eq(AbstractCheckContext.CheckOutcome.WARNING.name()));
            }).reduce((rec$, xva$0) -> ((ExpressionBuilder)rec$).or((ExpressionBuilder)xva$0)).orElseThrow();
            selectQueryBuilder.where(whereExpressionBuilder);
        }
        selectQueryBuilder = QueryGenerationUtils.applyOverrides(selectQueryBuilder, this.params.outputColumnNameOverrides, dialect, true);
        selectQueryBuilder = QueryGenerationUtils.applyInsertIntoCasts(selectQueryBuilder, dialect, this.outputDataset);
        return selectQueryBuilder;
    }

    public static List<DataQualityRule> getUnsupportedRules(List<DataQualityRule> rules) {
        RuleSupportEvaluator ruleSupportEvaluator = new RuleSupportEvaluator();
        for (DataQualityRule rule : rules) {
            rule.accept(ruleSupportEvaluator);
        }
        return ruleSupportEvaluator.unsupportedRules;
    }

    private static class EnrichedOutcomeColumnDetails
    extends ExtractFailedRowsSchemaGenerator.OutcomeColumnsDetails {
        final Map<ExtractFailedRowsSchemaGenerator.OutcomeColumnKey, ExpressionBuilder> outcomeColumnExpressionBuilders = new LinkedHashMap<ExtractFailedRowsSchemaGenerator.OutcomeColumnKey, ExpressionBuilder>();

        EnrichedOutcomeColumnDetails(ExtractFailedRowsSchemaGenerator.OutcomeColumnsDetails outcomeColumnsDetails) {
            super(outcomeColumnsDetails);
        }

        void addOutcomeColumnExpressionBuilder(String ruleId, String ruleColumn, ExpressionBuilder expressionBuilder) {
            this.outcomeColumnExpressionBuilders.put(new ExtractFailedRowsSchemaGenerator.OutcomeColumnKey(ruleId, ruleColumn), expressionBuilder);
        }
    }

    private static class RuleProcessor
    implements FailedRowsExtractRuleVisitor {
        final ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
        final SQLDialect dialect;
        final EnrichedOutcomeColumnDetails outcomeColumnDetails;
        final Dataset source;

        RuleProcessor(SQLDialect dialect, EnrichedOutcomeColumnDetails outcomeColumnDetails, Dataset source) {
            this.dialect = dialect;
            this.outcomeColumnDetails = outcomeColumnDetails;
            this.source = source;
        }

        @Override
        public void visit(ValuesInSetRule rule) {
            List<String> whitelistedValuesExceptEmpty = rule.valueSet.stream().distinct().filter(s -> s != null && !s.isEmpty()).toList();
            for (String column : this.outcomeColumnDetails.getSelectedColumnsForRule(rule)) {
                if (!rule.enabled) {
                    this.outcomeColumnDetails.addOutcomeColumnExpressionBuilder(rule.getId(), column, this.ebf.cst(AbstractCheckContext.CheckOutcome.EMPTY.name()));
                    continue;
                }
                if (whitelistedValuesExceptEmpty.isEmpty()) {
                    this.outcomeColumnDetails.addOutcomeColumnExpressionBuilder(rule.getId(), column, this.ebf.cst(AbstractCheckContext.CheckOutcome.ERROR.name()));
                    continue;
                }
                this.outcomeColumnDetails.addOutcomeColumnExpressionBuilder(rule.getId(), column, this.ebf.caseWhen(this.ebf.col(column).castToString(this.dialect.getDefaultVarcharLen()).inList(whitelistedValuesExceptEmpty).not(), this.ebf.cst(AbstractCheckContext.CheckOutcome.ERROR.name()), this.ebf.cst(AbstractCheckContext.CheckOutcome.OK.name())));
            }
        }

        @Override
        public void visit(ValuesInRangeRule rule) {
            for (String column : rule.columns) {
                Optional<ExpressionBuilder> softViolationCondition;
                boolean isNumericColumn;
                if (!rule.enabled) {
                    this.outcomeColumnDetails.addOutcomeColumnExpressionBuilder(rule.getId(), column, this.ebf.cst(AbstractCheckContext.CheckOutcome.EMPTY.name()));
                    continue;
                }
                SchemaColumn schemaColumn = this.source.getSchema().getColumn(column);
                boolean bl = isNumericColumn = schemaColumn != null && schemaColumn.getType().isNumeric();
                if (!isNumericColumn) {
                    this.outcomeColumnDetails.addOutcomeColumnExpressionBuilder(rule.getId(), column, this.ebf.cst(AbstractCheckContext.CheckOutcome.WARNING.name()));
                    continue;
                }
                ArrayList<ExpressionBuilder> caseExpressions = new ArrayList<ExpressionBuilder>();
                caseExpressions.add(this.ebf.col(column).isnull());
                caseExpressions.add(this.ebf.cst(AbstractCheckContext.CheckOutcome.OK.name()));
                Optional<ExpressionBuilder> hardViolationCondition = AbstractColumnsInRangeRule.buildViolationCondition(this.ebf, column, rule.minimumEnabled, rule.minimum, rule.maximumEnabled, rule.maximum);
                if (hardViolationCondition.isPresent()) {
                    caseExpressions.add(hardViolationCondition.get());
                    caseExpressions.add(this.ebf.cst(AbstractCheckContext.CheckOutcome.ERROR.name()));
                }
                if ((softViolationCondition = AbstractColumnsInRangeRule.buildViolationCondition(this.ebf, column, rule.softMinimumEnabled, rule.softMinimum, rule.softMaximumEnabled, rule.softMaximum)).isPresent()) {
                    caseExpressions.add(softViolationCondition.get());
                    caseExpressions.add(this.ebf.cst(AbstractCheckContext.CheckOutcome.WARNING.name()));
                }
                caseExpressions.add(this.ebf.cst(AbstractCheckContext.CheckOutcome.OK.name()));
                ExpressionBuilder finalCondition = this.ebf.caseWhen(caseExpressions.toArray());
                this.outcomeColumnDetails.addOutcomeColumnExpressionBuilder(rule.getId(), column, finalCondition);
            }
        }

        @Override
        public void visit(ColumnNotEmptyRule rule) {
            this.visitEmptyOrNotEmptyRule(rule, false);
        }

        @Override
        public void visit(ColumnEmptyRule rule) {
            this.visitEmptyOrNotEmptyRule(rule, true);
        }

        private void visitEmptyOrNotEmptyRule(AbstractMultiColumnRule rule, boolean emptyRule) {
            for (String column : this.outcomeColumnDetails.getSelectedColumnsForRule(rule)) {
                if (!rule.enabled) {
                    this.outcomeColumnDetails.addOutcomeColumnExpressionBuilder(rule.getId(), column, this.ebf.cst(AbstractCheckContext.CheckOutcome.EMPTY.name()));
                    continue;
                }
                this.outcomeColumnDetails.addOutcomeColumnExpressionBuilder(rule.getId(), column, this.ebf.caseWhen(emptyRule ? this.ebf.col(column).isnotnull() : this.ebf.col(column).isnull(), this.ebf.cst(AbstractCheckContext.CheckOutcome.ERROR.name()), this.ebf.cst(AbstractCheckContext.CheckOutcome.OK.name())));
            }
        }

        @Override
        public void visit(ColumnUniqueValuesRule rule) {
            for (String column : this.outcomeColumnDetails.getSelectedColumnsForRule(rule)) {
                if (!rule.enabled) {
                    this.outcomeColumnDetails.addOutcomeColumnExpressionBuilder(rule.getId(), column, this.ebf.cst(AbstractCheckContext.CheckOutcome.EMPTY.name()));
                    continue;
                }
                ExpressionBuilder partitioningColumn = this.ebf.col(column);
                if (this.dialect instanceof BigQuerySQLDialect) {
                    partitioningColumn = partitioningColumn.castToString(this.dialect.getDefaultVarcharLen());
                }
                this.outcomeColumnDetails.addOutcomeColumnExpressionBuilder(rule.getId(), column, this.ebf.caseWhen(this.ebf.col(column).isnotnull().and(this.ebf.count("*").over(SelectQueryBuilder.window(List.of(partitioningColumn), List.of(), List.of())).gt(this.ebf.cst(1))), this.ebf.cst(AbstractCheckContext.CheckOutcome.ERROR.name()), this.ebf.cst(AbstractCheckContext.CheckOutcome.OK.name())));
            }
        }

        @Override
        public void visit(ColumnMeaningValidityRule rule) {
            if (rule.enabled) {
                throw new IllegalStateException("Rule " + rule.getId() + " is enabled and not supported.");
            }
            for (String column : this.outcomeColumnDetails.getSelectedColumnsForRule(rule)) {
                this.outcomeColumnDetails.addOutcomeColumnExpressionBuilder(rule.getId(), column, this.ebf.cst(AbstractCheckContext.CheckOutcome.EMPTY.name()));
            }
        }
    }

    private static class RuleSupportEvaluator
    implements FailedRowsExtractRuleVisitor {
        final List<DataQualityRule> unsupportedRules = new ArrayList<DataQualityRule>();

        private RuleSupportEvaluator() {
        }

        @Override
        public void visit(ValuesInSetRule rule) {
        }

        @Override
        public void visit(ValuesInRangeRule rule) {
        }

        @Override
        public void visit(ColumnNotEmptyRule rule) {
        }

        @Override
        public void visit(ColumnEmptyRule rule) {
        }

        @Override
        public void visit(ColumnUniqueValuesRule rule) {
        }

        @Override
        public void visit(ColumnMeaningValidityRule rule) {
            if (rule.enabled) {
                this.unsupportedRules.add(rule);
            }
        }
    }
}

