/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.agentreview.AgentReview;
import com.dataiku.dip.agentreview.AgentReviewsDAO;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.SearchNotebooksDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.datasets.DatasetConnectionUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.lambda.mgmt.LambdaServicesDAO;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.llm.promptstudio.PromptStudioDAO;
import com.dataiku.dip.llm.retrieval.KnowledgeBankManagementService;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.searchnotebooks.SearchNotebook;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConnectionUsagesService {
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private ScenariosDAO scenariosDAO;
    @Autowired
    private SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    private SearchNotebooksDAO searchNotebooksDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private LambdaServicesDAO lambdaServicesDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private KnowledgeBankManagementService kbMgmtService;
    @Autowired
    private PromptStudioDAO promptStudioDAO;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    @Autowired
    private AgentReviewsDAO agentReviewsDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.connections");

    public Map<String, DatasetConnectionUtils.UsedConnection> listUsages(AuthCtx authCtx, String projectKey, boolean allowMissing) throws IOException, DKUSecurityException {
        Iterator<DatasetConnectionUtils.UsedConnection> conn;
        HashMap ret = Maps.newHashMap();
        DatasetConnectionUtils dcu = new DatasetConnectionUtils(allowMissing);
        for (SerializedDataset serializedDataset : this.datasetsDAO.listUnsafe(projectKey)) {
            for (DatasetConnectionUtils.UsedConnection datasetConnection : dcu.getUsedConnections(authCtx, serializedDataset, true)) {
                ret.put(datasetConnection.name, datasetConnection);
            }
        }
        for (StreamingEndpoint streamingEndpoint : this.streamingEndpointsDAO.listUnsafe(projectKey)) {
            for (DatasetConnectionUtils.UsedConnection streamingEndpointConnection : dcu.getUsedConnections(authCtx, streamingEndpoint, true)) {
                ret.put(streamingEndpointConnection.name, streamingEndpointConnection);
            }
        }
        for (SQLNotebook sQLNotebook : this.sqlNotebooksDAO.list(projectKey)) {
            conn = this.connectionsDAO.getMandatoryConnection(authCtx, sQLNotebook.connection);
            ret.put(sQLNotebook.connection, new DatasetConnectionUtils.UsedConnection(sQLNotebook.connection, ((DSSConnection)((Object)conn)).getType()));
        }
        for (SearchNotebook searchNotebook : this.searchNotebooksDAO.list(projectKey)) {
            conn = this.connectionsDAO.getMandatoryConnection(authCtx, searchNotebook.connection);
            ret.put(searchNotebook.connection, new DatasetConnectionUtils.UsedConnection(searchNotebook.connection, ((DSSConnection)((Object)conn)).getType()));
        }
        for (ManagedFolder managedFolder : this.managedFolderDAO.listUnsafe(projectKey)) {
            for (DatasetConnectionUtils.UsedConnection datasetConnection : dcu.getUsedConnections(authCtx, managedFolder, true)) {
                ret.put(datasetConnection.name, datasetConnection);
            }
        }
        for (SerializedRecipe serializedRecipe : this.recipesDAO.listUnsafe(projectKey)) {
            for (DatasetConnectionUtils.UsedConnection datasetConnection : dcu.getUsedConnections(authCtx, serializedRecipe)) {
                ret.put(datasetConnection.name, datasetConnection);
            }
        }
        for (Scenario scenario : this.scenariosDAO.listUnsafe(projectKey)) {
            for (DatasetConnectionUtils.UsedConnection datasetConnection : dcu.getUsedConnections(authCtx, scenario)) {
                ret.put(datasetConnection.name, datasetConnection);
            }
        }
        for (LambdaService lambdaService : this.lambdaServicesDAO.listUnsafe(projectKey)) {
            for (DatasetConnectionUtils.UsedConnection datasetConnection : dcu.getUsedConnections(authCtx, lambdaService)) {
                ret.put(datasetConnection.name, datasetConnection);
            }
        }
        for (SavedModel savedModel : this.savedModelsDAO.listUnsafe(projectKey)) {
            for (DatasetConnectionUtils.UsedConnection smConnection : dcu.getUsedConnections(authCtx, savedModel, true)) {
                ret.put(smConnection.name, smConnection);
            }
        }
        for (RetrievableKnowledge retrievableKnowledge : this.retrievableKnowledgeDAO.listUnsafe(projectKey)) {
            for (DatasetConnectionUtils.UsedConnection krConnection : dcu.getUsedConnections(authCtx, retrievableKnowledge)) {
                ret.put(krConnection.name, krConnection);
            }
            try {
                String currentVersion = this.kbMgmtService.getCurrentlyUsedVersion(retrievableKnowledge);
                this.kbMgmtService.readKnowledgeBankFolder(retrievableKnowledge, currentVersion, folder -> {
                    File kbJson = DKUApp.getFile((File)folder, (String[])new String[]{"kb.json"});
                    if (!kbJson.isFile()) {
                        return;
                    }
                    RetrievableKnowledge versionedRk = (RetrievableKnowledge)JSON.parseFile((File)kbJson, RetrievableKnowledge.class);
                    for (DatasetConnectionUtils.UsedConnection uc : dcu.getUsedConnections(authCtx, versionedRk)) {
                        ret.put(uc.name, uc);
                    }
                });
            }
            catch (Exception e) {
                logger.error((Object)"Cannot get used connections for current version of kb %s".formatted(retrievableKnowledge.getId()), (Throwable)e);
            }
        }
        for (PromptStudio promptStudio : this.promptStudioDAO.listUnsafe(projectKey)) {
            for (DatasetConnectionUtils.UsedConnection psConnection : dcu.getUsedConnections(authCtx, promptStudio)) {
                ret.put(psConnection.name, psConnection);
            }
        }
        for (AgentReview agentReview : this.agentReviewsDAO.listUnsafe(projectKey)) {
            for (DatasetConnectionUtils.UsedConnection arConnection : dcu.getUsedConnections(authCtx, agentReview)) {
                ret.put(arConnection.name, arConnection);
            }
        }
        for (AnalysisCoreParams analysisCoreParams : this.analysisCRUDService.listCoreUnsafe(projectKey, null)) {
            ret.putAll(this.listAnalysisConnections(authCtx, projectKey, analysisCoreParams, dcu));
        }
        for (AgentTool agentTool : this.agentToolsDAO.list(projectKey)) {
            for (DatasetConnectionUtils.UsedConnection atConnection : dcu.getUsedConnections(authCtx, agentTool)) {
                ret.put(atConnection.name, atConnection);
            }
        }
        ret.putAll(this.listModelEvaluationsConnections(authCtx, projectKey, dcu));
        return ret;
    }

    private Map<String, DatasetConnectionUtils.UsedConnection> listAnalysisConnections(AuthCtx authCtx, String projectKey, AnalysisCoreParams acp, DatasetConnectionUtils dcu) throws IOException, DKUSecurityException {
        HashMap ret = Maps.newHashMap();
        for (MLTask mlTask : this.analysisCRUDService.listRawMLTasks(projectKey, acp.id)) {
            for (DatasetConnectionUtils.UsedConnection mlTaskConnection : dcu.getUsedConnections(authCtx, mlTask)) {
                ret.put(mlTaskConnection.name, mlTaskConnection);
            }
            for (FullModelId fmi : this.analysisCRUDService.listMLTaskModels(projectKey, acp.id, mlTask.id)) {
                for (DatasetConnectionUtils.UsedConnection trainedMLTaskConnection : dcu.getUsedConnections(authCtx, fmi)) {
                    ret.put(trainedMLTaskConnection.name, trainedMLTaskConnection);
                }
            }
        }
        return ret;
    }

    private Map<String, DatasetConnectionUtils.UsedConnection> listModelEvaluationsConnections(AuthCtx authCtx, String projectKey, DatasetConnectionUtils dcu) throws IOException, DKUSecurityException {
        HashMap ret = Maps.newHashMap();
        for (ModelEvaluationStore modelEvaluationStore : this.modelEvaluationStoresCRUDService.list(projectKey)) {
            for (ModelEvaluationStoresCRUDService.ModelEvaluationHeader evaluationHeader : this.modelEvaluationStoresCRUDService.listEvaluations(modelEvaluationStore, null, -1)) {
                for (DatasetConnectionUtils.UsedConnection connection : dcu.getUsedConnections(authCtx, evaluationHeader.evaluation.ref)) {
                    ret.put(connection.name, connection);
                }
            }
        }
        return ret;
    }
}

