/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryTool;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.j2py.annotations.PyModel;
import java.io.IOException;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrustedObjectPermissionService {
    @Autowired
    private SavedModelsDAO smDao;
    @Autowired
    private AgentToolsDAO agentToolsDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private ProjectsService projectsService;

    public void CheckPermissionsWithTrustedObject(AuthCtx authCtx, AnyLoc objectRef, ITaggingService.TaggableType objectType, String contextProjectKey, TrustedObject trustedObject) throws IOException, DKUSecurityException {
        block6: {
            block5: {
                AnyLoc trustedObjectRef = AnyLoc.resolveSmart(contextProjectKey, trustedObject.smartRef);
                this.projectsService.failIfNoTaggableObjectReadUseAccess(authCtx, trustedObject.type, trustedObjectRef, contextProjectKey);
                this.projectsService.failIfLocNotAvailableInProject(objectType, objectRef, trustedObjectRef.getProjectKey());
                if (trustedObject.type != ITaggingService.TaggableType.SAVED_MODEL && trustedObject.type != ITaggingService.TaggableType.AGENT_TOOL) break block5;
                AnyLoc kbRef = this.GetValidKnowledgeBankRef(trustedObject, trustedObjectRef);
                switch (objectType) {
                    case MANAGED_FOLDER: {
                        RetrievableKnowledge rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getMandatory(kbRef);
                        if (rk.managedFolderId != null && !rk.managedFolderId.equals(objectRef.getFullName())) {
                            throw new IllegalArgumentException("The Knowledge Bank from the trusted object doesn't reference the managed folder");
                        }
                        break block6;
                    }
                    case RETRIEVABLE_KNOWLEDGE: {
                        if (kbRef.equals(objectRef)) break;
                        throw new IllegalArgumentException("The trusted object does not reference the knowledge bank");
                    }
                }
                break block6;
            }
            throw new IllegalArgumentException("Unsupported trusted object type: " + String.valueOf((Object)trustedObject.type));
        }
    }

    private AnyLoc GetValidKnowledgeBankRef(TrustedObject trustedObject, AnyLoc trustedObjectRef) throws IOException {
        AnyLoc kbRef;
        if (Objects.requireNonNull(trustedObject.type) == ITaggingService.TaggableType.SAVED_MODEL) {
            SavedModel sm = (SavedModel)this.smDao.getMandatory(trustedObjectRef);
            if (sm.savedModelType != SavedModel.SavedModelType.RETRIEVAL_AUGMENTED_LLM) {
                throw new IllegalArgumentException("The trusted object is not a RAG LLM saved model");
            }
            SavedModel.SavedModelInlineVersion smiv = sm.getActiveSaveModelInlineVersion();
            if (smiv == null) {
                throw new IllegalArgumentException("Saved model has no active version");
            }
            if (smiv.ragllmSettings == null) {
                throw new IllegalArgumentException("Saved model has no settings defined");
            }
            kbRef = AnyLoc.resolveSmart(sm.projectKey, smiv.ragllmSettings.kbRef);
        } else if (Objects.requireNonNull(trustedObject.type) == ITaggingService.TaggableType.AGENT_TOOL) {
            AgentTool at = (AgentTool)this.agentToolsDAO.getMandatory(trustedObjectRef);
            VectorStoreQueryTool.VectorStoreQueryToolParams params = at.getParamsCopyAs(VectorStoreQueryTool.VectorStoreQueryToolParams.class);
            if (params == null) {
                throw new IllegalArgumentException("Vector Store Query Tool parameters are missing");
            }
            kbRef = AnyLoc.resolveSmart(at.projectKey, params.knowledgeBankRef);
        } else {
            throw new IllegalArgumentException("Unsupported trusted object type: " + String.valueOf((Object)trustedObject.type));
        }
        return kbRef;
    }

    @PyModel
    public static class TrustedObject {
        public String smartRef;
        public ITaggingService.TaggableType type;
    }
}

