/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class Coalesce
extends AppliesToProcessor
implements Processor {
    public static final ProcessorMeta<Coalesce, Parameter> META = new AppliesToProcessor.AppliesToProcessorMeta<Coalesce, Parameter>(){

        @Override
        public String getName() {
            return "Coalesce";
        }

        @Override
        public String getDocPage() {
            return "coalesce";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MISC});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.Coalesce.HELP", "Returns the first non-null (and non-empty) value across several input columns.\n\nThe processor evaluates selected columns from left to right and outputs the first value that is neither null nor an empty string (\"\").\n\n# Options\n\n**Use default value**\n\nIf checked, the output column will be filled with the value set in the option **Default value** if all input columns are null or empty.\nIf checked but **Default value** is not set, the output will be an empty string.\n\n# Example\n\nGiven input columns `col1` and `col2`:\n<table><tr><th>col1</th><th>col2</th><th>Output</th></tr><tr><td>&nbsp;</td><td>foo</td><td>foo</td></tr></table>\n(Empty string is skipped).");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.Coalesce.DESCRIPTION", 1.actionVerb("Coalesce") + " \u2013 returns the first non-null value"), null, false).withMNESParam("outputColumn", this.translate(language, "SHAKER.PROCESSOR.Coalesce.DESCRIPTION.OUTPUT_COLUMN", "Output column")).withBool("useDefaultValue", this.translate(language, "SHAKER.PROCESSOR.Coalesce.DESCRIPTION.USE_DEFAULT_VALUE", "Use default value"), "").withParam("defaultValue", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.Coalesce.DESCRIPTION.DEFAULT_VALUE", "Default value"));
        }

        @Override
        public StepParams expandParams(StepParams params, VariablesContext vc) {
            Parameter p = (Parameter)params;
            if (p.useDefaultValue && p.defaultValue != null) {
                p.defaultValue = vc.expand(p.defaultValue);
            }
            return p;
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.STATIC_COLUMNS_CREATOR, ProcessorCapabilities.KNOWN_INPUTS, ProcessorCapabilities.KNOWN_OUTPUTS, ProcessorCapabilities.TYPE_FIXED_COLUMNS_CREATOR);
        }

        @Override
        public Coalesce build(Parameter parameter) {
            return new Coalesce(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            return previousRecipeLineage;
        }
    };
    private final Parameter parameter;
    private Column outputColumnRef;

    public Coalesce(Parameter parameter) {
        this.parameter = parameter;
    }

    @Override
    public AppliesToProcessor.AppliesToParams getParams() {
        return this.parameter;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (StringUtils.isBlank((String)this.parameter.outputColumn)) {
            throw ErrorContext.iae((String)"Invalid parameter: missing output column name");
        }
        this.outputColumnRef = this.getColumnFactory().column(this.parameter.outputColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    @Override
    public void processRowForColumns(Row row, Iterable<Column> columns) {
        String resultValue = null;
        for (Column col : columns) {
            String value = row.get(col);
            if (value == null || value.isEmpty()) continue;
            resultValue = value;
            break;
        }
        if (resultValue == null && this.parameter.useDefaultValue) {
            resultValue = this.parameter.defaultValue == null ? "" : this.parameter.defaultValue;
        }
        row.put(this.outputColumnRef, resultValue);
    }

    public void postProcess() {
    }

    public static class Parameter
    extends AppliesToProcessor.AppliesToParams {
        private static final long serialVersionUID = -1L;
        public String outputColumn;
        public boolean useDefaultValue;
        @Nullable
        public String defaultValue;
    }
}

