/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.expr.CreateColumnWithGREL;
import com.dataiku.dip.shaker.processors.time.DateParser;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.services.smartdate.SmartDateService;
import com.dataiku.dip.shaker.types.DataTypeMatch;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.google.refine.expr.ParsingException;
import com.google.refine.grel.GrelControlFunctionRegistry;
import com.google.refine.grel.Parser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AICompletionService {
    @Autowired
    private DataService service;
    @Autowired
    private FutureService futureService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    public static final String DEFAULT_URL = "https://ai.api-services.dataiku.io/";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.shaker.ai.completion");

    public FutureResponse<AICompletionFrontendResponse> startCompletion(DSSAuthCtx authCtx, String projectKey, Dataset ds, SerializedShakerScript sss, String query, String requestedSampleId, String previousRequestId) throws Exception {
        AICompleteScriptFutureThread futureThread = new AICompleteScriptFutureThread(authCtx, projectKey, ds, sss, query, requestedSampleId, previousRequestId);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<AICompletionFrontendResponse>>(){});
    }

    public static List<ProcessorScriptStep> getProcessorScriptSteps(@Nullable MemScriptRunner.TableWithReport twr, List<JsonObject> steps) throws SmartDateService.InvalidFormatException {
        ArrayList<ProcessorScriptStep> finalList = new ArrayList<ProcessorScriptStep>();
        for (JsonObject step : steps) {
            String type = step.get("type").getAsString();
            JsonObject params = step.get("params").getAsJsonObject();
            if ("ParseDateAuto".equals(type)) {
                Boolean noFormatsGuessed;
                String column = params.get("inputColumn").getAsString();
                SmartDateService sds = new SmartDateService();
                SmartDateService.GuessResponse ret = null;
                if (twr != null) {
                    ret = sds.guess(twr.table, column);
                    noFormatsGuessed = ret.formats.isEmpty();
                } else {
                    noFormatsGuessed = true;
                }
                DateParser.Parameter param = new DateParser.Parameter();
                param.appliesTo = AppliesToProcessor.AppliesTo.SINGLE_COLUMN;
                param.columns = Lists.newArrayList((Object[])new String[]{column});
                param.outCol = params.get("outputColumn").getAsString();
                param.formats = Lists.newArrayList();
                if (noFormatsGuessed.booleanValue()) {
                    logger.error((Object)"No date format guessed during AI completion");
                } else {
                    SmartDateService.GuessFormat guessFormat = ret.formats.get(0);
                    param.formats.add(guessFormat.format);
                    param.lang = guessFormat.language;
                }
                ProcessorScriptStep pss = new ProcessorScriptStep();
                pss.type = "DateParser";
                pss.params = param;
                if (noFormatsGuessed.booleanValue()) {
                    pss.preview = false;
                    pss.disabled = true;
                }
                finalList.add(pss);
                continue;
            }
            if ("CreateColumnWithGREL".equals(type)) {
                String expression = params.get("expression").getAsString();
                String errorMessage = null;
                try {
                    new Parser(expression, GrelControlFunctionRegistry.getInstance());
                }
                catch (ParsingException e) {
                    logger.error((Object)"Invalid formula generated during AI completion", (Throwable)e);
                    errorMessage = e.getMessage();
                }
                ProcessorScriptStep pss = new ProcessorScriptStep();
                pss.type = "CreateColumnWithGREL";
                pss.params = (StepParams)JSON.parse((String)JSON.json((Object)params), CreateColumnWithGREL.META.stepParamClass());
                if (errorMessage != null) {
                    pss.preview = false;
                    pss.disabled = true;
                }
                finalList.add(pss);
                continue;
            }
            try {
                ProcessorMeta<?, ?> meta = BaseProcessorsFactory.getMeta(type);
                ProcessorScriptStep pss = new ProcessorScriptStep();
                pss.type = type;
                pss.params = (StepParams)JSON.parse((String)JSON.json((Object)params), meta.stepParamClass());
                finalList.add(pss);
            }
            catch (Exception e) {
                logger.error((Object)("Ignoring unknown processor or bad params: " + type + " -> " + JSON.log((Object)params)), (Throwable)e);
            }
        }
        return finalList;
    }

    private class AICompleteScriptFutureThread
    extends SimpleFutureThread<AICompletionFrontendResponse> {
        private final String projectKey;
        private final Dataset dataset;
        private final String requestedSampleId;
        private final SerializedShakerScript sss;
        private final String query;
        private final String previousRequestId;
        private final GeneralSettingsDAO.GeneralSettings generalSettings;
        private final AuthCtx authCtx;

        public AICompleteScriptFutureThread(DSSAuthCtx owner, String projectKey, Dataset dataset, SerializedShakerScript sss, String query, String requestedSampleId, String previousRequestId) {
            super((AuthCtx)owner);
            this.projectKey = projectKey;
            this.dataset = dataset;
            this.requestedSampleId = requestedSampleId;
            this.sss = sss;
            this.query = query;
            this.previousRequestId = previousRequestId;
            this.generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            this.authCtx = owner;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"ai_complete_prepare_script", (String)"AI Complete Prepare Script");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public AICompletionFrontendResponse compute() throws Exception {
            NDC.push((String)("ai-complete: " + this.dataset.getProjectKey() + "-" + this.dataset.getName()));
            try {
                AICompletionFrontendResponse aICompletionFrontendResponse;
                block32: {
                    AICompletionFrontendResponse finalResp;
                    List<ProcessorScriptStep> finalList;
                    AICompletionBackendResponse resp2222;
                    InternalAPIClient apiClient;
                    block30: {
                        AICompletionFrontendResponse aICompletionFrontendResponse2;
                        block31: {
                            MemScriptRunner.TableWithReport twr;
                            block28: {
                                Object dtm;
                                block29: {
                                    twr = AICompletionService.this.service.get_NOTRANSACTION(this.dataset, this.sss, this.requestedSampleId, null, true, (AuthCtx)this.owner);
                                    AICompletionBackendQuery acq = new AICompletionBackendQuery();
                                    acq.datasetName = this.dataset.getName();
                                    if (StringUtils.isNotBlank((String)this.previousRequestId)) {
                                        acq.previousRequestId = this.previousRequestId;
                                    }
                                    for (Column c2 : twr.table.columns()) {
                                        MemColumn mc = (MemColumn)c2;
                                        if (acq.datasetColumns.size() > 50) break;
                                        AICompletionColumn col = new AICompletionColumn();
                                        col.name = mc.getName();
                                        dtm = mc.selectedType;
                                        col.meaning = ((DataTypeMatch)dtm).type.getMeaningId();
                                        col.nbInvalid = ((DataTypeMatch)dtm).nbFails;
                                        col.nbEmpty = ((DataTypeMatch)dtm).nbEmpty;
                                        if (mc.datasetSchemaColumn != null) {
                                            col.columnDescription = mc.datasetSchemaColumn.comment;
                                        } else if (mc.recipeSchemaColumn != null && mc.recipeSchemaColumn.column != null) {
                                            col.columnDescription = mc.recipeSchemaColumn.column.comment;
                                        }
                                        if (this.generalSettings.aiDrivenAnalyticsSettings.sendSampleValues) {
                                            col.sampleValues.addAll(AIFeaturesUtil.collectSampleRowValues(twr, mc, AIFeaturesUtil.Feature.AIPREPARE, this.query));
                                        }
                                        acq.datasetColumns.add(col);
                                    }
                                    acq.query = this.query;
                                    LicenseStatusService.LicensingStatus ls = AICompletionService.this.licenseStatusService.getLicensingStatus();
                                    if (ls.community) {
                                        throw new IllegalArgumentException("AI services are not available with Dataiku Free Edition");
                                    }
                                    acq.licenseId = ls != null && ls.licenseContent != null ? ls.licenseContent.licenseId : null;
                                    acq.telemetryEnabled = this.generalSettings.aiDrivenAnalyticsSettings.telemetryEnabled;
                                    apiClient = AIFeaturesUtil.getAiServerAPIClient(this.authCtx, this.generalSettings, AIFeaturesUtil.CONNECTION_TIMEOUT, AIFeaturesUtil.SOCKET_TIMEOUT);
                                    resp2222 = (AICompletionBackendResponse)apiClient.postObject("/text2prepare", AICompletionBackendResponse.class, (Object)acq);
                                    logger.info((Object)("AI Response: " + JSON.log((Object)resp2222)));
                                    if (resp2222.ok) break block28;
                                    logger.warn((Object)"AI completion was not able to suggest actions");
                                    AICompletionFrontendResponse finalResp2 = new AICompletionFrontendResponse();
                                    finalResp2.reason = "AI completion was not able to suggest valid actions";
                                    if (resp2222.error != null) {
                                        finalResp2.reason = finalResp2.reason + ": " + resp2222.error;
                                    }
                                    finalResp2.ok = false;
                                    dtm = finalResp2;
                                    if (apiClient == null) break block29;
                                    apiClient.close();
                                }
                                return dtm;
                            }
                            finalList = AICompletionService.getProcessorScriptSteps(twr, resp2222.steps);
                            if (!finalList.isEmpty()) break block30;
                            logger.warn((Object)"Empty list of valid steps during AI completion");
                            finalResp = new AICompletionFrontendResponse();
                            finalResp.ok = false;
                            finalResp.reason = "AI completion was not able to suggest valid actions";
                            aICompletionFrontendResponse2 = finalResp;
                            if (apiClient == null) break block31;
                            {
                                catch (Throwable resp2222) {
                                    AICompletionFrontendResponse aICompletionFrontendResponse3;
                                    AICompletionFrontendResponse finalResp3;
                                    try {
                                        if (apiClient != null) {
                                            try {
                                                apiClient.close();
                                            }
                                            catch (Throwable throwable) {
                                                resp2222.addSuppressed(throwable);
                                            }
                                        }
                                        throw resp2222;
                                    }
                                    catch (IOException e) {
                                        logger.error((Object)"IO exception while getting AI completion", (Throwable)e);
                                        finalResp3 = new AICompletionFrontendResponse();
                                        finalResp3.ok = false;
                                        finalResp3.reason = "Could not get response from AI service: " + ExceptionUtils.getMessageWithCauses((Throwable)e);
                                        aICompletionFrontendResponse3 = finalResp3;
                                        return aICompletionFrontendResponse3;
                                    }
                                    catch (DKUSecurityException e) {
                                        logger.error((Object)"Security exception while getting AI completion", (Throwable)e);
                                        finalResp3 = new AICompletionFrontendResponse();
                                        finalResp3.ok = false;
                                        finalResp3.reason = ExceptionUtils.getMessageWithCauses((Throwable)e);
                                        aICompletionFrontendResponse3 = finalResp3;
                                        return aICompletionFrontendResponse3;
                                    }
                                    catch (IllegalArgumentException e) {
                                        logger.error((Object)"Configuration error while connecting to AI server", (Throwable)e);
                                        finalResp3 = new AICompletionFrontendResponse();
                                        finalResp3.ok = false;
                                        finalResp3.reason = e.getMessage();
                                        aICompletionFrontendResponse3 = finalResp3;
                                        return aICompletionFrontendResponse3;
                                    }
                                }
                            }
                            apiClient.close();
                        }
                        return aICompletionFrontendResponse2;
                    }
                    finalResp = new AICompletionFrontendResponse();
                    finalResp.ok = true;
                    finalResp.requestId = resp2222.request_id;
                    finalResp.steps = finalList.stream().map(s -> JSON.toJsonObject((Object)s, (String[])new String[0])).collect(Collectors.toList());
                    aICompletionFrontendResponse = finalResp;
                    if (apiClient == null) break block32;
                    apiClient.close();
                }
                return aICompletionFrontendResponse;
            }
            finally {
                NDC.pop();
            }
        }
    }

    public static class AICompletionFrontendResponse {
        boolean ok;
        String reason;
        List<JsonObject> steps;
        String requestId;
    }

    public static class AICompletionBackendResponse {
        boolean ok;
        String error;
        List<JsonObject> steps;
        String request_id;
    }

    public static class AICompletionBackendQuery {
        String licenseId;
        String datasetName;
        List<AICompletionColumn> datasetColumns = new ArrayList<AICompletionColumn>();
        String query;
        String previousRequestId;
        boolean telemetryEnabled;
    }

    public static class AICompletionColumn {
        String name;
        String meaning;
        String columnDescription;
        int nbEmpty = 0;
        int nbInvalid = 0;
        List<String> sampleValues = new ArrayList<String>();
    }
}

