/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.sql;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.sql.ShakerSQLTranslator;
import com.dataiku.dip.shaker.text.StringNormalizer;
import com.dataiku.dip.sql.BigQuerySQLDialect;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.RedshiftSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SQLQueryWithSchema {
    private SelectQueryBuilder sqb_;
    private Schema currentSchema = new Schema();
    private Schema inputSchema = new Schema();
    private Set<String> columnsRemovedByCurrentQuery = new HashSet<String>();
    private Set<String> columnsCreatedByCurrentQuery = new HashSet<String>();
    private Set<String> columnsModifiedByCurrentQuery = new HashSet<String>();
    private SQLDialect dialect;
    private ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
    private Map<String, String> columnNameToAcceptableColumnName = Maps.newHashMap();
    private Set<String> acceptableColumnNames = Sets.newHashSet();
    private SchemaUtils.SafeColumnIdentifierSuffixer safeSuffixer = null;
    private static Logger logger = Logger.getLogger((String)"dku.shaker.querywithschema");

    public SQLQueryWithSchema() {
        this.sqb_ = new SelectQueryBuilder();
    }

    public void setDialect(SQLDialect dialect) {
        this.dialect = dialect;
        this.safeSuffixer = new SchemaUtils.SafeColumnIdentifierSuffixer(dialect == null ? null : Integer.valueOf(dialect.getIdentifiersMaxLength()), null);
    }

    public SQLDialect getDialect() {
        return this.dialect;
    }

    public void from(SQLUtils.SQLTable inputTable, String alias) {
        this.sqb_.from(inputTable, alias);
    }

    public void from(SelectQueryBuilder from, String alias) {
        this.sqb_.from(from, alias);
    }

    public void withInlineQuery(String query, String alias) {
        this.sqb_.withInlineQuery(query, alias);
    }

    public String toSQL(SQLDialect dialect) {
        return this.sqb_.toSQL(dialect);
    }

    public SQLQueryWithSchema applyInsertIntoCasts(Dataset outputDataset) {
        this.sqb_ = QueryGenerationUtils.applyInsertIntoCasts(this.sqb_, this.dialect, outputDataset);
        return this;
    }

    private boolean shouldLowercase() {
        return this.dialect instanceof HiveSQLDialect || this.dialect instanceof ImpalaSQLDialect || this.dialect instanceof SparkSQLDialect || this.dialect instanceof RedshiftSQLDialect;
    }

    private boolean shouldSlugify() {
        return this.dialect instanceof BigQuerySQLDialect;
    }

    public void addKnownAcceptable(String name) {
        this.acceptableColumnNames.add(name);
    }

    public String makeAcceptable(String name) {
        if (this.acceptableColumnNames.contains(name)) {
            return name;
        }
        if (this.columnNameToAcceptableColumnName.containsKey(name)) {
            return this.columnNameToAcceptableColumnName.get(name);
        }
        String acceptable = name;
        if (this.shouldLowercase()) {
            acceptable = acceptable.toLowerCase();
        }
        if (this.shouldSlugify()) {
            acceptable = acceptable.replaceAll("[^a-zA-Z0-9_]", "_");
        }
        if (this.safeSuffixer != null) {
            acceptable = StringNormalizer.normalize((String)acceptable);
            acceptable = this.safeSuffixer.addSuffix(acceptable, "");
        }
        this.columnNameToAcceptableColumnName.put(name, acceptable);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Column '" + name + "' >>>> translate to '" + acceptable + "'"));
        }
        return acceptable;
    }

    private Schema makeAcceptable(Schema schema) {
        Schema ret = (Schema)JSON.deepCopy((Object)schema);
        for (SchemaColumn column : ret.columns) {
            column.setName(this.makeAcceptable(column.getName()));
        }
        return ret;
    }

    private List<String> makeAcceptable(Iterable<String> names) {
        ArrayList ret = Lists.newArrayList();
        for (String name : names) {
            ret.add(this.makeAcceptable(name));
        }
        return ret;
    }

    private SchemaColumn makeAcceptable(SchemaColumn column) {
        SchemaColumn lowercasedIfNeeded = (SchemaColumn)JSON.deepCopy((Object)column);
        lowercasedIfNeeded.setName(this.makeAcceptable(column.getName()));
        return lowercasedIfNeeded;
    }

    public boolean isCreatedOrModifiedByCurrentQuery(String columnName) {
        return this.columnsCreatedByCurrentQuery.contains(columnName = this.makeAcceptable(columnName)) || this.columnsModifiedByCurrentQuery.contains(columnName);
    }

    public boolean isAnyCreatedOrModifiedByCurrentQuery(Iterable<String> columnNames) {
        for (String cn : columnNames) {
            if (!this.isCreatedOrModifiedByCurrentQuery(cn)) continue;
            return true;
        }
        return false;
    }

    public Optional<SchemaColumn> getInputColumn(String columnName) {
        columnName = this.makeAcceptable(columnName);
        return Optional.fromNullable((Object)this.inputSchema.getColumn(columnName));
    }

    public Schema getCurrentSchema() {
        return this.currentSchema;
    }

    public void addColumn(SchemaColumn column) {
        column = this.makeAcceptable(column);
        this.currentSchema.getColumns().add(column);
        this.columnsCreatedByCurrentQuery.add(column.getName());
    }

    public void addColumnAfter(String after, SchemaColumn column) {
        column = this.makeAcceptable(column);
        after = this.makeAcceptable(after);
        ListIterator<SchemaColumn> it = this.currentSchema.getColumns().listIterator();
        boolean done = false;
        while (it.hasNext()) {
            SchemaColumn sc = (SchemaColumn)it.next();
            if (!sc.getName().equals(after)) continue;
            it.add(column);
            done = true;
            break;
        }
        if (!done) {
            throw new Error("failed to add " + column.getName() + " after " + after + " (not found) ");
        }
        this.columnsCreatedByCurrentQuery.add(column.getName());
    }

    public void deleteColumn(String name) {
        name = this.makeAcceptable(name);
        this.currentSchema.removeColumn(name);
        this.columnsRemovedByCurrentQuery.add(name);
    }

    public void replaceColumn(SchemaColumn column) {
        column = this.makeAcceptable(column);
        assert (this.currentSchema.getColumn(column.getName()) != null) : "Current schema does not contain " + column.getName();
        this.currentSchema.updateOrAddColumn(column);
        this.columnsModifiedByCurrentQuery.add(column.getName());
    }

    public void replaceColumn(String oldName, SchemaColumn column) {
        oldName = this.makeAcceptable(oldName);
        column = this.makeAcceptable(column);
        assert (this.currentSchema.getColumn(oldName) != null) : "Current schema does not contain " + column.getName();
        this.currentSchema.updateColumn(oldName, column);
        this.columnsModifiedByCurrentQuery.add(column.getName());
    }

    public void markColumnModified(String name) {
        name = this.makeAcceptable(name);
        assert (this.currentSchema.getColumn(name) != null);
        this.columnsModifiedByCurrentQuery.add(name);
    }

    public List<String> getAppliesToColumns(AppliesToProcessor.AppliesToParams params) {
        switch (params.appliesTo) {
            case SINGLE_COLUMN: {
                return Lists.newArrayList((Object[])new String[]{this.makeAcceptable(params.columns.get(0))});
            }
            case COLUMNS: {
                return this.makeAcceptable(params.columns);
            }
            case PATTERN: {
                Pattern p = this.shouldLowercase() ? Pattern.compile(params.appliesToPattern, 2) : Pattern.compile(params.appliesToPattern);
                ArrayList<String> ret = new ArrayList<String>();
                for (SchemaColumn inputColumn : this.currentSchema.columns) {
                    if (!p.matcher(inputColumn.getName()).matches()) continue;
                    ret.add(inputColumn.getName());
                }
                return ret;
            }
            case ALL: {
                ArrayList<String> ret = new ArrayList<String>();
                for (SchemaColumn col : this.currentSchema.columns) {
                    ret.add(col.getName());
                }
                return ret;
            }
        }
        throw new Error("unreachable");
    }

    public Iterable<String> getCurrentColumsBut(Iterable<String> columnsToKeep) {
        columnsToKeep = this.makeAcceptable(columnsToKeep);
        ArrayList<String> ret = new ArrayList<String>();
        HashSet toKeep = Sets.newHashSet(columnsToKeep);
        for (SchemaColumn currentColumn : this.currentSchema.getColumns()) {
            if (toKeep.contains(currentColumn.getName())) continue;
            ret.add(currentColumn.getName());
        }
        return ret;
    }

    public SQLQueryWithSchema makeSubquery() {
        return this.makeSubquery(null);
    }

    public SQLQueryWithSchema makeEmptySubquery() {
        return this.makeEmptySubquery(null);
    }

    public SQLQueryWithSchema makeSubquery(String alias) {
        SQLQueryWithSchema chain = this.makeEmptySubquery(alias);
        chain.currentSchema = (Schema)JSON.deepCopy((Object)chain.inputSchema);
        for (String selectedName : this.sqb_.getSelectedNames()) {
            chain.sqb_.select(selectedName);
        }
        return chain;
    }

    public SQLQueryWithSchema makeEmptySubquery(String alias) {
        SQLQueryWithSchema chain = new SQLQueryWithSchema();
        chain.setDialect(this.getDialect());
        chain.inputSchema = (Schema)JSON.deepCopy((Object)this.getCurrentSchema());
        chain.columnNameToAcceptableColumnName.putAll(this.columnNameToAcceptableColumnName);
        chain.acceptableColumnNames.addAll(this.acceptableColumnNames);
        chain.currentSchema = new Schema();
        chain.sqb_ = new SelectQueryBuilder();
        chain.sqb_.from(this.sqb_, StringUtils.defaultIfBlank((String)alias, (String)"__dku_before_xxx"));
        if (logger.isTraceEnabled()) {
            try {
                logger.trace((Object)("making subquery from:\n" + this.sqb_.toSQL(this.getDialect())));
                logger.trace((Object)(" -> which had : " + JSON.log(this.sqb_.getSelectedNames())));
            }
            catch (Exception e) {
                logger.trace((Object)"making subquery from untranslatable to SQL query");
                logger.trace((Object)(" -> which had : " + JSON.log(this.sqb_.getSelectedNames())));
            }
        }
        return chain;
    }

    public String prettyPrint(SQLDialect dialect, ShakerSQLTranslator.ShakerSQLTranslatorContext context) {
        Object s = "";
        s = (String)s + "Query:\n" + this.sqb_.toSQL(dialect) + "\n";
        if (context == ShakerSQLTranslator.ShakerSQLTranslatorContext.RECIPE_STATUS_COMPUTE) {
            s = (String)s + "Schema: " + this.getCurrentSchema().compactPrettyPrint() + "\n";
            s = (String)s + "Input Schema: " + this.inputSchema.compactPrettyPrint() + "\n";
        } else {
            s = (String)s + "Schema:\n" + this.getCurrentSchema().prettyPrint(2);
            s = (String)s + "Input Schema:\n" + this.inputSchema.prettyPrint(2);
        }
        s = (String)s + "Changes: cr=" + JSON.json(this.columnsCreatedByCurrentQuery) + " mod=" + JSON.json(this.columnsModifiedByCurrentQuery) + " del=" + JSON.json(this.columnsRemovedByCurrentQuery);
        return s;
    }

    public void coalesceSelect(String name, ExpressionBuilder expr, String as) {
        this.markColumnModified(as);
        name = this.makeAcceptable(name);
        as = this.makeAcceptable(as);
        this.sqb_.replaceSelect(name, expr.coalesce(this.col(name)), as);
    }

    public void coalesceAndCastSelect(String name, ExpressionBuilder expr, String as, Type asType, int maxLength) {
        this.markColumnModified(as);
        name = this.makeAcceptable(name);
        as = this.makeAcceptable(as);
        this.sqb_.replaceSelect(name, expr.coalesce(this.col(name).cast(asType, maxLength)), as);
    }

    public void replaceSelect(String name, ExpressionBuilder expr, String as) {
        name = this.makeAcceptable(name);
        as = this.makeAcceptable(as);
        this.sqb_.replaceSelect(name, expr, as);
    }

    public void deleteSelect(String name) {
        name = this.makeAcceptable(name);
        this.sqb_.deleteSelect(name);
    }

    public void select(String name) {
        if (!"*".equals(name)) {
            name = this.makeAcceptable(name);
        }
        this.sqb_.select(name);
    }

    public void select(ExpressionBuilder expr, String alias) {
        alias = this.makeAcceptable(alias);
        this.sqb_.select(expr, alias);
    }

    public void clearSelected() {
        this.sqb_.clearSelected();
    }

    public String getCurrentMainAlias() {
        return this.sqb_.getCurrentMainAlias();
    }

    public SelectQueryBuilder subQuery() {
        return this.subQuery(null);
    }

    public SelectQueryBuilder subQuery(String alias) {
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.from(this.sqb_.getFromCopy(alias));
        return sqb;
    }

    public SQLQueryWithSchema getCopy() {
        return this.getCopy(null);
    }

    public SQLQueryWithSchema getCopy(String alias) {
        SQLQueryWithSchema chain = new SQLQueryWithSchema();
        chain.setDialect(this.getDialect());
        chain.columnNameToAcceptableColumnName.putAll(this.columnNameToAcceptableColumnName);
        chain.acceptableColumnNames.addAll(this.acceptableColumnNames);
        chain.columnsCreatedByCurrentQuery = Sets.newHashSet(this.columnsCreatedByCurrentQuery);
        chain.columnsModifiedByCurrentQuery = Sets.newHashSet(this.columnsModifiedByCurrentQuery);
        chain.columnsRemovedByCurrentQuery = Sets.newHashSet(this.columnsRemovedByCurrentQuery);
        chain.inputSchema = (Schema)JSON.deepCopy((Object)this.inputSchema);
        chain.currentSchema = (Schema)JSON.deepCopy((Object)this.currentSchema);
        chain.sqb_ = this.sqb_.getQuery(this.sqb_.getFromCopy(alias));
        return chain;
    }

    public SelectQueryBuilder.JoinClauseBuilder join(SelectQueryBuilder subQuery, QueryAst.JoinType joinType, String subQueryName) {
        return this.sqb_.join(subQuery, joinType, subQueryName);
    }

    public int getSelectedIndex(String column) {
        column = this.makeAcceptable(column);
        return this.sqb_.getSelectedIndex(column);
    }

    public void where(ExpressionBuilder ... ebs) {
        this.sqb_.where(ebs);
    }

    public void initWithSchema(Schema schema) {
        for (SchemaColumn sc : schema.getColumns()) {
            this.addKnownAcceptable(sc.getName());
        }
        this.inputSchema = this.makeAcceptable(schema);
        this.currentSchema = (Schema)JSON.deepCopy((Object)this.inputSchema);
    }

    public SchemaColumn getCurrentColumn(String name) {
        return this.currentSchema.getColumn(this.makeAcceptable(name));
    }

    public SchemaColumn getMandatoryCurrentColumn(String name) {
        SchemaColumn sc = this.currentSchema.getColumn(this.makeAcceptable(name));
        if (sc == null) {
            throw new IllegalArgumentException("There is no column name or alias with the name '" + name + "'");
        }
        return sc;
    }

    public List<SchemaColumn> getCurrentColumns(Collection<String> names) {
        ArrayList ret = Lists.newArrayList();
        for (String name : names) {
            SchemaColumn c2 = this.currentSchema.getColumn(this.makeAcceptable(name));
            if (c2 == null) continue;
            ret.add(c2);
        }
        return ret;
    }

    public ExpressionBuilder col(String name) {
        return this.ebf.col(this.makeAcceptable(name));
    }

    public ExpressionBuilder col(SchemaColumn column, @Nonnull SerializedDataset.TypeSystemVersion typeSystemVersion, boolean isDatasetManaged) {
        boolean trustColumnType = false;
        if (column.getType() != Type.STRING) {
            trustColumnType = true;
        } else if (!isDatasetManaged) {
            trustColumnType = this.dialect.isGuaranteedTextType(column.originalType);
        } else if (typeSystemVersion == SerializedDataset.TypeSystemVersion.V2) {
            trustColumnType = true;
        }
        return trustColumnType ? this.ebf.col(this.makeAcceptable(column.getName()), column.getType()) : this.ebf.col(this.makeAcceptable(column.getName()));
    }

    public ExpressionBuilder col(String tableName, String name) {
        return this.ebf.col(tableName, this.makeAcceptable(name));
    }

    public void addAfterOrReplaceColumn(SchemaColumn inputSchemaColumn, ExpressionBuilder expressionBuilderToApply, Type outputType, String originalOutputColumnName, boolean coalesceWhenReplace, int outputColumnLength) {
        new AddOrReplaceHelper(false, coalesceWhenReplace, inputSchemaColumn, expressionBuilderToApply, outputType, originalOutputColumnName, outputColumnLength);
    }

    public void addAfterOrReplaceColumn(SchemaColumn inputSchemaColumn, ExpressionBuilder expressionBuilderToApply, Type outputType, String originalOutputColumnName, boolean coalesceWhenReplace) {
        this.addAfterOrReplaceColumn(inputSchemaColumn, expressionBuilderToApply, outputType, originalOutputColumnName, coalesceWhenReplace, null != inputSchemaColumn ? inputSchemaColumn.maxLength : -1);
    }

    public void addLastOrReplaceColumn(SchemaColumn inputSchemaColumn, ExpressionBuilder expressionBuilderToApply, Type outputType, String originalOutputColumnName, int outputColumnLength) {
        new AddOrReplaceHelper(true, false, inputSchemaColumn, expressionBuilderToApply, outputType, originalOutputColumnName, outputColumnLength);
    }

    public void addLastOrReplaceColumn(SchemaColumn inputSchemaColumn, ExpressionBuilder expressionBuilderToApply, Type outputType, String originalOutputColumnName) {
        this.addLastOrReplaceColumn(inputSchemaColumn, expressionBuilderToApply, outputType, originalOutputColumnName, null != inputSchemaColumn ? inputSchemaColumn.maxLength : -1);
    }

    private class AddOrReplaceHelper {
        private AddOrReplaceHelper(boolean addLastIfNew, @Nullable boolean coalesceWhenReplace, SchemaColumn inputSchemaColumn, ExpressionBuilder expressionBuilderToApply, @Nullable Type outputType, String originalOutputColumnName, int outputColumnLength) {
            String outputColumnName;
            boolean addNewColumnInLastPosition;
            String columnNameToAddAfterIfNew = null;
            if (inputSchemaColumn == null) {
                addNewColumnInLastPosition = true;
            } else {
                columnNameToAddAfterIfNew = inputSchemaColumn.getName();
                addNewColumnInLastPosition = addLastIfNew;
            }
            String string = outputColumnName = StringUtils.isBlank((String)originalOutputColumnName) ? columnNameToAddAfterIfNew : originalOutputColumnName;
            if (inputSchemaColumn == null && outputColumnName == null) {
                throw new IllegalArgumentException("There is no column defined to put the resulting column");
            }
            SchemaColumn outputColumnFromExistingSchema = SQLQueryWithSchema.this.getCurrentColumn(outputColumnName);
            boolean replaceExistingColumn = outputColumnFromExistingSchema != null;
            SchemaColumn outputSchemaColumn = this.buildNewSchemaColumn(outputColumnFromExistingSchema, outputColumnName, outputType, outputColumnLength);
            if (replaceExistingColumn) {
                ExpressionBuilder updatedExpressionBuilder = expressionBuilderToApply;
                if (coalesceWhenReplace) {
                    updatedExpressionBuilder = expressionBuilderToApply.coalesce(SQLQueryWithSchema.this.col(outputSchemaColumn.getName()).cast(outputType, outputSchemaColumn.getMaxLength()));
                }
                SQLQueryWithSchema.this.replaceColumn(outputSchemaColumn);
                SQLQueryWithSchema.this.replaceSelect(outputColumnName, updatedExpressionBuilder, outputColumnName);
            } else {
                if (addNewColumnInLastPosition) {
                    SQLQueryWithSchema.this.addColumn(outputSchemaColumn);
                } else {
                    SQLQueryWithSchema.this.addColumnAfter(columnNameToAddAfterIfNew, outputSchemaColumn);
                }
                SQLQueryWithSchema.this.select(expressionBuilderToApply, outputColumnName);
            }
        }

        private SchemaColumn buildNewSchemaColumn(SchemaColumn original, String newName, Type newType, int maxLength) {
            if (original == null) {
                return new SchemaColumn(newName, newType, maxLength);
            }
            SchemaColumn result = (SchemaColumn)JSON.deepCopy((Object)original);
            if (result == null) {
                throw new IllegalArgumentException(String.format("Could not copy schema of column %s", original.getName()));
            }
            result.setName(newName);
            result.maxLength = maxLength;
            return result.withType(newType);
        }
    }
}

