/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.sql;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface SnowflakeUDFProcessorTranslator
extends ProcessorSQLTranslator {
    default public List<SnowflakeUDFResource> getUDFResources() throws IOException {
        return SnowflakeUDFProcessorTranslator.createStandardResourceList();
    }

    public List<SnowflakeFunctionDef> getUDFs();

    public static List<SnowflakeUDFResource> createStandardResourceList() throws IOException {
        ArrayList<SnowflakeUDFResource> list = new ArrayList<SnowflakeUDFResource>();
        list.add(new SnowflakeUDFResource(DKUApp.getInstallFile((String[])new String[]{"dist/dataiku-prepare-core.jar"}), "/jars"));
        list.add(new SnowflakeUDFResource(DKUApp.getDataikuApplicationStringF(), ""));
        return list;
    }

    public static void addStandardResources(List<SnowflakeUDFResource> list, StandardResource ... resources) {
        block9: for (StandardResource sr : resources) {
            switch (sr) {
                case COMMONS_LANG_JAR: {
                    list.add(new SnowflakeUDFResource(DKUApp.getInstallFile((String[])new String[]{"lib/ivy/common-run/commons-lang-2.6.jar"}), "/jars"));
                    continue block9;
                }
                case COMMONS_NET_JAR: {
                    list.add(new SnowflakeUDFResource(DKUApp.getInstallFile((String[])new String[]{"lib/ivy/common-run/commons-net-3.10.0.jar"}), "/jars"));
                    continue block9;
                }
                case DKU_CORE_JAR: {
                    list.add(new SnowflakeUDFResource(DKUApp.getInstallFile((String[])new String[]{"dist/dataiku-core.jar"}), "/jars"));
                    continue block9;
                }
                case GUAVA_JAR: {
                    list.add(new SnowflakeUDFResource(DKUApp.getInstallFile((String[])new String[]{"lib/ivy/common-run/guava-32.0.1-jre.jar"}), "/jars"));
                    continue block9;
                }
                case SHADELIB: {
                    list.add(new SnowflakeUDFResource(DKUApp.getInstallFile((String[])new String[]{"lib/shadelib/dss-shadelib-assembly.jar"}), "/jars"));
                    list.add(new SnowflakeUDFResource(DKUApp.getInstallFile((String[])new String[]{"lib/shadelib/dss-shadelib-aws-sdk2.jar"}), "/jars"));
                    list.add(new SnowflakeUDFResource(DKUApp.getInstallFile((String[])new String[]{"lib/shadelib/dss-shadelib-azure.jar"}), "/jars"));
                    list.add(new SnowflakeUDFResource(DKUApp.getInstallFile((String[])new String[]{"lib/shadelib/dss-shadelib-legacy-aws-assembly.jar"}), "/jars"));
                    continue block9;
                }
                case LOG4J_JAR: {
                    list.add(new SnowflakeUDFResource(DKUApp.getInstallFile((String[])new String[]{"lib/ivy/common-run/reload4j-1.2.22.jar"}), "/jars"));
                    continue block9;
                }
                case ORGJSON_JAR: {
                    list.add(new SnowflakeUDFResource(DKUApp.getInstallFile((String[])new String[]{"lib/ivy/common-run/json-20231013.jar"}), "/jars"));
                }
            }
        }
    }

    public static class SnowflakeUDFResource {
        public final File file;
        public final String targetPath;

        public SnowflakeUDFResource(File file, String targetPath) {
            this.file = file;
            this.targetPath = targetPath;
        }
    }

    public static enum StandardResource {
        SHADELIB,
        DKU_CORE_JAR,
        GUAVA_JAR,
        COMMONS_LANG_JAR,
        COMMONS_NET_JAR,
        LOG4J_JAR,
        ORGJSON_JAR;

    }

    public static class SnowflakeFunctionDef {
        public final String name;
        public final String inputDeclaration;
        public final String typesDeclaration;
        public final String outputType;
        public final String handler;
        public final Set<String> imports;

        public SnowflakeFunctionDef(String name, String handler, String inputDeclaration, String typesDeclaration, String outputType) {
            this.name = name;
            this.handler = handler;
            this.inputDeclaration = inputDeclaration;
            this.typesDeclaration = typesDeclaration;
            this.outputType = outputType;
            this.imports = new HashSet<String>();
            this.imports.add("jars/dataiku-prepare-core.jar");
            this.imports.add("dataiku-app-str.txt");
        }

        public void importStandardResources(StandardResource ... resources) {
            block9: for (StandardResource sr : resources) {
                switch (sr) {
                    case COMMONS_LANG_JAR: {
                        this.imports.add("jars/commons-lang-2.6.jar");
                        continue block9;
                    }
                    case COMMONS_NET_JAR: {
                        this.imports.add("jars/commons-net-3.10.0.jar");
                        continue block9;
                    }
                    case DKU_CORE_JAR: {
                        this.imports.add("jars/dataiku-core.jar");
                        continue block9;
                    }
                    case GUAVA_JAR: {
                        this.imports.add("jars/guava-32.0.1-jre.jar");
                        continue block9;
                    }
                    case SHADELIB: {
                        this.imports.add("jars/dss-shadelib-assembly.jar");
                        this.imports.add("jars/dss-shadelib-aws-sdk2.jar");
                        this.imports.add("jars/dss-shadelib-azure.jar");
                        this.imports.add("jars/dss-shadelib-legacy-aws-assembly.jar");
                        continue block9;
                    }
                    case LOG4J_JAR: {
                        this.imports.add("jars/reload4j-1.2.22.jar");
                        continue block9;
                    }
                    case ORGJSON_JAR: {
                        this.imports.add("jars/json-20231013.jar");
                    }
                }
            }
        }
    }
}

