/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.shaker.types.AbstractUDMDetector;
import java.util.HashSet;
import java.util.Set;

public class ValueMappingUDMDetector
extends AbstractUDMDetector {
    private Set<String> normalizedFrom;
    private Set<String> normalizedTo;

    public ValueMappingUDMDetector(UserDefinedMeaning udm) {
        super(udm);
        this.normalizedFrom = new HashSet<String>(udm.mappings.size());
        this.normalizedTo = new HashSet<String>(udm.mappings.size());
        for (UserDefinedMeaning.Mapping mapping : udm.mappings) {
            this.normalizedFrom.add(udm.normalizationMode.apply(mapping.from));
            this.normalizedTo.add(udm.normalizationMode.apply(mapping.to.value));
        }
    }

    @Override
    public UserDefinedMeaning getUdm() {
        return this.udm;
    }

    public double detects(String val) {
        if (val != null) {
            String normalizedVal = this.udm.normalizationMode.apply(val);
            if (this.normalizedFrom.contains(normalizedVal)) {
                return 0.7f;
            }
            if (this.normalizedTo.contains(normalizedVal)) {
                return 0.3f;
            }
        }
        return 0.0;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isTemporal() {
        return false;
    }

    public String getMeaningId() {
        return this.udm.id;
    }

    public long longValue(String val) {
        return 0L;
    }

    public double doubleValue(String val) {
        return 0.0;
    }

    public boolean validates(String val) {
        return this.detects(val) > 0.0;
    }
}

