/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.logging.LimitedLogFactory;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public abstract class SparkJobHelper<T extends SparkJob> {
    public static String SPARK_VERSION = StringUtils.defaultIfBlank((String)System.getenv("DKU_SPARK_VERSION"), (String)"1.X");
    public static final String JARS_VERSION = "2.0";
    public static final List<String> IVY_RUN_CONFS = ImmutableList.of((Object)"backend-run", (Object)"common-run");
    public static final List<String> JARS_TO_SEND_TO_SPARK = ImmutableList.of((Object)"dataiku-core.jar", (Object)"dataiku-app-platform.jar", (Object)"dataiku-dss-core.jar", (Object)"dataiku-prepare-core.jar", (Object)"dataiku-dip.jar", (Object)"dataiku-scoring.jar", (Object)"dataiku-hproxy-client.jar", (Object)"dataiku-spark-gcp-credentials-provider.jar", (Object)"dataiku-spark-azure-credentials-provider.jar", (Object)"dataiku-spark-authentication-filter.jar");
    public static final List<Pattern> EXCLUDED_IVY_JARS = ImmutableList.of((Object)Pattern.compile("aspectj.*"), (Object)Pattern.compile("aopalliance.*"), (Object)Pattern.compile("metrics-graphite.*"), (Object)Pattern.compile("metrics-healthchecks.*"), (Object)Pattern.compile("google(?!-cloud-core).*"), (Object)Pattern.compile("guice.*"), (Object)Pattern.compile("gax.*"), (Object)Pattern.compile("grpc.*"), (Object)Pattern.compile("httpc.*"), (Object)Pattern.compile("javax\\.inject.*"), (Object)Pattern.compile("netty-.*"));
    public static final List<String> INCLUDED_IVY_JARS = ImmutableList.of((Object)"netty-resolver-dns");
    protected final String projectKey;
    protected final AuthCtx authCtx;
    protected final SparkSettings sparkSettings;
    protected final HadoopSettings hadoopSettings;
    private static boolean warnedAbourSparkVersionParseability = false;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.spark.helper");

    protected SparkJobHelper(String projectKey, AuthCtx authCtx, SparkSettings sparkSettings, HadoopSettings hadoopSettings) {
        this.projectKey = projectKey;
        this.authCtx = authCtx;
        this.sparkSettings = sparkSettings;
        this.hadoopSettings = hadoopSettings;
    }

    public static String getScalaVersion(String sparkVersion) {
        String sparkVersionClean = StringUtils.defaultIfEmpty((String)sparkVersion, (String)SPARK_VERSION);
        if (sparkVersionClean.startsWith("3.")) {
            return "2.12";
        }
        throw new IllegalArgumentException(String.format("Spark version '%s' is no longer supported", sparkVersionClean));
    }

    public static boolean isSparkAtLeast(int major, int minor) {
        try {
            String[] parts = SPARK_VERSION.split("\\.");
            return Integer.parseInt(parts[0]) > major || Integer.parseInt(parts[0]) == major && Integer.parseInt(parts[1]) >= minor;
        }
        catch (Exception e) {
            if (!warnedAbourSparkVersionParseability) {
                logger.warn((Object)("Can't check if spark is " + major + "." + minor + " or more recent"), (Throwable)e);
                warnedAbourSparkVersionParseability = true;
            }
            return false;
        }
    }

    public String getScalaVersionFromSettings() {
        return SparkJobHelper.getScalaVersion(this.getSparkVersionFromSettings());
    }

    public abstract String getSparkVersionFromSettings();

    public void failIfUnsupportedSpark() {
        String sparkVersion = this.getSparkVersionFromSettings();
        if (sparkVersion.startsWith("1.") || sparkVersion.startsWith("2.")) {
            throw new IllegalArgumentException("DSS integration to version " + sparkVersion + " is no longer supported, upgrade Spark to 3.x");
        }
    }

    public List<File> getJarsList(boolean withJetty, boolean withSparklingWater) {
        String sparkVersion = this.getSparkVersionFromSettings();
        return this.getJarsList(SparkJobHelper.getScalaVersion(sparkVersion), sparkVersion, withJetty, withSparklingWater);
    }

    protected abstract List<File> getJarsList(String var1, String var2, boolean var3, boolean var4);

    public static boolean shouldExclude(String filename) {
        for (Pattern excludePattern : EXCLUDED_IVY_JARS) {
            if (!excludePattern.matcher(filename).matches() || INCLUDED_IVY_JARS.stream().anyMatch(f -> filename.contains((CharSequence)f))) continue;
            return true;
        }
        return false;
    }

    public static void addShadedLibJars(List<File> jars) {
        jars.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/shadelib", "dss-shadelib-assembly.jar"));
        jars.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/shadelib", "dss-shadelib-aws-sdk2.jar"));
        jars.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/shadelib", "dss-shadelib-azure.jar"));
        jars.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/shadelib", "dss-shadelib-legacy-aws-assembly.jar"));
        jars.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/shadelib", "dss-shadelib-gcp.jar"));
        jars.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/dss-shadelib", "dss-shadelib-apache-poi.jar"));
        jars.add(new File(ApplicationConfigurator.getInstallFolder() + "/lib/dss-shadelib", "dss-shadelib-treasuredata.jar"));
    }

    public List<File> getJarsList(String scalaVersion, String sparkVersion, boolean withJetty, boolean withSparklingWater, boolean withLivy) {
        File javaLib;
        ArrayList<File> jars = new ArrayList<File>();
        for (String runConf : IVY_RUN_CONFS) {
            for (File f : DKUFileUtils.listJarFiles((String)(ApplicationConfigurator.getInstallFolder() + "/lib/ivy/" + runConf))) {
                if (!withJetty && !f.getName().startsWith("jetty-io") && f.getName().startsWith("jetty-") || !withLivy && f.getName().contains("livy-") || SparkJobHelper.shouldExclude(f.getName())) continue;
                jars.add(f);
            }
        }
        SparkJobHelper.addShadedLibJars(jars);
        for (String dist : JARS_TO_SEND_TO_SPARK) {
            jars.add(new File(ApplicationConfigurator.getInstallFolder() + "/dist/" + dist));
        }
        for (String scalaDist : ImmutableList.of((Object)"dss-spark-public", (Object)"dss-spark-main")) {
            jars.add(SparkJobHelper.getSparkJar(scalaVersion, scalaDist));
        }
        for (Object f : DKUFileUtils.listJarFiles((String)(ApplicationConfigurator.getInstallFolder() + "/lib/third"))) {
            if (!((File)f).getName().endsWith(".jar") || ((File)f).getName().contains("dataiku-hive-udf")) continue;
            jars.add((File)f);
        }
        if (SpringUtils.getInstance() != null) {
            IPluginsRegistryService ps2 = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
            for (InstalledPluginDesc installedPluginDesc : ps2.getLoadedPlugins()) {
                String pluginId = installedPluginDesc.desc.id;
                try {
                    File pluginDir = ps2.getActualPluginFolder(pluginId);
                    if (!pluginDir.isDirectory() || !new File(pluginDir, "lib").isDirectory()) continue;
                    jars.addAll(DKUFileUtils.listJarFiles((File)new File(pluginDir, "lib")));
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to gather jars from plugin " + pluginId), (Throwable)e);
                }
            }
        }
        if ((javaLib = ApplicationConfigurator.getFile((String[])new String[]{"lib", "java"})).isDirectory()) {
            jars.addAll(DKUFileUtils.listJarFiles((File)javaLib));
        }
        boolean needsSnowflakeSparkJar = false;
        try {
            for (DSSConnection conn : ConnectionsDAO.get().listUnsafe().values()) {
                if (!"Snowflake".equals(conn.type)) continue;
                try {
                    SnowflakeConnection sconn = (SnowflakeConnection)conn;
                    needsSnowflakeSparkJar |= sconn.params.useSparkNativeIntegration && sconn.params.driverMode == SnowflakeConnection.SnowflakeDriverMode.MANAGED;
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to read Snowflake connection " + conn.name), (Throwable)e);
                }
            }
        }
        catch (IOException iOException) {
            logger.warn((Object)"Failed to read connections", (Throwable)iOException);
        }
        if (needsSnowflakeSparkJar) {
            logger.info((Object)"Adding Spark-Snowflake jars");
            Pattern pattern = Pattern.compile("^([0-9]\\.[0-9])\\b.*$");
            String majorMinor = "3.0";
            Matcher majorMinorMatcher = pattern.matcher(StringUtils.defaultIfBlank((String)sparkVersion, (String)"3.0"));
            if (majorMinorMatcher.matches()) {
                majorMinor = majorMinorMatcher.group(1);
                logger.info((Object)("Found spark major.minor from version: " + majorMinor));
            }
            if (majorMinor.startsWith("3.") && !Sets.newHashSet((Object[])new String[]{"3.0", "3.1", "3.2", "3.3", "3.4"}).contains(majorMinor)) {
                majorMinor = "3.4";
            }
            logger.info((Object)("Final spark major.minor: " + majorMinor));
            jars.addAll(DKUFileUtils.listJarFiles((File)DKUApp.getInstallFile((String[])new String[]{"lib", "ivy", "spark-snowflake_" + majorMinor})));
            jars.addAll(DKUFileUtils.listJarFiles((File)DKUApp.getInstallFile((String[])new String[]{"lib", "ivy", "jdbc-snowflake"})));
        }
        if (withSparklingWater) {
            File swDir = ApplicationConfigurator.getFile((String[])new String[]{"lib", "sparkling-water"});
            if (swDir.isDirectory()) {
                jars.addAll(DKUFileUtils.listJarFiles((File)swDir));
            } else {
                logger.warn((Object)("sparkling-water directory not found (" + String.valueOf(swDir) + "), job will probably fail"));
            }
        }
        if (this.sparkSettings.additionalSparkSubmitJars != null) {
            VariablesContext variablesContext = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForGlobal();
            for (String jarPath : this.sparkSettings.additionalSparkSubmitJars) {
                jars.add(new File(variablesContext.expandAllowUnresolved(jarPath)));
            }
        }
        HashSet jarNames = Sets.newHashSet();
        ArrayList arrayList = Lists.newArrayList();
        for (File jar : jars) {
            String fileName = jar.getName();
            if (!fileName.endsWith(".jar")) {
                fileName = jar.getAbsolutePath();
            }
            if (jarNames.contains(fileName)) continue;
            jarNames.add(fileName);
            arrayList.add(jar);
        }
        return arrayList;
    }

    public static File getSparkJar(String scalaVersion, String project) {
        String v = JARS_VERSION;
        if ("dss-spark-main".equals(project)) {
            v = "5.1";
        }
        return new File(ApplicationConfigurator.getInstallFolder() + "/dist/" + project + "_" + scalaVersion + "-" + v + ".jar");
    }

    private static Map<String, SimpleKeyValue> cleanupEmptyClusterProps(List<ClusterProperty> props) {
        HashMap kvs = Maps.newHashMap();
        for (ClusterProperty kv : props) {
            if (StringUtils.isBlank((String)kv.key)) continue;
            kvs.put(kv.key, new SimpleKeyValue(kv.key, StringUtils.defaultIfBlank((String)kv.value, (String)""), kv.secret));
        }
        return kvs;
    }

    private static Map<String, SimpleKeyValue> cleanupEmptyKeyValues(List<SimpleKeyValue> props) {
        HashMap kvs = Maps.newHashMap();
        for (SimpleKeyValue kv : props) {
            if (StringUtils.isBlank((String)kv.key)) continue;
            kvs.put(kv.key, new SimpleKeyValue(kv.key, StringUtils.defaultIfBlank((String)kv.value, (String)""), false));
        }
        return kvs;
    }

    public static List<SimpleKeyValue> composeConf(AuthCtx authCtx, String projectKey, SparkSettings sparkSettings, SparkExecutionConfig sec, List<SimpleKeyValue> additionalConf) throws IOException {
        if (sparkSettings == null) {
            sparkSettings = new ClusterSelector().selectGlobal().getSparkSettings();
        }
        if (!sparkSettings.sparkEnabled) {
            throw ErrorContext.iae((String)"Cannot resolve Spark configuration: Spark is not enabled on this DSS instance");
        }
        HashMap resolvedConfig = Maps.newHashMap();
        resolvedConfig.putAll(SparkJobHelper.cleanupEmptyClusterProps(sec.conf));
        for (SimpleKeyValue kv : additionalConf) {
            resolvedConfig.put(kv.key, kv);
        }
        ArrayList ret = Lists.newArrayList();
        for (Map.Entry e : resolvedConfig.entrySet()) {
            ret.add((SimpleKeyValue)e.getValue());
        }
        return SparkJobHelper.expandConf(authCtx, projectKey, ret);
    }

    public static SparkExecutionConfig getExecutionConfigWithoutOverrides(SparkSettings sparkSettings, SparkOverrideConfig soc) throws IOException {
        if (sparkSettings == null) {
            sparkSettings = new ClusterSelector().selectGlobal().getSparkSettings();
        }
        if (!sparkSettings.sparkEnabled) {
            throw ErrorContext.iae((String)"Cannot resolve Spark configuration: Spark is not enabled on this DSS instance");
        }
        return sparkSettings.getByName(soc.inheritConf);
    }

    public static List<SimpleKeyValue> composeConf(AuthCtx authCtx, String projectKey, SparkSettings sparkSettings, SparkOverrideConfig soc, Map<String, String> additionalConf) throws IOException {
        if (!sparkSettings.sparkEnabled) {
            throw ErrorContext.iae((String)"Cannot resolve Spark configuration: Spark is not enabled on this DSS instance");
        }
        SparkExecutionConfig parentConfig = sparkSettings.getByName(soc.inheritConf);
        HashMap resolvedConfig = Maps.newHashMap();
        resolvedConfig.putAll(SparkJobHelper.cleanupEmptyClusterProps(parentConfig.conf));
        resolvedConfig.putAll(SparkJobHelper.cleanupEmptyKeyValues(soc.conf));
        for (Map.Entry<String, String> e : additionalConf.entrySet()) {
            resolvedConfig.put(e.getKey(), new SimpleKeyValue(e.getKey(), e.getValue()));
        }
        ArrayList ret = Lists.newArrayList();
        for (Map.Entry e : resolvedConfig.entrySet()) {
            ret.add((SimpleKeyValue)e.getValue());
        }
        return SparkJobHelper.expandConf(authCtx, projectKey, ret);
    }

    private List<SimpleKeyValue> getConfWithPortRange(List<SimpleKeyValue> conf) {
        PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
        if (!dssPortRange.enabled || !dssPortRange.autoSparkConfig) {
            return conf;
        }
        assert (dssPortRange.isValid()) : "Port range not defined properly";
        HashMap returnedConfMap = Maps.newHashMap();
        for (SimpleKeyValue confEntry : conf) {
            returnedConfMap.put(confEntry.key, confEntry.value);
        }
        String sparkVersion = this.getSparkVersionFromSettings();
        if (!sparkVersion.startsWith("2") && !sparkVersion.startsWith("3")) {
            String message = "DSS port range auto configuration does not support Spark version " + sparkVersion;
            logger.warn((Object)message);
            return conf;
        }
        logger.info((Object)"Adding port range configuration to spark job");
        returnedConfMap.put("spark.blockManager.port", Integer.toString(dssPortRange.start));
        returnedConfMap.put("spark.driver.port", Integer.toString(dssPortRange.start));
        returnedConfMap.put("spark.port.maxRetries", Integer.toString(dssPortRange.end - dssPortRange.start));
        ArrayList returnedConf = Lists.newArrayList();
        for (Map.Entry e : returnedConfMap.entrySet()) {
            returnedConf.add(new SimpleKeyValue((String)e.getKey(), (String)e.getValue()));
        }
        return returnedConf;
    }

    protected void buildCommandArgs(T ret, Map<String, String> conf) {
        for (Map.Entry<String, String> r : conf.entrySet()) {
            ((SparkJob)ret).conf.add(new SimpleKeyValue(r.getKey(), r.getValue()));
        }
    }

    protected void buildCommandArgs(T ret, List<SimpleKeyValue> conf) {
        ((SparkJob)ret).conf.addAll(conf);
    }

    protected abstract T newSparkJob();

    protected T makeJob(String appName, boolean withJetty, boolean withSparklingWater, List<SimpleKeyValue> conf, String ... args) {
        T cmdline = this.newSparkJob();
        ((SparkJob)cmdline).name = appName;
        String sparkAppNameConfValue = appName.length() > 63 ? appName.substring(0, 62) : appName;
        ((SparkJob)cmdline).conf.add(new SimpleKeyValue("spark.app.name", sparkAppNameConfValue));
        ((SparkJob)cmdline).conf.add(new SimpleKeyValue("spark.dku.limitedLogs", LimitedLogFactory.toJSON()));
        if (withSparklingWater) {
            ((SparkJob)cmdline).conf.add(new SimpleKeyValue("spark.dynamicAllocation.enabled", "false"));
        }
        conf = this.getConfWithPortRange(conf);
        this.buildCommandArgs(cmdline, conf);
        for (File f : this.getJarsList(withJetty, withSparklingWater)) {
            ((SparkJob)cmdline).jars.add(f.getAbsolutePath());
        }
        ((SparkJob)cmdline).args.addAll(Arrays.asList(args));
        return cmdline;
    }

    public T makeRawJob(String appName, boolean withJetty, List<SimpleKeyValue> conf) {
        return this.makeJob(appName, withJetty, false, conf, new String[0]);
    }

    public T makeClassJob(String appName, boolean withJetty, List<SimpleKeyValue> conf, String mainClass, String ... args) {
        String scalaVersion = this.getScalaVersionFromSettings();
        T cmdline = this.makeJob(appName, withJetty, false, conf, args);
        ((SparkJob)cmdline).className = mainClass;
        ((SparkJob)cmdline).file = SparkJobHelper.getSparkJar(scalaVersion, "dss-spark-main").getAbsolutePath();
        return cmdline;
    }

    public T makeClassJobWithNonSecretGlobalFiles(String appName, List<SimpleKeyValue> conf, Collection<File> files, boolean withSparklingWater, String mainClass, String ... args) {
        String scalaVersion = this.getScalaVersionFromSettings();
        T cmdline = this.makeJob(appName, false, withSparklingWater, conf, args);
        ((SparkJob)cmdline).className = mainClass;
        for (File f : files) {
            ((SparkJob)cmdline).nonSecretGlobalFiles.add(f.getAbsolutePath());
        }
        ((SparkJob)cmdline).file = SparkJobHelper.getSparkJar(scalaVersion, "dss-spark-main").getAbsolutePath();
        return cmdline;
    }

    public T makePyJob(String appName, List<SimpleKeyValue> conf, String pyFile, String ... args) {
        T cmdline = this.makeJob(appName, false, false, conf, args);
        ((SparkJob)cmdline).file = pyFile;
        return cmdline;
    }

    public T makeRJob(String appName, List<SimpleKeyValue> conf, String rFile, String ... args) {
        T cmdline = this.makeJob(appName, false, false, conf, args);
        ((SparkJob)cmdline).file = rFile;
        return cmdline;
    }

    protected Set<String> buildExcludedPluginFoldersList(File pluginsFolder) {
        HashSet keptComponentTypes = Sets.newHashSet();
        keptComponentTypes.add("python-formats");
        keptComponentTypes.add("python-fs-providers");
        keptComponentTypes.add("java-formats");
        keptComponentTypes.add("java-fs-providers");
        keptComponentTypes.add("jython-processors");
        HashSet excluded = Sets.newHashSet();
        for (String type : new String[]{"installed", "dev"}) {
            File pluginTypeFolder = new File(pluginsFolder, type);
            if (!pluginTypeFolder.exists() || !pluginTypeFolder.isDirectory()) continue;
            for (File pluginFolder : DKUFileUtils.listFiles((File)pluginTypeFolder)) {
                if (!pluginFolder.isDirectory()) continue;
                boolean keptSomething = false;
                for (File componentFolder : DKUFileUtils.listFiles((File)pluginFolder)) {
                    if (!componentFolder.isDirectory()) continue;
                    if (keptComponentTypes.contains(componentFolder.getName())) {
                        keptSomething = true;
                        continue;
                    }
                    excluded.add(type + "/" + pluginFolder.getName() + "/" + componentFolder.getName() + "/");
                }
                if (new File(pluginFolder, "lib").isDirectory()) {
                    keptSomething = true;
                }
                if (keptSomething) continue;
                excluded.add(type + "/" + pluginFolder.getName() + "/lib/");
                excluded.add(type + "/" + pluginFolder.getName() + "/java-lib/");
                excluded.add(type + "/" + pluginFolder.getName() + "/resource/");
            }
        }
        return excluded;
    }

    public static String safeGetLoginUserName() {
        try {
            Class<?> clazz = SparkJobHelper.class.getClassLoader().loadClass("org.apache.hadoop.security.UserGroupInformation");
            Object loginUser = clazz.getMethod("getLoginUser", new Class[0]).invoke(null, new Object[0]);
            return (String)loginUser.getClass().getMethod("getUserName", new Class[0]).invoke(loginUser, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return System.getProperty("user.name");
        }
    }

    public static String safeGetCurrentUserName() {
        try {
            Class<?> clazz = SparkJobHelper.class.getClassLoader().loadClass("org.apache.hadoop.security.UserGroupInformation");
            Object loginUser = clazz.getMethod("getCurrentUser", new Class[0]).invoke(null, new Object[0]);
            return (String)loginUser.getClass().getMethod("getUserName", new Class[0]).invoke(loginUser, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return System.getProperty("user.name");
        }
    }

    public static String safeGetLoginShortUserName() {
        try {
            Class<?> clazz = SparkJobHelper.class.getClassLoader().loadClass("org.apache.hadoop.security.UserGroupInformation");
            Object loginUser = clazz.getMethod("getLoginUser", new Class[0]).invoke(null, new Object[0]);
            return (String)loginUser.getClass().getMethod("getShortUserName", new Class[0]).invoke(loginUser, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return System.getProperty("user.name");
        }
    }

    public static String safeGetCurrentShortUserName() {
        try {
            Class<?> clazz = SparkJobHelper.class.getClassLoader().loadClass("org.apache.hadoop.security.UserGroupInformation");
            Object loginUser = clazz.getMethod("getCurrentUser", new Class[0]).invoke(null, new Object[0]);
            return (String)loginUser.getClass().getMethod("getShortUserName", new Class[0]).invoke(loginUser, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return System.getProperty("user.name");
        }
    }

    private static List<SimpleKeyValue> expandConf(AuthCtx authCtx, String projectKey, List<SimpleKeyValue> conf) {
        VariablesContext variablesContext = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForProjectAndUser(authCtx, projectKey);
        ArrayList<SimpleKeyValue> ret = new ArrayList<SimpleKeyValue>();
        for (SimpleKeyValue skv : conf) {
            ret.add(new SimpleKeyValue(skv.key, variablesContext.expandAllowUnresolved(skv.value), skv.secret));
        }
        return ret;
    }

    public static interface SparkJobPostProcessor {
        public void postProcess(SparkJobContext var1) throws Exception;
    }

    public static interface SparkJobContext
    extends AutoCloseable {
        public AuthCtx getAuthCtx();

        public String getJobId();

        public File getLocalRunDir();

        public boolean driverRunsRemotely();

        public boolean impersonatesRemotely();

        public String runAsHadoopUser() throws IOException;

        public RemoteRunEnvDef getRemoteRunEnvDef();

        public int doubleCheckRunStarted() throws Exception;

        public ComputeResourceUsage getComputeResourceUsage();
    }

    public static enum RunMode {
        SPARK,
        PYSPARK,
        SPARKR;

    }
}

