/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring.externalendpoint;

import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.connections.VertexAIModelDeploymentConnection;
import com.dataiku.dip.deployer.common.DeployerUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.ExternalInfraEndpoint;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.azureml.AzureMLInputValidator;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.externalinfras.databricks.DatabricksUtils;
import com.dataiku.dip.externalinfras.sagemaker.SageMakerInputValidator;
import com.dataiku.dip.externalinfras.sagemaker.SageMakerUtils;
import com.dataiku.dip.externalinfras.snowpark.SnowparkUtils;
import com.dataiku.dip.externalinfras.vertexai.VertexAIInputValidator;
import com.dataiku.dip.externalinfras.vertexai.VertexAIUtils;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.savedmodels.externalmodelidentifier.AzureMLEndpointIdentifier;
import com.dataiku.dip.savedmodels.externalmodelidentifier.DatabricksEndpointIdentifier;
import com.dataiku.dip.savedmodels.externalmodelidentifier.SagemakerEndpointIdentifier;
import com.dataiku.dip.savedmodels.externalmodelidentifier.SnowparkEndpointIdentifier;
import com.dataiku.dip.savedmodels.externalmodelidentifier.VertexAIEndpointIdentifier;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.MonitoredExternalApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.externalendpoint.UnifiedMonitoringExternalEndpointsScopeManager;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.NullChecker;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.dss.shadelib.javax.annotation.Nonnull;
import com.dataiku.dss.shadelib.org.checkerframework.common.aliasing.qual.Unique;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.SageMakerClient;
import com.dataiku.dss.shadelibgcp.com.google.auth.oauth2.GoogleCredentials;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

@PolyJSON(value={@Mapping(value=Sagemaker.class, type="SageMaker"), @Mapping(value=Snowpark.class, type="Snowflake"), @Mapping(value=AzureML.class, type="AzureML"), @Mapping(value=VertexAI.class, type="VertexAIModelDeployment"), @Mapping(value=Databricks.class, type="DatabricksModelDeployment")})
@UIModel
public abstract class UnifiedMonitoringExternalEndpointsScope {
    @Nonnull
    public @Unique String name;
    @Nonnull
    public String connectionName;
    @Nonnull
    public String stage;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.unifiedmonitoring.externalendpointscope");

    public abstract List<MonitoredExternalApiEndpoint> listEndpoints(AuthCtx var1) throws Exception;

    public abstract UnifiedMonitoringExternalEndpointsScopeManager<?> getScopeManager();

    public abstract void validate();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnifiedMonitoringExternalEndpointsScope that = (UnifiedMonitoringExternalEndpointsScope)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public abstract String getType();

    public boolean isActivityMonitoringSupported() {
        return true;
    }

    public static class Snowpark
    extends UnifiedMonitoringExternalEndpointsScope {
        public static final String TYPE = "Snowflake";
        @Nonnull
        public String snowflakeDatabase;
        @Nonnull
        public String snowflakeSchema;

        @Override
        public List<MonitoredExternalApiEndpoint> listEndpoints(AuthCtx user) throws Exception {
            logger.infoV("Starting to monitor third party endpoints on Snowpark connection scope %s", new Object[]{this.toString()});
            SnowflakeConnection connection = (SnowflakeConnection)ExternalInfrasUtils.getAndCheckConnection(user, this.connectionName);
            if (connection == null) {
                throw ErrorContext.icef((String)"Connection '%s' not found.", (Object)this.connectionName, (Object[])new Object[0]);
            }
            try (SQLConnectionProvider.SQLConnectionWrapper sqlConnectionWrapper = SnowparkUtils.createSQLWrapper_NT(connection, user, null, null, this.snowflakeDatabase, this.snowflakeSchema, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());){
                List<ExternalInfraEndpoint> externalInfraEndpoints = SnowparkUtils.listEndpoints_NT(sqlConnectionWrapper);
                List<MonitoredExternalApiEndpoint> list = externalInfraEndpoints.stream().map(externalEndpoint -> new MonitoredExternalApiEndpoint(externalEndpoint.name, externalEndpoint.resourceLink, externalEndpoint.deploymentHealth, externalEndpoint.deploymentHealthInfoMessages, SnowparkEndpointIdentifier.from(externalEndpoint.fullId), this)).collect(Collectors.toList());
                return list;
            }
        }

        public UnifiedMonitoringExternalEndpointsScopeManager.Snowpark getScopeManager() {
            return new UnifiedMonitoringExternalEndpointsScopeManager.Snowpark();
        }

        @Override
        public boolean isActivityMonitoringSupported() {
            return false;
        }

        @Override
        public void validate() {
            try {
                NullChecker.checkObject((Object)this);
            }
            catch (NullChecker.UnexpectedNullValue | IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid Snowflake external endpoints scope: %s", this), e);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Snowpark)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Snowpark snowpark = (Snowpark)o;
            return Objects.equals(this.snowflakeDatabase, snowpark.snowflakeDatabase) && Objects.equals(this.snowflakeSchema, snowpark.snowflakeSchema);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.snowflakeDatabase, this.snowflakeSchema);
        }

        public String toString() {
            return "Snowpark{snowflakeDatabase='" + this.snowflakeDatabase + "', snowflakeSchema='" + this.snowflakeSchema + "', name='" + this.name + "', connectionName='" + this.connectionName + "', stage='" + this.stage + "'}";
        }

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class Databricks
    extends UnifiedMonitoringExternalEndpointsScope {
        public static final String TYPE = "DatabricksModelDeployment";

        @Override
        public List<MonitoredExternalApiEndpoint> listEndpoints(AuthCtx user) throws Exception {
            logger.infoV("Starting to monitor third party endpoints on Databricks connection scope %s", new Object[]{this.toString()});
            List<ExternalInfraEndpoint> externalInfraEndpoints = DatabricksUtils.listExternalEndpoints(user, this.connectionName, DeployerUtils.getUnifiedMonitoringConnectTimeout(), DeployerUtils.getUnifiedMonitoringSocketTimeout());
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.connectionName), (Object)"The connection name cannot be null.");
            DatabricksModelDeploymentConnection connection = DatabricksUtils.retrieveMandatoryDatabricksConnection(user, this.connectionName);
            return externalInfraEndpoints.stream().map(externalEndpoint -> new MonitoredExternalApiEndpoint(externalEndpoint.name, externalEndpoint.resourceLink, externalEndpoint.deploymentHealth, externalEndpoint.deploymentHealthInfoMessages, new DatabricksEndpointIdentifier(externalEndpoint.id, connection.params.host, externalEndpoint.name), this)).collect(Collectors.toList());
        }

        public UnifiedMonitoringExternalEndpointsScopeManager.Databricks getScopeManager() {
            return new UnifiedMonitoringExternalEndpointsScopeManager.Databricks();
        }

        @Override
        public void validate() {
            try {
                NullChecker.checkObject((Object)this);
            }
            catch (NullChecker.UnexpectedNullValue | IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid Databricks external endpoints scope: %s", this), e);
            }
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return "Databricks{name='" + this.name + "', connectionName='" + this.connectionName + "', stage='" + this.stage + "'}";
        }

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class AzureML
    extends UnifiedMonitoringExternalEndpointsScope {
        public static final String TYPE = "AzureML";
        @Nonnull
        public String azSubscription;
        @Nonnull
        public String azResourceGroup;
        @Nonnull
        public String azWorkspace;

        @Override
        public List<MonitoredExternalApiEndpoint> listEndpoints(AuthCtx user) throws Exception {
            logger.infoV("Starting to monitor third party endpoints on Vertex AI connection scope %s", new Object[]{this.toString()});
            List<ExternalInfraEndpoint> externalInfraEndpoints = AzureMLUtils.listOnlineEndpoints_NT(user, this.connectionName, this.azWorkspace, this.azResourceGroup, this.azSubscription, DeployerUtils.getUnifiedMonitoringConnectTimeout(), DeployerUtils.getUnifiedMonitoringSocketTimeout());
            return externalInfraEndpoints.stream().map(externalEndpoint -> new MonitoredExternalApiEndpoint(externalEndpoint.name, externalEndpoint.resourceLink, externalEndpoint.deploymentHealth, externalEndpoint.deploymentHealthInfoMessages, new AzureMLEndpointIdentifier(externalEndpoint.name, this.azWorkspace, this.azResourceGroup, this.azSubscription), this)).collect(Collectors.toList());
        }

        public UnifiedMonitoringExternalEndpointsScopeManager.AzureML getScopeManager() {
            return new UnifiedMonitoringExternalEndpointsScopeManager.AzureML();
        }

        @Override
        public void validate() {
            try {
                NullChecker.checkObject((Object)this);
                AzureMLInputValidator.validateSubscriptionId(this.azSubscription);
                AzureMLInputValidator.validateResourceGroup(this.azResourceGroup);
                AzureMLInputValidator.validateWorkspace(this.azWorkspace);
            }
            catch (NullChecker.UnexpectedNullValue | IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid AzureML external endpoints scope: %s", this), e);
            }
        }

        @Override
        public String getType() {
            return TYPE;
        }

        public String toString() {
            return "AzureML{name='" + this.name + "', stage='" + this.stage + "', azSubscription='" + this.azSubscription + "', azResourceGroup='" + this.azResourceGroup + "', azWorkspace='" + this.azWorkspace + "', connectionName='" + this.connectionName + "'}";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AzureML azureML = (AzureML)o;
            return Objects.equals(this.azSubscription, azureML.azSubscription) && Objects.equals(this.azResourceGroup, azureML.azResourceGroup) && Objects.equals(this.azWorkspace, azureML.azWorkspace);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.azSubscription, this.azResourceGroup, this.azWorkspace);
        }
    }

    public static class VertexAI
    extends UnifiedMonitoringExternalEndpointsScope {
        public static final String TYPE = "VertexAIModelDeployment";
        @Nonnull
        public String gcpRegion;
        @Nonnull
        public String gcpProjectId;

        @Override
        public List<MonitoredExternalApiEndpoint> listEndpoints(AuthCtx user) throws IOException, URISyntaxException, DKUSecurityException {
            logger.infoV("Starting to monitor third party endpoints on Vertex AI connection scope %s", new Object[]{this.toString()});
            VertexAIModelDeploymentConnection connection = (VertexAIModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(user, this.connectionName);
            GoogleCredentials credentials = VertexAIUtils.getGoogleCredentials_NT(user, connection);
            List<ExternalInfraEndpoint> externalInfraEndpoints = VertexAIUtils.from(this.gcpRegion, this.gcpProjectId, credentials, connection).retrieveEndpoints_NT();
            return externalInfraEndpoints.stream().map(externalEndpoint -> new MonitoredExternalApiEndpoint(externalEndpoint.name, externalEndpoint.resourceLink, externalEndpoint.deploymentHealth, externalEndpoint.deploymentHealthInfoMessages, new VertexAIEndpointIdentifier(this.gcpProjectId, this.gcpRegion, externalEndpoint.id), this)).collect(Collectors.toList());
        }

        public UnifiedMonitoringExternalEndpointsScopeManager.VertexAI getScopeManager() {
            return new UnifiedMonitoringExternalEndpointsScopeManager.VertexAI();
        }

        @Override
        public void validate() {
            try {
                NullChecker.checkObject((Object)this);
                VertexAIInputValidator.validateProjectId(this.gcpProjectId);
                VertexAIInputValidator.validateRegionName(this.gcpRegion);
            }
            catch (NullChecker.UnexpectedNullValue | IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid VertexAI external endpoints scope: %s", this), e);
            }
        }

        @Override
        public String getType() {
            return TYPE;
        }

        public String toString() {
            return "VertexAI{name='" + this.name + "', stage='" + this.stage + "', gcpRegion='" + this.gcpRegion + "', gcpProjectId='" + this.gcpProjectId + "', connectionName='" + this.connectionName + "'}";
        }
    }

    public static class Sagemaker
    extends UnifiedMonitoringExternalEndpointsScope {
        public static final String TYPE = "SageMaker";
        @Nonnull
        public String region;

        @Override
        public List<MonitoredExternalApiEndpoint> listEndpoints(AuthCtx user) throws Exception {
            SageMakerClient sageMakerClient;
            logger.infoV("Starting to monitor third party endpoints on Sagemaker connection scope %s", new Object[]{this.toString()});
            try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Login on SageMaker...");){
                sageMakerClient = SageMakerUtils.checkAndLoginSageMaker_NT(user, this.connectionName, this.region, DeployerUtils.getUnifiedMonitoringConnectTimeout(), DeployerUtils.getUnifiedMonitoringSocketTimeout());
            }
            List<ExternalInfraEndpoint> externalInfraEndpoints = SageMakerUtils.listSageMakerEndpoints_NT(sageMakerClient, null, true, this.region);
            return externalInfraEndpoints.stream().map(externalEndpoint -> new MonitoredExternalApiEndpoint(externalEndpoint.name, externalEndpoint.resourceLink, externalEndpoint.deploymentHealth, externalEndpoint.deploymentHealthInfoMessages, new SagemakerEndpointIdentifier(externalEndpoint.fullId), this)).collect(Collectors.toList());
        }

        public UnifiedMonitoringExternalEndpointsScopeManager.SageMaker getScopeManager() {
            return new UnifiedMonitoringExternalEndpointsScopeManager.SageMaker();
        }

        @Override
        public void validate() {
            try {
                NullChecker.checkObject((Object)this);
                SageMakerInputValidator.validateRegionName(this.region);
            }
            catch (NullChecker.UnexpectedNullValue | IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid SageMaker external endpoints scope: %s", this), e);
            }
        }

        @Override
        public String getType() {
            return TYPE;
        }

        public String toString() {
            return "Sagemaker{name='" + this.name + "', stage='" + this.stage + "', region='" + this.region + "', connectionName='" + this.connectionName + "'}";
        }
    }
}

