/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.backend;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.autorestart.AutoRestartingProcessRunner;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.exposition.ExpositionRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLHandler;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.security.tickets.ContextAwareTicketPayload;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.git.jgit.GlobalObjectsJGitService;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppLaunchInfo;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.backend.AbstractWebAppDockerKernel;
import com.dataiku.dip.webapps.backend.AbstractWebAppKubernetesKernel;
import com.dataiku.dip.webapps.backend.AbstractWebAppLocalProcessKernel;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInfra;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendKernel;
import com.dataiku.dip.webapps.backend.WebAppBackendRunner;
import com.dataiku.dip.webapps.backend.WebAppRun;
import com.dataiku.dip.webapps.backend.WebAppRunContext;
import com.dataiku.dip.webapps.backend.exposition.WebAppExpositionHandlerThread;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractWebAppBackendRunner
implements WebAppBackendRunner,
ContextAwareTicketPayload {
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private WebAppRunContext webAppRunContext;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsJGitService projectsJGitService;
    @Autowired
    private GlobalObjectsJGitService globalObjectsJGitService;
    protected final AuthCtx authCtx;
    protected final WebApp webApp;
    protected final JsonObject userVariables;
    protected final WebAppBackend backend;
    protected final WebAppBackendInstance webAppBackendInstance;
    protected WebAppBackendKernel kernel;
    protected WebAppExpositionHandlerThread expositionThread;
    private WebAppRun webAppRun;
    private volatile boolean stopped = false;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.abstract");

    public AbstractWebAppBackendRunner(WebApp webApp, WebAppBackend backend, JsonObject userVariables, AuthCtx user, WebAppBackendInstance webAppBackendInstance) {
        this.backend = backend;
        this.webApp = webApp;
        this.userVariables = userVariables;
        this.authCtx = user;
        this.webAppBackendInstance = webAppBackendInstance;
        SpringUtils.getInstance().autowire((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(String runId) throws Exception {
        this.webAppRunContext.startLogAppender();
        this.webAppRun = new WebAppRun(this.webApp, runId);
        File workingDir = WebAppRunContext.webAppRunFolder(this.webAppRun);
        if (workingDir.exists()) {
            FilesystemACLUtils.grantFSFullACLs(this.authCtx, this.webApp.projectKey, workingDir);
            DKUFileUtils.forceDelete((File)workingDir);
        }
        DKUFileUtils.mkdirs((File)workingDir);
        try (WebAppRunContext.ActiveWebAppRunContext activeRun = this.webAppRunContext.useWebAppRun(this.webAppRun);){
            this.runInternal(this.webAppRun);
        }
        finally {
            this.webAppRun.closeLogs();
        }
    }

    public AutoCloseable openTicketContext() {
        return new WebAppRunTicketUsage();
    }

    private void runInternal(WebAppRun webAppRun) throws Exception {
        logger.info((Object)"Running web app backend");
        WebAppLaunchInfo launchInfo = WebAppLaunchInfo.create(this.authCtx, this.webApp, this.webAppBackendInstance.instanceId);
        WebAppSecurityInfo securityInfo = WebAppSecurityInfo.create(this.webApp);
        WebAppBackendInfra infra = this.webApp.params.infra;
        ContainerExecSelection containerSelection = infra.containerSelection;
        ContainerExecRuntimeConfig containerConfig = new ContainerExecConfigSelector().select_autoTXN(this.authCtx, this.webApp.getProjectKey(), containerSelection);
        Exposition exposition = infra.getEffectiveExposition(this.authCtx, this.webApp.getProjectKey(), containerConfig);
        File workingDir = WebAppRunContext.webAppRunFolder(this.webAppRunContext.getWebAppRun());
        WebAppPersistedState persistedState = new WebAppPersistedState();
        persistedState.webApp = this.webApp;
        persistedState.containerConfig = containerConfig;
        persistedState.exposition = exposition;
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            persistedState.projectHeadCommitIdAtStart = this.projectsJGitService.getHashOf(this.webApp.projectKey, "HEAD");
            persistedState.globalHeadCommitIdAtStart = this.globalObjectsJGitService.getHashOf("HEAD");
        }
        JSON.prettyToFile((Object)persistedState, (File)new File(workingDir, "state.json"));
        boolean backendForcesAuthentication = securityInfo != null && (securityInfo.backendCheckAccess || securityInfo.hideAccessToken);
        this.backend.setSecurityInfo(this.getSecurityInfoForBackend(securityInfo, containerConfig), backendForcesAuthentication);
        APITicketService.Ticket ticket = this.apiTicketService.createTicket(this.authCtx, "Standard webapp backend: " + this.webApp.getFullId(), (Object)this);
        ticket.localFolderAwareWorkload = new APITicketService.LocalFolderAwareWorkload(APITicketService.LocalFolderAwareWorkloadType.WEBAPP, this.webApp.projectKey, this.webApp.id);
        new FilesystemACLHandler().ensureStudioPrivate(workingDir);
        FilesystemACLUtils.grantFSFullACLs(this.authCtx, this.webApp.projectKey, workingDir);
        VariablesContext variablesContext = this.variablesService.getForProject(this.webApp.projectKey);
        ExpositionMeta expositionMeta = ExpositionRegistry.getMeta(exposition);
        expositionMeta.expandParametersInPlace(variablesContext, exposition);
        ExpositionHandler expositionHandler = expositionMeta.buildHandler(this.authCtx, this.webApp.projectKey, containerConfig, exposition, this.backend);
        try {
            DKUtils.RotatingAttachableLoggingSubscription backendLog = new DKUtils.RotatingAttachableLoggingSubscription(workingDir, "backend.log", 3, 0x200000L);
            try {
                DKUtils.RotatingAttachableLoggingSubscription setupLog = new DKUtils.RotatingAttachableLoggingSubscription(workingDir, "setup.log", 3, 0x200000L);
                try {
                    DKUtils.RotatingAttachableLoggingSubscription expositionLog = new DKUtils.RotatingAttachableLoggingSubscription(workingDir, "exposition.log", 3, 0x200000L);
                    try {
                        DKUtils.SmartLogTailBuilder smartLogTailBuilder = new DKUtils.SmartLogTailBuilder();
                        this.kernel = this.createKernel(launchInfo, securityInfo, containerConfig, ticket, workingDir, (DKUtils.LineSubscriptionAttacher)backendLog, (DKUtils.LineSubscriptionAttacher)setupLog, smartLogTailBuilder);
                        try {
                            try {
                                WebAppBackendKernel.MainKernelProcess mainKernelProcess;
                                if (new File(workingDir, "error.json").isFile()) {
                                    DKUFileUtils.forceDelete((File)new File(workingDir, "error.json"));
                                }
                                if (!((mainKernelProcess = this.kernel.prepareRun(this.webAppBackendInstance, expositionHandler.getExpectedExposedEndpoint())) instanceof Exposables.Exposable)) {
                                    throw new Exception("Invalid setup, main process is not exposable: " + mainKernelProcess.getClass().getCanonicalName());
                                }
                                expositionHandler.init((Exposables.Exposable)((Object)mainKernelProcess), this.webAppBackendInstance);
                                if (new File(workingDir, "exposable.json").isFile()) {
                                    DKUFileUtils.forceDelete((File)new File(workingDir, "exposable.json"));
                                }
                                JSON.prettyToFile((Object)mainKernelProcess.getExposableInfo(), (File)new File(workingDir, "exposable.json"));
                                this.expositionThread = new WebAppExpositionHandlerThread(this.webApp, this.backend, this.webAppBackendInstance, expositionHandler, (DKUtils.LineSubscriptionAttacher)expositionLog, smartLogTailBuilder);
                                this.expositionThread.start();
                                this.kernel.run(mainKernelProcess);
                                logger.info((Object)"Backend terminated without kernel.run throwing an exception, trying to find more details");
                                if (new File(workingDir, "error.json").isFile()) {
                                    logger.warn((Object)"Found error file");
                                    APIError se = (APIError)JSON.parseFile((File)new File(workingDir, "error.json"), APIError.class);
                                    throw new APIError.APIErrorException(se);
                                }
                                if (this.kernel.getWebAppProcessRunException() != null) {
                                    throw this.kernel.getWebAppProcessRunException();
                                }
                                if (this.stopped) {
                                    throw new IOException("Backend terminated for webapp stop");
                                }
                                throw new IOException("Backend terminated without kernel.run throwing an exception, unexpected");
                            }
                            catch (Exception e) {
                                logger.error((Object)"Exception while running the kernel", (Throwable)e);
                                if (this.expositionThread != null && this.expositionThread.hasStarted()) {
                                    logger.info((Object)"The exposition had received the port, so the kernel died during normal runtime. Will be restarted by the loop");
                                    throw new AutoRestartingProcessRunner.BackendDiedException("Backend died while running", e, this.kernel.getLogTail());
                                }
                                logger.warn((Object)"The exposition had not received the port, so the kernel died during start. Will not be restarted by the loop");
                                throw new AutoRestartingProcessRunner.BackendStartFailedException("Backend died before startup complete", e, this.kernel.getLogTail());
                            }
                        }
                        catch (Throwable throwable) {
                            this.kernel.kill();
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            expositionLog.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        setupLog.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                try {
                    backendLog.close();
                }
                catch (Throwable throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            expositionHandler.cleanup();
            this.apiTicketService.expireTicket(ticket);
            throw throwable;
        }
    }

    protected WebAppSecurityInfo getSecurityInfoForBackend(WebAppSecurityInfo securityInfo, ContainerExecRuntimeConfig containerConfig) {
        if (containerConfig == null) {
            return securityInfo;
        }
        if (containerConfig.type == ContainerExecRuntimeConfig.Container.DOCKER || containerConfig.type == ContainerExecRuntimeConfig.Container.KUBERNETES) {
            WebAppSecurityInfo ret = new WebAppSecurityInfo();
            ret.vanityURL = securityInfo.vanityURL;
            ret.redirectMode = securityInfo.redirectMode;
            ret.studioUrl = securityInfo.studioUrl;
            return ret;
        }
        throw new NotImplementedException("Container of type " + String.valueOf((Object)containerConfig.type) + " is not handled");
    }

    protected abstract WebAppBackendKernel createKernel(WebAppLaunchInfo var1, WebAppSecurityInfo var2, ContainerExecRuntimeConfig var3, APITicketService.Ticket var4, File var5, DKUtils.LineSubscriptionAttacher var6, DKUtils.LineSubscriptionAttacher var7, DKUtils.SmartLogTailBuilder var8);

    protected Exposables.Exposable cleanupExposable(WebAppLaunchInfo launchInfo, ContainerExecRuntimeConfig containerConfig, File workingDir, DKUtils.RotatingAttachableLoggingSubscription setupLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
        JsonObject exposableInfo;
        File exposableInfoFile = new File(workingDir, "exposable.json");
        if (exposableInfoFile.exists() && exposableInfoFile.canRead()) {
            try {
                exposableInfo = (JsonObject)JSON.parseFile((File)exposableInfoFile, JsonObject.class);
            }
            catch (IOException e) {
                logger.warn((Object)"Unable to re-read exposition info", (Throwable)e);
                exposableInfo = new JsonObject();
            }
        } else {
            exposableInfo = new JsonObject();
        }
        if (containerConfig == null) {
            return AbstractWebAppLocalProcessKernel.cleanupKernel(this.webApp, launchInfo, workingDir, setupLog, smartLogTailBuilder);
        }
        if (containerConfig.type == ContainerExecRuntimeConfig.Container.DOCKER) {
            return AbstractWebAppDockerKernel.cleanupKernel(this.webApp, launchInfo, containerConfig, workingDir, setupLog, smartLogTailBuilder, exposableInfo);
        }
        if (containerConfig.type == ContainerExecRuntimeConfig.Container.KUBERNETES) {
            return AbstractWebAppKubernetesKernel.cleanupKernel(this.authCtx, this.webApp, containerConfig, launchInfo, workingDir, setupLog, smartLogTailBuilder, exposableInfo);
        }
        return null;
    }

    public static File getWebAppRunDir(String projectKey, String webAppId, String runId) {
        return WebAppRunContext.webAppRunFolder(projectKey, webAppId, runId);
    }

    public static File getWebAppBaseRunDir(String projectKey, String webAppId) {
        return WebAppRunContext.webAppFolder(projectKey, webAppId);
    }

    public static File getLatestWebAppRunDir(String projectKey, String webAppId) {
        File webAppBaseRunDir = AbstractWebAppBackendRunner.getWebAppBaseRunDir(projectKey, webAppId);
        return DKUFileUtils.newestFile((File)webAppBaseRunDir, (String)"run_");
    }

    @Override
    public SmartLogTail getLogTail() {
        if (this.kernel != null) {
            return this.kernel.getLogTail();
        }
        return null;
    }

    @Override
    public Integer getPid() {
        if (this.kernel != null) {
            return this.kernel.getPid();
        }
        return null;
    }

    @Override
    public void stop() {
        this.stopped = true;
        if (this.expositionThread != null) {
            this.expositionThread.kill();
        }
        if (this.kernel != null) {
            this.kernel.kill();
        }
        if (this.webApp.isVirtual) {
            this.webAppsService.cleanupStoppedVirtualWebapp(this.webApp.getProjectKey(), this.webApp.getId());
        }
    }

    @Override
    public void stopDanglingRun(String runId) throws Exception {
        logger.info((Object)"Stop backend from previous runs if not already stopped");
        WebAppLaunchInfo launchInfo = WebAppLaunchInfo.create(this.authCtx, this.webApp, this.webAppBackendInstance.instanceId);
        WebAppBackendInfra infra = this.webApp.params.infra;
        ContainerExecSelection containerSelection = infra.containerSelection;
        ContainerExecRuntimeConfig containerConfig = new ContainerExecConfigSelector().select_autoTXN(this.authCtx, this.webApp.getProjectKey(), containerSelection);
        Exposition exposition = infra.getEffectiveExposition(this.authCtx, this.webApp.getProjectKey(), containerConfig);
        File workingDir = WebAppRunContext.webAppRunFolder(new WebAppRun(this.webApp, runId));
        DKUFileUtils.mkdirs((File)workingDir);
        VariablesContext variablesContext = this.variablesService.getForProject(this.webApp.projectKey);
        ExpositionMeta expositionMeta = ExpositionRegistry.getMeta(exposition);
        expositionMeta.expandParametersInPlace(variablesContext, exposition);
        ExpositionHandler expositionHandlerForCleanup = expositionMeta.buildHandler(this.authCtx, this.webApp.projectKey, containerConfig, exposition, this.backend);
        try (DKUtils.RotatingAttachableLoggingSubscription setupLog = new DKUtils.RotatingAttachableLoggingSubscription(workingDir, "setup.log", 3, 0x200000L);){
            DKUtils.SmartLogTailBuilder smartLogTailBuilder = new DKUtils.SmartLogTailBuilder();
            Exposables.Exposable cleanupedExposable = this.cleanupExposable(launchInfo, containerConfig, workingDir, setupLog, smartLogTailBuilder);
            if (cleanupedExposable == null) {
                throw new Exception("Could not reconstruct object for webapp backend to cleanup");
            }
            expositionHandlerForCleanup.init(cleanupedExposable, this.webAppBackendInstance);
            expositionHandlerForCleanup.cleanup();
        }
    }

    @Override
    public WebApp getWebApp() {
        return this.webApp;
    }

    @Override
    public void gatherFilesForDiagnostic(File runDir, String runId) {
        if (this.webAppRun == null || !StringUtils.equals((String)runId, (String)this.webAppRun.runId)) {
            logger.warn((Object)"Current runner has a different runId, don't attempt to grab additional files");
        }
        if (this.kernel != null) {
            this.kernel.gatherFilesForDiagnostic(runDir);
        }
    }

    private class WebAppRunTicketUsage
    implements AutoCloseable {
        private final WebAppRun previousWebAppRun;

        WebAppRunTicketUsage() {
            this.previousWebAppRun = AbstractWebAppBackendRunner.this.webAppRunContext.getWebAppRun();
            AbstractWebAppBackendRunner.this.webAppRunContext.setWebappRun(AbstractWebAppBackendRunner.this.webAppRun);
        }

        @Override
        public void close() {
            AbstractWebAppBackendRunner.this.webAppRunContext.setWebappRun(this.previousWebAppRun);
        }
    }

    public class WebAppPersistedState {
        public WebApp webApp;
        public ContainerExecRuntimeConfig containerConfig;
        public Exposition exposition;
        public String globalHeadCommitIdAtStart;
        public String projectHeadCommitIdAtStart;
    }
}

