/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.bokeh.backend;

import com.dataiku.dip.autorestart.AutoRestartingProcessRunner;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IImpersonatedKernel;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppLaunchInfo;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.backend.AbstractWebAppLocalProcessKernel;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendKernel;
import com.dataiku.dip.webapps.bokeh.BokehWebAppMeta;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;

public class BokehWebAppLocalKernel
extends AbstractWebAppLocalProcessKernel
implements IImpersonatedKernel {
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private ImpersonationResolverService impersonationResolverService;
    @Autowired
    private CodeEnvResolutionService codeEnvResolutionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.bokeh");

    public BokehWebAppLocalKernel(WebApp webApp, AuthCtx authCtx, JsonObject userVariables, WebAppLaunchInfo launchInfo, WebAppSecurityInfo securityInfo, File workingDir, APITicketService.Ticket ticket, DKUtils.LineSubscriptionAttacher backendLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
        super(webApp, authCtx, workingDir, backendLog, smartLogTailBuilder, userVariables, launchInfo, securityInfo, ticket);
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected String getLogPrefix() {
        return "[local] ";
    }

    @Override
    protected boolean impersonate() {
        return true;
    }

    private List<String> getRunCmd(File appFolder) throws AutoRestartingProcessRunner.BackendStartFailedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(appFolder.getAbsolutePath());
        cmd.add(Integer.toString(this.webApp.getParamsAs(BokehWebAppMeta.BokehWebAppParams.class).nbProcesses));
        try {
            ArrayList args = Lists.newArrayList((Object[])new String[]{"-m", "dataiku.webapps.run_bokeh"});
            args.addAll(cmd);
            return this.codeEnvResolutionService.getPythonCmd(this.launchInfo.envName, this.webApp.projectKey, args);
        }
        catch (IOException e) {
            throw new AutoRestartingProcessRunner.BackendStartFailedException("Unable to start code env for bokeh", e, null);
        }
    }

    private File writeBokehApp() throws IOException {
        BokehWebAppMeta.BokehWebAppParams params = this.webApp.getParamsAs(BokehWebAppMeta.BokehWebAppParams.class);
        Map variables = this.variablesService.getForProject(this.webApp.projectKey).getAllVariables();
        String python = StrSubstitutor.replace((Object)params.python, (Map)variables);
        File appFolder = new File(this.workingDir, "backend");
        FileUtils.forceMkdir((File)appFolder);
        FileUtils.write((File)new File(appFolder, "main.py"), (CharSequence)python, (String)"utf8");
        return appFolder;
    }

    @Override
    public WebAppBackendKernel.MainKernelProcess prepareRun(WebAppBackendInstance webAppBackendInstance, ExposedEndpointConsumer.ExposedEndpoint expectedExposedEndpoint) throws Exception {
        File appFolder = this.writeBokehApp();
        List<String> cmd = this.getRunCmd(appFolder);
        logger.info((Object)("Bokeh start command: " + cmd.toString()));
        HashMap<String, String> libs = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)this.launchInfo.pythonLibFolder)) {
            libs.put("python-lib", this.launchInfo.pythonLibFolder);
        }
        ProcessBuilder builder = this.getProcessBuilder(cmd, true, libs, this.impersonationResolverService);
        builder.environment().putAll(this.codeEnvResolutionService.getEnvironmentVariablesForPythonCmd(this.launchInfo.envName, this.webApp.projectKey));
        return new WebAppBackendKernel.LocalMainKernelProcess(builder, this.outputConsumer, this.workingDir, this.securityInfo);
    }
}

