/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.client;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SnowparkAPIDeploymentInfra;
import com.dataiku.dip.deployer.common.DeployerUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.snowpark.SnowparkUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.client.BaseLambdaAPIClient;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.log4j.Logger;

public class SnowparkLambdaAPIClient
implements BaseLambdaAPIClient {
    private static final Logger logger = Logger.getLogger((String)"dku.lambda.test.snowpark");

    private SnowparkLambdaAPIClient() {
    }

    public static BaseLambdaAPIClient.ApiEndpointResponses runQueries_NT(AuthCtx authCtx, SnowparkAPIDeploymentInfra infra, String udfName, Collection<ApiEndpointQuery> queries, boolean forTest) throws IOException, DKUSecurityException, SQLException, InterruptedException {
        SnowflakeConnection connection = (SnowflakeConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, infra.authConnection);
        if (connection == null) {
            throw ErrorContext.icef((String)"Connection '%s' not found.", (Object)infra.authConnection, (Object[])new Object[0]);
        }
        try (SQLConnectionProvider.SQLConnectionWrapper sqlWrapper = SnowparkUtils.createSQLWrapper_NT(connection, authCtx, infra, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());){
            BaseLambdaAPIClient.ApiEndpointResponses apiEndpointResponses = new BaseLambdaAPIClient.ApiEndpointResponses();
            for (ApiEndpointQuery tq : queries) {
                BaseLambdaAPIClient.ResponseOrError roe = new BaseLambdaAPIClient.ResponseOrError();
                roe.query = tq;
                String queryJSON = JSON.json((Object)tq.q);
                try {
                    logger.debug((Object)("Submit query with name `" + tq.name + "` and body `" + queryJSON + "` to Snowpark UDF " + udfName));
                    String responseString = SnowparkUtils.callUdf_NT(sqlWrapper, udfName, queryJSON);
                    roe.response = JSON.parse((String)responseString, JsonObject.class);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failure while trying to send Query " + queryJSON + " to Snowpark UDF " + udfName + "."), (Throwable)e);
                    roe.error = new SerializedError((Throwable)e, !DKUApp.hideErrorStacks(), !DKUApp.hideErrorStacks(), !DKUApp.hideLogTails());
                }
                apiEndpointResponses.responses.add(roe);
            }
            BaseLambdaAPIClient.ApiEndpointResponses apiEndpointResponses2 = apiEndpointResponses;
            return apiEndpointResponses2;
        }
    }
}

