/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.math;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class Combin
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length != 2) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects two numbers");
        }
        if (args[0] == null || !(args[0] instanceof Number)) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects the first argument to be a number");
        }
        if (args[1] == null || !(args[1] instanceof Number)) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects the second argument to be a number");
        }
        return Combin.combination(((Number)args[0]).intValue(), ((Number)args[1]).intValue());
    }

    public static long combination(int n, int k) {
        int i;
        long[][] binomial = new long[n + 1][k + 1];
        for (int j = 1; j <= k; ++j) {
            binomial[0][j] = 0L;
        }
        for (i = 0; i <= n; ++i) {
            binomial[i][0] = 1L;
        }
        for (i = 1; i <= n; ++i) {
            for (int j = 1; j <= k; ++j) {
                binomial[i][j] = binomial[i - 1][j - 1] + binomial[i - 1][j];
                if (binomial[i][j] <= Long.MAX_VALUE && binomial[i][j] >= 0L) continue;
                throw new RuntimeException("Range limit exceeded");
            }
        }
        return binomial[n][k];
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Combin.DOCUMENTATION", "Returns the number of combinations for n elements divided into groups of k: <code>n!/k!(n-k)!</code>.").withParams("number n, number k").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("6", "2").returns("15"));
    }
}

