/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class IndexOf
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2) {
            Object s1 = args[0];
            Object s2 = args[1];
            if (s1 instanceof String && s2 instanceof String) {
                return ((String)s1).indexOf((String)s2);
            }
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects 2 strings");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.IndexOf.DOCUMENTATION", "Returns the index of the first occurrence of <code>sub</code> in <code>s</code>. Index begins at 0. Returns -1 if there is no such occurrence.").withParams("string s, string sub").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"hello world\"", "\"world\"").returns("6"));
    }
}

