/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.client;

import com.dataiku.dss.shadeliba2a.io.a2a.spec.A2AClientError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.A2AClientInvalidArgsError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.A2AClientInvalidStateError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.Message;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.Task;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskArtifactUpdateEvent;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskState;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskStatus;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskStatusUpdateEvent;
import com.dataiku.dss.shadeliba2a.io.a2a.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jspecify.annotations.Nullable;

public class ClientTaskManager {
    private @Nullable Task currentTask = null;
    private @Nullable String taskId = null;
    private @Nullable String contextId = null;

    public Task getCurrentTask() throws A2AClientInvalidStateError {
        if (this.currentTask == null) {
            throw new A2AClientInvalidStateError("No current task");
        }
        return this.currentTask;
    }

    public Task saveTaskEvent(Task task) throws A2AClientInvalidArgsError {
        if (this.currentTask != null) {
            throw new A2AClientInvalidArgsError("Task is already set, create new manager for new tasks.");
        }
        this.saveTask(task);
        return task;
    }

    public Task saveTaskEvent(TaskStatusUpdateEvent taskStatusUpdateEvent) throws A2AClientError {
        Task task;
        if (this.taskId == null) {
            this.taskId = taskStatusUpdateEvent.getTaskId();
        }
        if (this.contextId == null) {
            this.contextId = taskStatusUpdateEvent.getContextId();
        }
        if ((task = this.currentTask) == null) {
            task = new Task.Builder().status(new TaskStatus(TaskState.UNKNOWN)).id(this.taskId).contextId(this.contextId == null ? "" : this.contextId).build();
        }
        Task.Builder taskBuilder = new Task.Builder(task);
        if (taskStatusUpdateEvent.getStatus().message() != null) {
            if (task.getHistory() == null) {
                taskBuilder.history(taskStatusUpdateEvent.getStatus().message());
            } else {
                ArrayList<Message> history = new ArrayList<Message>(task.getHistory());
                history.add(taskStatusUpdateEvent.getStatus().message());
                taskBuilder.history(history);
            }
        }
        if (taskStatusUpdateEvent.getMetadata() != null) {
            HashMap<String, Object> newMetadata = task.getMetadata() != null ? new HashMap<String, Object>(task.getMetadata()) : new HashMap();
            newMetadata.putAll(taskStatusUpdateEvent.getMetadata());
            taskBuilder.metadata(newMetadata);
        }
        taskBuilder.status(taskStatusUpdateEvent.getStatus());
        this.currentTask = taskBuilder.build();
        return this.currentTask;
    }

    public Task saveTaskEvent(TaskArtifactUpdateEvent taskArtifactUpdateEvent) {
        Task task;
        if (this.taskId == null) {
            this.taskId = taskArtifactUpdateEvent.getTaskId();
        }
        if (this.contextId == null) {
            this.contextId = taskArtifactUpdateEvent.getContextId();
        }
        if ((task = this.currentTask) == null) {
            task = new Task.Builder().status(new TaskStatus(TaskState.UNKNOWN)).id(this.taskId).contextId(this.contextId == null ? "" : this.contextId).build();
        }
        this.currentTask = Utils.appendArtifactToTask(task, taskArtifactUpdateEvent, this.taskId);
        return this.currentTask;
    }

    public Task updateWithMessage(Message message, Task task) {
        Task.Builder taskBuilder = new Task.Builder(task);
        List<Message> history = task.getHistory();
        if (history == null) {
            history = new ArrayList<Message>();
        }
        if (task.getStatus().message() != null) {
            history.add(task.getStatus().message());
            taskBuilder.status(new TaskStatus(task.getStatus().state(), null, task.getStatus().timestamp()));
        }
        history.add(message);
        taskBuilder.history(history);
        this.currentTask = taskBuilder.build();
        return this.currentTask;
    }

    private void saveTask(Task task) {
        this.currentTask = task;
        if (this.taskId == null) {
            this.taskId = this.currentTask.getId();
            this.contextId = this.currentTask.getContextId();
        }
    }
}

