/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.client.transport.rest;

import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.core.JsonProcessingException;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.databind.ObjectMapper;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.dataiku.dss.shadeliba2a.io.a2a.client.http.A2AHttpResponse;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.A2AClientException;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.AuthenticatedExtendedCardNotConfiguredError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.ContentTypeNotSupportedError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.InternalError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.InvalidAgentResponseError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.InvalidParamsError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.InvalidRequestError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.JSONParseError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.MethodNotFoundError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.PushNotificationNotSupportedError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskNotCancelableError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskNotFoundError;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.UnsupportedOperationError;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RestErrorMapper {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule(new JavaTimeModule());

    public static A2AClientException mapRestError(A2AHttpResponse response) {
        return RestErrorMapper.mapRestError(response.body(), response.status());
    }

    public static A2AClientException mapRestError(String body, int code) {
        try {
            if (body != null && !body.isBlank()) {
                JsonNode node = OBJECT_MAPPER.readTree(body);
                String className = node.findValue("error").asText();
                String errorMessage = node.findValue("message").asText();
                return RestErrorMapper.mapRestError(className, errorMessage, code);
            }
            return RestErrorMapper.mapRestError("", "", code);
        }
        catch (JsonProcessingException ex) {
            Logger.getLogger(RestErrorMapper.class.getName()).log(Level.SEVERE, null, ex);
            return new A2AClientException("Failed to parse error response: " + ex.getMessage());
        }
    }

    public static A2AClientException mapRestError(String className, String errorMessage, int code) {
        return switch (className) {
            case "com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskNotFoundError" -> new A2AClientException(errorMessage, new TaskNotFoundError());
            case "com.dataiku.dss.shadeliba2a.io.a2a.spec.AuthenticatedExtendedCardNotConfiguredError" -> new A2AClientException(errorMessage, new AuthenticatedExtendedCardNotConfiguredError());
            case "com.dataiku.dss.shadeliba2a.io.a2a.spec.ContentTypeNotSupportedError" -> new A2AClientException(errorMessage, new ContentTypeNotSupportedError(null, null, errorMessage));
            case "com.dataiku.dss.shadeliba2a.io.a2a.spec.InternalError" -> new A2AClientException(errorMessage, new InternalError(errorMessage));
            case "com.dataiku.dss.shadeliba2a.io.a2a.spec.InvalidAgentResponseError" -> new A2AClientException(errorMessage, new InvalidAgentResponseError(null, null, errorMessage));
            case "com.dataiku.dss.shadeliba2a.io.a2a.spec.InvalidParamsError" -> new A2AClientException(errorMessage, new InvalidParamsError());
            case "com.dataiku.dss.shadeliba2a.io.a2a.spec.InvalidRequestError" -> new A2AClientException(errorMessage, new InvalidRequestError());
            case "com.dataiku.dss.shadeliba2a.io.a2a.spec.JSONParseError" -> new A2AClientException(errorMessage, new JSONParseError());
            case "com.dataiku.dss.shadeliba2a.io.a2a.spec.MethodNotFoundError" -> new A2AClientException(errorMessage, new MethodNotFoundError());
            case "com.dataiku.dss.shadeliba2a.io.a2a.spec.PushNotificationNotSupportedError" -> new A2AClientException(errorMessage, new PushNotificationNotSupportedError());
            case "com.dataiku.dss.shadeliba2a.io.a2a.spec.TaskNotCancelableError" -> new A2AClientException(errorMessage, new TaskNotCancelableError());
            case "com.dataiku.dss.shadeliba2a.io.a2a.spec.UnsupportedOperationError" -> new A2AClientException(errorMessage, new UnsupportedOperationError());
            default -> new A2AClientException(errorMessage);
        };
    }
}

