/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.server.util.async;

import com.dataiku.dss.shadeliba2a.io.a2a.server.config.A2AConfigProvider;
import com.dataiku.dss.shadeliba2a.io.a2a.server.util.async.Internal;
import com.dataiku.dss.shadeliba2a.jakarta.annotation.PostConstruct;
import com.dataiku.dss.shadeliba2a.jakarta.annotation.PreDestroy;
import com.dataiku.dss.shadeliba2a.jakarta.enterprise.context.ApplicationScoped;
import com.dataiku.dss.shadeliba2a.jakarta.enterprise.inject.Produces;
import com.dataiku.dss.shadeliba2a.jakarta.inject.Inject;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class AsyncExecutorProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncExecutorProducer.class);
    @Inject
    A2AConfigProvider configProvider;
    int corePoolSize;
    int maxPoolSize;
    long keepAliveSeconds;
    private ExecutorService executor;

    @PostConstruct
    public void init() {
        this.corePoolSize = Integer.parseInt(this.configProvider.getValue("a2a.executor.core-pool-size"));
        this.maxPoolSize = Integer.parseInt(this.configProvider.getValue("a2a.executor.max-pool-size"));
        this.keepAliveSeconds = Long.parseLong(this.configProvider.getValue("a2a.executor.keep-alive-seconds"));
        LOGGER.info("Initializing async executor: corePoolSize={}, maxPoolSize={}, keepAliveSeconds={}", new Object[]{this.corePoolSize, this.maxPoolSize, this.keepAliveSeconds});
        this.executor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveSeconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new A2AThreadFactory());
    }

    @PreDestroy
    public void close() {
        LOGGER.info("Shutting down async executor");
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOGGER.warn("Executor did not terminate in 10 seconds, forcing shutdown");
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted while waiting for executor shutdown", (Throwable)e);
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Produces
    @Internal
    public Executor produce() {
        return this.executor;
    }

    private static class A2AThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix = "a2a-agent-executor-";

        private A2AThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "a2a-agent-executor-" + this.threadNumber.getAndIncrement());
            t.setDaemon(false);
            return t;
        }
    }
}

