/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.admin;

import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.lambda.auth.ApiNodeAuthVerificationService;
import com.dataiku.lambda.codeenvs.CodeEnvsService;
import com.dataiku.lambda.server.LambdaAPIControllerBase;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class CodeEnvsAdminController
extends LambdaAPIControllerBase {
    @Autowired
    private ApiNodeAuthVerificationService authService;
    @Autowired
    private CodeEnvsService codeEnvsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.admin.api");

    @AuditedCall(value={"msgType", "api-codeenvs-import", "fileDir", "${fileDir}", "language", "${language}"})
    @RequestMapping(value={"/admin/api/cached-code-envs"}, method={RequestMethod.POST})
    public void createCodeEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fileDir, @RequestParam String language) throws Exception {
        this.authService.checkAdmin(req);
        if (!FeatureFlags.isEnabled((String)"apinode_codeenvs_global_cache")) {
            logger.info((Object)"Global cache not enabled, not creating the code env");
            throw new UnsupportedOperationException("Global cache not enabled");
        }
        logger.infoV("Creating the %s code env from archive %s in global cache", new Object[]{language, fileDir});
        File codeEnvDir = this.codeEnvsService.createCodeEnv(fileDir, language);
        logger.infoV("Code env %s from archive %s created in global cache dir %s", new Object[]{language, fileDir, codeEnvDir.getAbsolutePath()});
        this.writeSimpleOK(resp);
    }

    @AuditedCall(value={"msgType", "api-codeenvs-register", "fileDir", "${fileDir}", "language", "${language}"})
    @RequestMapping(value={"/admin/api/register-global-code-env"}, method={RequestMethod.POST})
    public void registerCodeEnv(HttpServletRequest req, HttpServletResponse resp, @RequestParam String exportedEnvDir, @RequestParam String builtEnvDir, @RequestParam String language) throws Exception {
        this.authService.checkAdmin(req);
        if (!FeatureFlags.isEnabled((String)"apinode_codeenvs_global_cache")) {
            logger.info((Object)"Global cache not enabled, not creating the code env");
            throw new UnsupportedOperationException("Global cache not enabled");
        }
        logger.infoV("Registering the %s code env whose exported desc is in %s and built directory is %s", new Object[]{language, exportedEnvDir, builtEnvDir});
        File codeEnvDir = this.codeEnvsService.registerCodeEnv(language, exportedEnvDir, builtEnvDir);
        logger.infoV("%s code env with desc in %s available in %s registered as %s", new Object[]{language, exportedEnvDir, builtEnvDir, codeEnvDir});
        this.writeSimpleOK(resp);
    }

    @AuditedCall(value={"msgType", "api-codeenvs-clean-cache"})
    @RequestMapping(value={"/admin/api/cached-code-envs"}, method={RequestMethod.DELETE})
    public void cleanCodeEnvCache(HttpServletRequest req, HttpServletResponse resp) throws IOException, DKUSecurityException {
        this.authService.checkAdmin(req);
        CodeEnvsAdminController.writeJSON(resp, this.codeEnvsService.cleanUnused());
    }
}

