/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints.datasetlookup;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.APINodeMetrics;
import com.dataiku.lambda.ServiceGenContext;
import com.dataiku.lambda.endpoints.EndpointUtils;
import com.dataiku.lambda.endpoints.LambdaEndpointHandler;
import com.dataiku.lambda.endpoints.datasetlookup.DatasetsLookupPipeline;
import com.dataiku.lambda.endpoints.pool.PipelinePool;
import com.dataiku.lambda.endpoints.pool.PoolCallbacks;
import com.dataiku.lambda.endpoints.predict.SQLLeftJoinEnrichStep;
import com.dataiku.lambda.endpoints.predictcommon.PipelineMessage;
import com.dataiku.lambda.model.api.LookupModel;
import com.dataiku.lambda.model.api.ResponseElements;
import com.dataiku.lambda.model.serverconfig.DatasetsLookupEndpointConfig;
import com.dataiku.lambda.services.ServiceManager;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class DatasetsLookupEndpointHandler
extends LambdaEndpointHandler<DatasetsLookupEndpointConfig>
implements PoolCallbacks<DatasetsLookupPipeline> {
    private PipelinePool<DatasetsLookupPipeline> pool;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.custPredEPH");

    public DatasetsLookupEndpointHandler(DatasetsLookupEndpointConfig config) throws IOException {
        super(config);
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public final void init(ServiceGenContext context) throws Exception {
        super.init(context);
        this.pool = new PipelinePool<DatasetsLookupPipeline>(this, context.getServiceId(), ((DatasetsLookupEndpointConfig)this.config).id, this.serverEndpointConfig.pool);
        this.pool.init();
    }

    @Override
    public synchronized void destroy() {
        logger.info((Object)"Destroy endpoint");
        this.pool.destroy();
    }

    @Override
    public DatasetsLookupPipeline instantiatePipeline() throws Exception {
        DatasetsLookupPipeline pipe = new DatasetsLookupPipeline();
        pipe.initEnrichMappings(((DatasetsLookupEndpointConfig)this.config).lookups, this.context);
        return pipe;
    }

    private MemTable tableFromItems(List<LookupModel.Item> items) {
        MemTable table = new MemTable();
        for (LookupModel.Item item : items) {
            table.addRowFromJsonObject(item.data);
        }
        table.addDumbRowsIfEmpty();
        return table;
    }

    public LookupModel.LookupResult lookupSimple(LookupModel.SingleLookupQuery query, ServiceManager.RefcountedEndpoint re) throws Exception {
        ArrayList<LookupModel.Item> items = new ArrayList<LookupModel.Item>();
        items.add((LookupModel.Item)query);
        MemTable table = this.tableFromItems(items);
        PipelineMessage message = new PipelineMessage();
        message.itemsToPredict.add(null);
        message.table = table;
        for (int i = 0; i < table.rows.size(); ++i) {
            message.prePredictIgnoreReasons.add(null);
        }
        return this.run(message, items, re);
    }

    public LookupModel.LookupResult lookupMulti(LookupModel.MultipleLookupQuery query, ServiceManager.RefcountedEndpoint re) throws Exception {
        MemTable table = this.tableFromItems(query.items);
        PipelineMessage message = new PipelineMessage();
        message.itemsToPredict.add(null);
        message.table = table;
        for (int i = 0; i < table.rows.size(); ++i) {
            message.prePredictIgnoreReasons.add(null);
        }
        return this.run(message, query.items, re);
    }

    private LookupModel.LookupResult run(PipelineMessage message, List<LookupModel.Item> lookupItems, ServiceManager.RefcountedEndpoint re) throws Exception {
        APINodeMetrics.endpointMeter(this.context.getServiceId(), ((DatasetsLookupEndpointConfig)this.config).id, "requests").mark();
        DatasetsLookupPipeline pipeline = this.pool.acquire();
        LookupModel.LookupResult result = new LookupModel.LookupResult();
        result.apiContext = this.newContext();
        try {
            LookupModel.LookupResult lookupResult;
            block19: {
                DSSMetrics.TimeCtx tctx = APINodeMetrics.endpointTimeCtx(this.context.getServiceId(), ((DatasetsLookupEndpointConfig)this.config).id, "process");
                try {
                    int i;
                    for (SQLLeftJoinEnrichStep step : pipeline.sqlEnrich) {
                        step.process(message);
                    }
                    for (i = 0; i < message.table.rows.size(); ++i) {
                        LookupModel.LookupResponseItem responseItem = new LookupModel.LookupResponseItem();
                        if (message.prePredictIgnoreReasons.get(i) != null) {
                            responseItem.ignored = true;
                            responseItem.ignoreReason = message.prePredictIgnoreReasons.get(i);
                        } else {
                            responseItem.data = new JsonObject();
                            MemRow row = (MemRow)message.table.rows.get(i);
                            for (Column mc : message.table.columns()) {
                                Object v = EndpointUtils.getSQLValue(row.get(mc), message.columnsSQLTypes.get(mc.getName()));
                                if (v instanceof Number) {
                                    responseItem.data.addProperty(mc.getName(), (Number)v);
                                    continue;
                                }
                                if (v instanceof Boolean) {
                                    responseItem.data.addProperty(mc.getName(), (Boolean)v);
                                    continue;
                                }
                                responseItem.data.addProperty(mc.getName(), (String)v);
                            }
                        }
                        result.results.add(responseItem);
                    }
                    for (i = 0; i < result.results.size(); ++i) {
                        this.audit(re, lookupItems.get(i), (LookupModel.LookupResponseItem)result.results.get(i), result.apiContext, null);
                    }
                    lookupResult = result;
                    if (tctx == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (tctx != null) {
                            try {
                                tctx.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exc) {
                        this.audit(re, null, null, result.apiContext, exc);
                        throw exc;
                    }
                }
                tctx.close();
            }
            return lookupResult;
        }
        finally {
            this.pool.release(pipeline);
        }
    }

    @Override
    protected String getMessageType() {
        return "dataset-lookup-query";
    }

    @Override
    protected String getQueryType() {
        return "dataset-lookup";
    }

    private void audit(ServiceManager.RefcountedEndpoint re, LookupModel.Item input, LookupModel.LookupResponseItem resp, ResponseElements.Context apiContext, Exception error) {
        try {
            LambdaEndpointHandler.AuditResult output = resp != null ? this.createResult(JSON.toJsonObject((Object)resp, (String[])new String[0])) : null;
            Optional<AuditTrailService.EmittableAuditObj> geo = this.createEvent(re, logger, input != null ? input.data : null, output, error, null, JSON.json((Object)apiContext));
            if (geo.isPresent()) {
                if (input != null) {
                    geo.get().with("userContext", input.context);
                }
                geo.get().emit();
            }
        }
        catch (Exception e) {
            logger.warn((Object)"failed to log queries", (Throwable)e);
        }
    }
}

