/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.j2ts.annotations.UIType;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonAdapter(value=SecretStringAdapter.class)
@UIType(value="string")
public final class SecretString {
    @Nonnull
    public final String secret;

    private SecretString(@Nonnull String secret) {
        this.secret = (String)Preconditions.checkNotNull((Object)secret);
    }

    public String toString() {
        return "*****";
    }

    public static Optional<SecretString> build(@Nullable String secret) {
        return secret == null ? Optional.empty() : Optional.of(new SecretString(secret));
    }

    @Nullable
    public static SecretString buildOrNull(@Nullable String secret) {
        return SecretString.build(secret).orElse(null);
    }

    @Nullable
    public static String getSecretOrNull(@Nullable SecretString secretString) {
        return secretString == null ? null : secretString.secret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object rhs) {
        if (this == rhs) return true;
        if (!(rhs instanceof SecretString)) return false;
        SecretString that = (SecretString)rhs;
        if (!Objects.equals(this.secret, that.secret)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.secret);
    }

    static class SecretStringAdapter
    extends TypeAdapter<SecretString> {
        @Nonnull
        private final MarshalingMode marshalingMode;

        public SecretStringAdapter() {
            this.marshalingMode = MarshalingMode.DISPLAY_SECRET;
        }

        public SecretStringAdapter(@Nullable MarshalingMode marshalingMode) {
            this.marshalingMode = Objects.requireNonNullElse(marshalingMode, MarshalingMode.HIDE_SECRET);
        }

        public SecretString read(@Nonnull JsonReader jsonReader) throws IOException {
            return SecretString.buildOrNull(jsonReader.nextString());
        }

        public void write(@Nonnull JsonWriter jsonWriter, @Nullable SecretString secretString) throws IOException {
            if (secretString == null) {
                jsonWriter.nullValue();
            } else {
                jsonWriter.value(switch (this.marshalingMode) {
                    default -> throw new IncompatibleClassChangeError();
                    case MarshalingMode.DISPLAY_SECRET -> secretString.secret;
                    case MarshalingMode.HIDE_SECRET -> secretString.toString();
                });
            }
        }

        public static enum MarshalingMode {
            HIDE_SECRET,
            DISPLAY_SECRET;

        }
    }
}

