/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.polyjson;

import com.dataiku.dip.utils.polyjson.PolyClassMetadata;
import com.dataiku.dip.utils.polyjson.RichJsonReader;
import com.dataiku.dip.utils.polyjson.RichJsonWriter;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

class PolyJSONAdapter
extends TypeAdapter<Object> {
    private final PolyClassMetadata metadata;
    private final Gson gson;
    private final ConcurrentHashMap<String, TypeAdapter<Object>> adapterCache = new ConcurrentHashMap();
    private final Class<?> clazz;

    public PolyJSONAdapter(Gson gson, Class<?> clazz, PolyClassMetadata metadata) {
        this.gson = gson;
        this.metadata = metadata;
        this.clazz = clazz;
    }

    public void write(JsonWriter jsonWriter, Object object) throws IOException {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        Class<?> objClass = object.getClass();
        if (!this.clazz.isAssignableFrom(objClass)) {
            throw new IllegalArgumentException("Cannot serialize " + objClass.getSimpleName() + ": not a " + this.clazz.getSimpleName());
        }
        String jsonType = this.metadata.getTypeFromClass(objClass);
        if (jsonType == null) {
            throw new IllegalArgumentException("Cannot serialize " + objClass.getSimpleName() + ": no type mapping declared in " + this.metadata.getAnnotatedClass().getSimpleName());
        }
        TypeAdapter<Object> adapter = this.adapterCache.get(jsonType);
        if (adapter == null) {
            adapter = this.lookupSubClassAdapter(objClass);
            this.adapterCache.put(jsonType, adapter);
        }
        RichJsonWriter richWriter = RichJsonWriter.fromWriter(jsonWriter);
        richWriter.beginObject();
        richWriter.name(this.metadata.getTypeProperty());
        richWriter.value(jsonType);
        richWriter.beginFlatten();
        richWriter.beginCapture(this.metadata.getTypeProperty());
        richWriter.writeJsonElement(adapter, object);
        JsonElement receivedType = richWriter.endCapture();
        boolean typeIsValid = receivedType == null;
        typeIsValid = typeIsValid || receivedType.isJsonPrimitive() && receivedType.getAsJsonPrimitive().isString() && this.metadata.getClassFromType(receivedType.getAsString()) == objClass;
        boolean bl = typeIsValid = typeIsValid || receivedType.isJsonNull();
        if (!typeIsValid) {
            List allowedTypes = this.metadata.getAllPossibleTypesFromBaseClass(objClass).stream().map(type -> "\"" + type + "\"").collect(Collectors.toList());
            throw new IllegalArgumentException("Cannot serialize " + objClass.getSimpleName() + ": " + this.metadata.getTypeProperty() + " " + receivedType.toString() + " is invalid (allowed " + this.metadata.getTypeProperty() + " values are: " + String.join((CharSequence)", ", allowedTypes) + ")");
        }
        richWriter.endFlatten();
        richWriter.endObject();
    }

    public Object read(JsonReader jsonReader) throws IOException {
        TypeAdapter<Object> adapter;
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        RichJsonReader richReader = RichJsonReader.fromReader(jsonReader);
        boolean shouldReplaceAliasTypeByCanonical = true;
        richReader.beginLookahead();
        String declaredType = null;
        richReader.beginObject();
        while (richReader.hasNext()) {
            String property = richReader.nextName();
            if (this.metadata.getTypeProperty().equals(property)) {
                JsonToken token = richReader.peek();
                if (token == JsonToken.STRING) {
                    declaredType = richReader.nextString();
                    break;
                }
                throw new JsonParseException("Cannot deserialize " + String.valueOf(this.clazz) + ": invalid " + this.metadata.getTypeProperty() + " (expected " + String.valueOf(JsonToken.STRING) + " but got " + String.valueOf(token) + " at " + richReader.getPath() + ")");
            }
            richReader.skipValue();
        }
        if (declaredType == null) {
            if (StringUtils.isNotBlank((String)this.metadata.getDefaultType())) {
                shouldReplaceAliasTypeByCanonical = false;
                declaredType = this.metadata.getDefaultType();
            } else {
                richReader.endLookahead();
                throw new JsonParseException("Cannot deserialize " + this.clazz.getSimpleName() + ": missing property \"" + this.metadata.getTypeProperty() + "\" at " + richReader.getPath());
            }
        }
        if ((adapter = this.adapterCache.get(declaredType)) == null) {
            Class<?> subClass = this.metadata.getClassFromType(declaredType);
            if (subClass == null) {
                List allowedTypes = this.metadata.getAllPossibleTypesFromBaseClass(this.clazz).stream().map(type -> "\"" + type + "\"").collect(Collectors.toList());
                String message = allowedTypes.isEmpty() ? " (no other " + this.metadata.getTypeProperty() + " is registered)" : " (possible " + this.metadata.getTypeProperty() + " values are: " + String.join((CharSequence)", ", allowedTypes) + ")";
                throw new JsonParseException("Cannot deserialize " + this.clazz.getSimpleName() + ": unknown " + this.metadata.getTypeProperty() + " \"" + declaredType + "\" at " + richReader.getPath() + message);
            }
            if (!this.clazz.isAssignableFrom(subClass)) {
                throw new JsonParseException("Cannot deserialize " + this.clazz.getSimpleName() + ": " + this.metadata.getTypeProperty() + " \"" + declaredType + "\" at " + richReader.getPath() + " is declared but is mapped to " + subClass.getSimpleName());
            }
            adapter = this.lookupSubClassAdapter(subClass);
            this.adapterCache.put(declaredType, adapter);
        }
        if (shouldReplaceAliasTypeByCanonical) {
            String canonicalType = this.metadata.getCanonicalType(declaredType);
            richReader.replacePreviousString(canonicalType);
        }
        richReader.endLookahead();
        return richReader.nextJsonElement(adapter);
    }

    private TypeAdapter<Object> lookupSubClassAdapter(Class<?> subClass) {
        return this.gson.getDelegateAdapter((TypeAdapterFactory)this.metadata.getFactory(), TypeToken.get(subClass));
    }
}

