/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.arrow.vector;

import com.databricks.internal.apache.arrow.memory.BufferAllocator;
import com.databricks.internal.apache.arrow.memory.ReusableBuffer;
import com.databricks.internal.apache.arrow.vector.BaseLargeVariableWidthVector;
import com.databricks.internal.apache.arrow.vector.BitVectorHelper;
import com.databricks.internal.apache.arrow.vector.ValueIterableVector;
import com.databricks.internal.apache.arrow.vector.ValueVector;
import com.databricks.internal.apache.arrow.vector.complex.impl.LargeVarBinaryReaderImpl;
import com.databricks.internal.apache.arrow.vector.complex.reader.FieldReader;
import com.databricks.internal.apache.arrow.vector.holders.LargeVarBinaryHolder;
import com.databricks.internal.apache.arrow.vector.holders.NullableLargeVarBinaryHolder;
import com.databricks.internal.apache.arrow.vector.types.Types;
import com.databricks.internal.apache.arrow.vector.types.pojo.Field;
import com.databricks.internal.apache.arrow.vector.types.pojo.FieldType;
import com.databricks.internal.apache.arrow.vector.util.TransferPair;

public final class LargeVarBinaryVector
extends BaseLargeVariableWidthVector
implements ValueIterableVector<byte[]> {
    public LargeVarBinaryVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.LARGEVARBINARY.getType()), allocator);
    }

    public LargeVarBinaryVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public LargeVarBinaryVector(Field field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new LargeVarBinaryReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.LARGEVARBINARY;
    }

    @Override
    public byte[] get(int index) {
        assert (index >= 0);
        if (this.isSet(index) == 0) {
            return null;
        }
        long startOffset = this.getStartOffset(index);
        long dataLength = this.getEndOffset(index) - startOffset;
        byte[] result = new byte[(int)dataLength];
        this.valueBuffer.getBytes(startOffset, result, 0, (int)dataLength);
        return result;
    }

    @Override
    public void read(int index, ReusableBuffer<?> buffer) {
        long startOffset = this.getStartOffset(index);
        long dataLength = this.getEndOffset(index) - startOffset;
        buffer.set(this.valueBuffer, startOffset, dataLength);
    }

    public byte[] getObject(int index) {
        return this.get(index);
    }

    public void get(int index, NullableLargeVarBinaryHolder holder) {
        assert (index >= 0);
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.start = this.getStartOffset(index);
        holder.end = this.getEndOffset(index);
        holder.buffer = this.valueBuffer;
    }

    public void set(int index, LargeVarBinaryHolder holder) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        int dataLength = (int)(holder.end - holder.start);
        long startOffset = this.getStartOffset(index);
        this.offsetBuffer.setLong((long)(index + 1) * 8L, startOffset + (long)dataLength);
        this.valueBuffer.setBytes(startOffset, holder.buffer, holder.start, (long)dataLength);
        this.lastSet = index;
    }

    public void setSafe(int index, LargeVarBinaryHolder holder) {
        assert (index >= 0);
        int dataLength = (int)(holder.end - holder.start);
        this.handleSafe(index, dataLength);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        long startOffset = this.getStartOffset(index);
        this.offsetBuffer.setLong((long)(index + 1) * 8L, startOffset + (long)dataLength);
        this.valueBuffer.setBytes(startOffset, holder.buffer, holder.start, (long)dataLength);
        this.lastSet = index;
    }

    public void set(int index, NullableLargeVarBinaryHolder holder) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, holder.isSet);
        long startOffset = this.getStartOffset(index);
        if (holder.isSet != 0) {
            int dataLength = (int)(holder.end - holder.start);
            this.offsetBuffer.setLong((long)(index + 1) * 8L, startOffset + (long)dataLength);
            this.valueBuffer.setBytes(startOffset, holder.buffer, holder.start, (long)dataLength);
        } else {
            this.offsetBuffer.setLong((long)(index + 1) * 8L, startOffset);
        }
        this.lastSet = index;
    }

    public void setSafe(int index, NullableLargeVarBinaryHolder holder) {
        assert (index >= 0);
        if (holder.isSet != 0) {
            int dataLength = (int)(holder.end - holder.start);
            this.handleSafe(index, dataLength);
            this.fillHoles(index);
            long startOffset = this.getStartOffset(index);
            this.offsetBuffer.setLong((long)(index + 1) * 8L, startOffset + (long)dataLength);
            this.valueBuffer.setBytes(startOffset, holder.buffer, holder.start, (long)dataLength);
        } else {
            this.fillEmpties(index + 1);
        }
        BitVectorHelper.setValidityBit(this.validityBuffer, index, holder.isSet);
        this.lastSet = index;
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new TransferImpl(field, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((LargeVarBinaryVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        LargeVarBinaryVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new LargeVarBinaryVector(ref, LargeVarBinaryVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Field field, BufferAllocator allocator) {
            this.to = new LargeVarBinaryVector(field, allocator);
        }

        public TransferImpl(LargeVarBinaryVector to) {
            this.to = to;
        }

        @Override
        public LargeVarBinaryVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            LargeVarBinaryVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            LargeVarBinaryVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, LargeVarBinaryVector.this);
        }
    }
}

