/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.hc.core5.http.io.support;

import com.databricks.internal.apache.hc.core5.http.ClassicHttpRequest;
import com.databricks.internal.apache.hc.core5.http.ClassicHttpResponse;
import com.databricks.internal.apache.hc.core5.http.HttpException;
import com.databricks.internal.apache.hc.core5.http.io.HttpServerRequestHandler;
import com.databricks.internal.apache.hc.core5.http.message.BasicClassicHttpResponse;
import com.databricks.internal.apache.hc.core5.http.protocol.HttpContext;
import com.databricks.internal.apache.hc.core5.http.support.ExpectSupport;
import com.databricks.internal.apache.hc.core5.http.support.Expectation;
import com.databricks.internal.apache.hc.core5.util.Args;
import java.io.IOException;

public class BasicHttpServerExpectationDecorator
implements HttpServerRequestHandler {
    private final HttpServerRequestHandler requestHandler;

    public BasicHttpServerExpectationDecorator(HttpServerRequestHandler requestHandler) {
        this.requestHandler = Args.notNull(requestHandler, "Request handler");
    }

    protected ClassicHttpResponse verify(ClassicHttpRequest request, HttpContext context) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void handle(ClassicHttpRequest request, HttpServerRequestHandler.ResponseTrigger responseTrigger, HttpContext context) throws HttpException, IOException {
        Expectation expectation = ExpectSupport.parse(request, request.getEntity());
        if (expectation == Expectation.CONTINUE) {
            ClassicHttpResponse response = this.verify(request, context);
            if (response != null) {
                responseTrigger.submitResponse(response);
                return;
            }
            responseTrigger.sendInformation(new BasicClassicHttpResponse(100));
        } else if (expectation == Expectation.UNKNOWN) {
            BasicClassicHttpResponse expectationFailed = new BasicClassicHttpResponse(417);
            responseTrigger.submitResponse(expectationFailed);
            return;
        }
        this.requestHandler.handle(request, responseTrigger, context);
    }
}

