/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.noding;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.util.LinearComponentExtracter;
import com.databricks.internal.jts.noding.BasicSegmentString;
import com.databricks.internal.jts.noding.NodedSegmentString;
import com.databricks.internal.jts.noding.SegmentString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SegmentStringUtil {
    public static List extractSegmentStrings(Geometry geom) {
        return SegmentStringUtil.extractNodedSegmentStrings(geom);
    }

    public static List extractNodedSegmentStrings(Geometry geom) {
        ArrayList<NodedSegmentString> segStr = new ArrayList<NodedSegmentString>();
        List lines = LinearComponentExtracter.getLines(geom);
        for (LineString line : lines) {
            Coordinate[] pts = line.getCoordinates();
            segStr.add(new NodedSegmentString(pts, geom));
        }
        return segStr;
    }

    public static List extractBasicSegmentStrings(Geometry geom) {
        ArrayList<BasicSegmentString> segStr = new ArrayList<BasicSegmentString>();
        List lines = LinearComponentExtracter.getLines(geom);
        for (LineString line : lines) {
            Coordinate[] pts = line.getCoordinates();
            segStr.add(new BasicSegmentString(pts, geom));
        }
        return segStr;
    }

    public static Geometry toGeometry(Collection segStrings, GeometryFactory geomFact) {
        LineString[] lines = new LineString[segStrings.size()];
        int index = 0;
        for (SegmentString ss : segStrings) {
            LineString line = geomFact.createLineString(ss.getCoordinates());
            lines[index++] = line;
        }
        if (lines.length == 1) {
            return lines[0];
        }
        return geomFact.createMultiLineString(lines);
    }

    public static String toString(List segStrings) {
        StringBuffer buf = new StringBuffer();
        for (SegmentString segStr : segStrings) {
            buf.append(segStr.toString());
            buf.append("\n");
        }
        return buf.toString();
    }
}

