/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.common;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.sdk.service.sql.StatementState;
import com.databricks.jdbc.api.impl.DatabricksResultSet;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.CommandName;
import com.databricks.jdbc.common.MetadataResultConstants;
import com.databricks.jdbc.common.Nullable;
import com.databricks.jdbc.common.StatementType;
import com.databricks.jdbc.common.util.WildcardUtil;
import com.databricks.jdbc.dbclient.impl.common.CrossReferenceKeysDatabricksResultSetAdapter;
import com.databricks.jdbc.dbclient.impl.common.DefaultDatabricksResultSetAdapter;
import com.databricks.jdbc.dbclient.impl.common.IDatabricksResultSetAdapter;
import com.databricks.jdbc.dbclient.impl.common.ImportedKeysDatabricksResultSetAdapter;
import com.databricks.jdbc.dbclient.impl.common.SchemasDatabricksResultSetAdapter;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.model.core.ColumnMetadata;
import com.databricks.jdbc.model.core.ResultColumn;
import com.databricks.jdbc.model.core.StatementStatus;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MetadataResultSetBuilder {
    private static final IDatabricksResultSetAdapter defaultAdapter = new DefaultDatabricksResultSetAdapter();
    private static final IDatabricksResultSetAdapter importedKeysAdapter = new ImportedKeysDatabricksResultSetAdapter();
    private final IDatabricksConnectionContext ctx;

    public MetadataResultSetBuilder(IDatabricksConnectionContext ctx) {
        this.ctx = ctx;
    }

    public DatabricksResultSet getFunctionsResult(DatabricksResultSet resultSet, String catalog) throws SQLException {
        List<List<Object>> rows = this.getRowsForFunctions(resultSet, MetadataResultConstants.FUNCTION_COLUMNS, catalog);
        return this.buildResultSet(MetadataResultConstants.FUNCTION_COLUMNS, rows, "getfunctions-metadata", resultSet.getMetaData(), CommandName.LIST_FUNCTIONS);
    }

    public DatabricksResultSet getColumnsResult(DatabricksResultSet resultSet) throws SQLException {
        List<List<Object>> rows = this.getRows(resultSet, MetadataResultConstants.COLUMN_COLUMNS, defaultAdapter);
        return this.buildResultSet(MetadataResultConstants.COLUMN_COLUMNS, rows, "metadata-statement", resultSet.getMetaData(), CommandName.LIST_COLUMNS);
    }

    public DatabricksResultSet getCatalogsResult(DatabricksResultSet resultSet) throws SQLException {
        List<List<Object>> rows = this.getRows(resultSet, MetadataResultConstants.CATALOG_COLUMNS, defaultAdapter);
        return this.buildResultSet(MetadataResultConstants.CATALOG_COLUMNS, rows, "getcatalogs-metadata", resultSet.getMetaData(), CommandName.LIST_CATALOGS);
    }

    public DatabricksResultSet getSchemasResult(DatabricksResultSet resultSet, String catalog) throws SQLException {
        List<List<Object>> rows = this.getRowsForSchemas(resultSet, MetadataResultConstants.SCHEMA_COLUMNS, catalog, new SchemasDatabricksResultSetAdapter());
        return this.buildResultSet(MetadataResultConstants.SCHEMA_COLUMNS, rows, "metadata-statement", resultSet.getMetaData(), CommandName.LIST_SCHEMAS);
    }

    public DatabricksResultSet getTablesResult(DatabricksResultSet resultSet, String[] tableTypes) throws SQLException {
        List<String> allowedTableTypes = List.of(tableTypes);
        List<List<Object>> rows = this.getRows(resultSet, MetadataResultConstants.TABLE_COLUMNS, defaultAdapter).stream().filter(row -> allowedTableTypes.contains(row.get(3))).collect(Collectors.toList());
        rows.sort(Comparator.comparing(r -> (String)r.get(3)).thenComparing(r -> (String)r.get(0)).thenComparing(r -> (String)r.get(1)).thenComparing(r -> (String)r.get(2)));
        return this.buildResultSet(MetadataResultConstants.TABLE_COLUMNS, rows, "gettables-metadata", resultSet.getMetaData(), CommandName.LIST_TABLES);
    }

    public DatabricksResultSet getTableTypesResult() {
        List<List<Object>> tableTypesRows = this.ctx.getEnableMetricViewMetadata() ? MetadataResultConstants.TABLE_TYPES_ROWS : MetadataResultConstants.TABLE_TYPES_ROWS.stream().filter(row -> !"METRIC_VIEW".equals(row.get(0))).collect(Collectors.toList());
        return this.buildResultSet(MetadataResultConstants.TABLE_TYPE_COLUMNS, tableTypesRows, "gettabletype-metadata", CommandName.LIST_TABLE_TYPES);
    }

    public DatabricksResultSet getPrimaryKeysResult(DatabricksResultSet resultSet) throws SQLException {
        List<List<Object>> rows = this.getRows(resultSet, MetadataResultConstants.PRIMARY_KEYS_COLUMNS, defaultAdapter);
        return this.buildResultSet(MetadataResultConstants.PRIMARY_KEYS_COLUMNS, rows, "metadata-statement", resultSet.getMetaData(), CommandName.LIST_PRIMARY_KEYS);
    }

    public DatabricksResultSet getImportedKeysResult(DatabricksResultSet resultSet) throws SQLException {
        List<List<Object>> rows = this.getRows(resultSet, MetadataResultConstants.IMPORTED_KEYS_COLUMNS, importedKeysAdapter);
        return this.buildResultSet(MetadataResultConstants.IMPORTED_KEYS_COLUMNS, rows, "metadata-statement", resultSet.getMetaData(), CommandName.GET_IMPORTED_KEYS);
    }

    public DatabricksResultSet getCrossReferenceKeysResult(DatabricksResultSet resultSet, String targetParentCatalogName, String targetParentNamespaceName, String targetParentTableName) throws SQLException {
        CrossReferenceKeysDatabricksResultSetAdapter crossReferenceKeysResultSetAdapter = new CrossReferenceKeysDatabricksResultSetAdapter(targetParentCatalogName, targetParentNamespaceName, targetParentTableName);
        List<List<Object>> rows = this.getRows(resultSet, MetadataResultConstants.CROSS_REFERENCE_COLUMNS, crossReferenceKeysResultSetAdapter);
        return this.buildResultSet(MetadataResultConstants.CROSS_REFERENCE_COLUMNS, rows, "metadata-statement", resultSet.getMetaData(), CommandName.GET_CROSS_REFERENCE);
    }

    private boolean isTextType(String typeVal) {
        return typeVal.contains("TEXT") || typeVal.contains("CHAR") || typeVal.contains("VARCHAR") || typeVal.contains("STRING");
    }

    List<List<Object>> getRows(DatabricksResultSet resultSet, List<ResultColumn> columns, IDatabricksResultSetAdapter adapter) throws SQLException {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        resultSet.setSilenceNonTerminalExceptions();
        while (resultSet.next()) {
            if (!adapter.includeRow(resultSet, columns)) continue;
            ArrayList<Object> row = new ArrayList<Object>();
            for (ResultColumn column : columns) {
                Object object;
                ResultColumn mappedColumn = adapter.mapColumn(column);
                String typeVal = null;
                try {
                    typeVal = resultSet.getString(MetadataResultConstants.COLUMN_TYPE_COLUMN.getResultSetColumnName());
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                switch (mappedColumn.getColumnName()) {
                    case "SQL_DATA_TYPE": {
                        if (typeVal == null) {
                            object = null;
                            break;
                        }
                        if (!this.ctx.isGeoSpatialSupportEnabled() && this.isGeospatialType(typeVal)) {
                            object = 12;
                            break;
                        }
                        if (!this.ctx.isComplexDatatypeSupportEnabled() && this.isComplexType(typeVal)) {
                            object = 12;
                            break;
                        }
                        object = this.getCode(this.stripBaseTypeName(typeVal));
                        break;
                    }
                    case "SQL_DATETIME_SUB": {
                        if (typeVal != null && (this.stripBaseTypeName(typeVal).contains("DATE") || this.stripBaseTypeName(typeVal).contains("TIMESTAMP"))) {
                            object = this.getCode(this.stripBaseTypeName(typeVal));
                            break;
                        }
                        object = null;
                        break;
                    }
                    default: {
                        try {
                            object = resultSet.getObject(mappedColumn.getResultSetColumnName());
                            if (mappedColumn.getColumnName().equals(MetadataResultConstants.IS_NULLABLE_COLUMN.getColumnName())) {
                                object = object == null || object.equals("true") ? "YES" : "NO";
                            } else if (mappedColumn.getColumnName().equals(MetadataResultConstants.DECIMAL_DIGITS_COLUMN.getColumnName())) {
                                object = this.getUpdatedDecimalDigits(this.stripBaseTypeName(typeVal), object);
                            } else if (mappedColumn.getColumnName().equals(MetadataResultConstants.NUM_PREC_RADIX_COLUMN.getColumnName())) {
                                if (object == null) {
                                    object = 0;
                                }
                            } else if (mappedColumn.getColumnName().equals(MetadataResultConstants.REMARKS_COLUMN.getColumnName()) && object == null) {
                                object = "";
                            }
                        }
                        catch (SQLException e) {
                            if (mappedColumn.getColumnName().equals(MetadataResultConstants.DATA_TYPE_COLUMN.getColumnName())) {
                                object = !this.ctx.isGeoSpatialSupportEnabled() && this.isGeospatialType(typeVal) ? Integer.valueOf(12) : (!this.ctx.isComplexDatatypeSupportEnabled() && this.isComplexType(typeVal) ? Integer.valueOf(12) : Integer.valueOf(this.getCode(this.stripBaseTypeName(typeVal))));
                            }
                            if (mappedColumn.getColumnName().equals(MetadataResultConstants.CHAR_OCTET_LENGTH_COLUMN.getColumnName())) {
                                object = this.getCharOctetLength(typeVal);
                                if (object.equals(0)) {
                                    object = null;
                                }
                            }
                            object = mappedColumn.getColumnName().equals(MetadataResultConstants.BUFFER_LENGTH_COLUMN.getColumnName()) ? Integer.valueOf(this.getBufferLength(typeVal)) : null;
                        }
                        if (mappedColumn.getColumnName().equals(MetadataResultConstants.NULLABLE_COLUMN.getColumnName())) {
                            object = resultSet.getObject(MetadataResultConstants.IS_NULLABLE_COLUMN.getResultSetColumnName());
                            object = object == null || object.equals("true") ? Integer.valueOf(1) : Integer.valueOf(0);
                        }
                        if (mappedColumn.getColumnName().equals(MetadataResultConstants.TABLE_TYPE_COLUMN.getColumnName()) && (object == null || object.equals(""))) {
                            object = "TABLE";
                        }
                        if (mappedColumn.getColumnName().equals(MetadataResultConstants.COLUMN_TYPE_COLUMN.getColumnName())) {
                            object = typeVal != null && (typeVal.contains("measure") || typeVal.contains("ARRAY") || typeVal.contains("MAP") || typeVal.contains("STRUCT")) ? typeVal : this.stripBaseTypeName(typeVal);
                        }
                        if (!mappedColumn.getColumnName().equals(MetadataResultConstants.COLUMN_SIZE_COLUMN.getColumnName())) break;
                        object = this.getColumnSize(typeVal);
                    }
                }
                object = adapter.transformValue(mappedColumn, object);
                row.add(object);
            }
            rows.add(row);
        }
        resultSet.unsetSilenceNonTerminalExceptions();
        return rows;
    }

    int getSizeFromTypeVal(String typeVal) {
        if (typeVal.isEmpty()) {
            return -1;
        }
        String regex = "\\w+\\((\\d+)\\)";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(typeVal);
        if (matcher.find()) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    int extractPrecision(String typeVal) {
        String lowerType = typeVal.toLowerCase().trim();
        Pattern pattern = Pattern.compile("\\((\\d+)(?:,\\s*\\d+)?\\)");
        Matcher matcher = pattern.matcher(lowerType);
        if (matcher.find()) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException e) {
                return 10;
            }
        }
        return 10;
    }

    int getColumnSize(String typeVal) {
        String typeName;
        if (typeVal == null || typeVal.isEmpty() || typeVal.contains("INTERVAL")) {
            return 0;
        }
        int sizeFromTypeVal = this.getSizeFromTypeVal(typeVal);
        if (sizeFromTypeVal != -1) {
            return sizeFromTypeVal;
        }
        if (this.isTextType(typeVal)) {
            return this.ctx.getDefaultStringColumnLength();
        }
        switch (typeName = this.stripBaseTypeName(typeVal)) {
            case "DECIMAL": 
            case "NUMERIC": {
                return this.extractPrecision(typeVal);
            }
            case "SMALLINT": {
                return 5;
            }
            case "DATE": 
            case "INT": {
                return 10;
            }
            case "BIGINT": {
                return 19;
            }
            case "FLOAT": {
                return 7;
            }
            case "DOUBLE": {
                return 15;
            }
            case "TIMESTAMP": {
                return 29;
            }
            case "BOOLEAN": 
            case "BINARY": {
                return 1;
            }
        }
        return 255;
    }

    int getSizeInBytes(int sqlType) {
        switch (sqlType) {
            case 91: 
            case 92: {
                return 6;
            }
            case 93: {
                return 16;
            }
            case 2: 
            case 3: {
                return 40;
            }
            case 4: 
            case 7: {
                return 4;
            }
            case -5: 
            case 6: 
            case 8: {
                return 8;
            }
            case -2: {
                return Short.MAX_VALUE;
            }
            case -7: 
            case -6: 
            case 16: {
                return 1;
            }
            case 5: {
                return 2;
            }
        }
        return 0;
    }

    int getBufferLength(String typeVal) {
        if (typeVal == null || typeVal.isEmpty()) {
            return 0;
        }
        if (typeVal.contains("ARRAY") || typeVal.contains("MAP") || typeVal.contains("STRUCT")) {
            return 255;
        }
        if (this.isTextType(typeVal)) {
            return this.getColumnSize(typeVal);
        }
        int sqlType = this.getCode(this.stripBaseTypeName(typeVal));
        return this.getSizeInBytes(sqlType);
    }

    int getUpdatedDecimalDigits(String baseTypeVal, Object scaleObject) {
        if (scaleObject == null) {
            return 0;
        }
        int scale = (Integer)scaleObject;
        if (WildcardUtil.isNullOrEmpty(baseTypeVal)) {
            return 0;
        }
        if (baseTypeVal.contains("DECIMAL") || baseTypeVal.contains("NUMERIC")) {
            return scale;
        }
        if (baseTypeVal.contains("TIMESTAMP") || baseTypeVal.contains("TIMESTAMP_NTZ")) {
            return 9;
        }
        return 0;
    }

    int getCharOctetLength(String typeVal) {
        if (typeVal == null || !this.isTextType(typeVal) && !typeVal.contains("BINARY")) {
            return 0;
        }
        if (!typeVal.contains("(")) {
            if (typeVal.contains("BINARY")) {
                return Short.MAX_VALUE;
            }
            if (this.isTextType(typeVal)) {
                return this.ctx.getDefaultStringColumnLength();
            }
            return 255;
        }
        String[] lengthConstraints = typeVal.substring(typeVal.indexOf(40) + 1).split("[,)]");
        if (lengthConstraints.length == 0) {
            return 0;
        }
        String octetLength = lengthConstraints[0].trim();
        try {
            return Integer.parseInt(octetLength);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @VisibleForTesting
    public String stripTypeName(String typeName) {
        if (typeName == null) {
            return null;
        }
        boolean endsWithClosingBracket = typeName.endsWith(")");
        if (endsWithClosingBracket) {
            typeName = typeName.substring(0, typeName.lastIndexOf(40));
        }
        return typeName;
    }

    public String stripBaseTypeName(String typeName) {
        if (typeName == null) {
            return null;
        }
        int typeArgumentIndex = typeName.indexOf(60);
        if (typeArgumentIndex != -1) {
            return typeName.substring(0, typeArgumentIndex);
        }
        typeArgumentIndex = typeName.indexOf(40);
        if (typeArgumentIndex != -1) {
            return typeName.substring(0, typeArgumentIndex);
        }
        return typeName;
    }

    private boolean isComplexType(String typeVal) {
        if (typeVal == null) {
            return false;
        }
        String baseType = this.stripBaseTypeName(typeVal);
        return baseType.contains("ARRAY") || baseType.contains("MAP") || baseType.contains("STRUCT");
    }

    private boolean isGeospatialType(String typeVal) {
        if (typeVal == null) {
            return false;
        }
        String baseType = this.stripBaseTypeName(typeVal);
        return baseType.contains("GEOMETRY") || baseType.contains("GEOGRAPHY");
    }

    int getCode(String s2) {
        switch (s2) {
            case "STRING": 
            case "VARCHAR": {
                return 12;
            }
            case "INT": 
            case "INTEGER": {
                return 4;
            }
            case "DOUBLE": {
                return 8;
            }
            case "FLOAT": {
                return 6;
            }
            case "BOOLEAN": {
                return 16;
            }
            case "DATE": {
                return 91;
            }
            case "TIMESTAMP_NTZ": 
            case "TIMESTAMP": {
                return 93;
            }
            case "DECIMAL": {
                return 3;
            }
            case "NUMERIC": {
                return 2;
            }
            case "BINARY": {
                return -2;
            }
            case "ARRAY": {
                return 2003;
            }
            case "MAP": 
            case "STRUCT": 
            case "UNIONTYPE": {
                return 2002;
            }
            case "BYTE": 
            case "TINYINT": {
                return -6;
            }
            case "SHORT": 
            case "SMALLINT": {
                return 5;
            }
            case "LONG": 
            case "BIGINT": {
                return -5;
            }
            case "NULL": 
            case "VOID": {
                return 0;
            }
            case "CHAR": 
            case "CHARACTER": {
                return 1;
            }
            case "VARIANT": {
                return 1111;
            }
        }
        if (s2.startsWith("INTERVAL")) {
            return 12;
        }
        return 0;
    }

    private List<List<Object>> getRowsForFunctions(DatabricksResultSet resultSet, List<ResultColumn> columns, String catalog) throws SQLException {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        while (resultSet.next()) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (ResultColumn column : columns) {
                Object object;
                if (column.getColumnName().equals("FUNCTION_CAT")) {
                    row.add(catalog);
                    continue;
                }
                try {
                    object = resultSet.getObject(column.getResultSetColumnName());
                    if (object == null) {
                        object = MetadataResultConstants.NULL_STRING;
                    }
                }
                catch (DatabricksSQLException e) {
                    object = MetadataResultConstants.NULL_STRING;
                }
                row.add(object);
            }
            rows.add(row);
        }
        return rows;
    }

    private List<List<Object>> getRowsForSchemas(DatabricksResultSet resultSet, List<ResultColumn> columns, String catalog, IDatabricksResultSetAdapter adapter) throws SQLException {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        while (resultSet.next()) {
            if (!adapter.includeRow(resultSet, columns)) continue;
            ArrayList<Object> row = new ArrayList<Object>();
            for (ResultColumn column : columns) {
                Object object;
                ResultColumn mappedColumn = adapter.mapColumn(column);
                if (mappedColumn.getResultSetColumnName().equals(MetadataResultConstants.CATALOG_RESULT_COLUMN.getResultSetColumnName())) {
                    try {
                        resultSet.findColumn(mappedColumn.getResultSetColumnName());
                    }
                    catch (SQLException e) {
                        row.add(catalog);
                        continue;
                    }
                }
                try {
                    object = resultSet.getObject(mappedColumn.getResultSetColumnName());
                    if (object == null) {
                        object = MetadataResultConstants.NULL_STRING;
                    }
                }
                catch (DatabricksSQLException e) {
                    object = MetadataResultConstants.NULL_STRING;
                }
                row.add(object);
            }
            rows.add(row);
        }
        return rows;
    }

    private DatabricksResultSet buildResultSet(List<ResultColumn> columns, List<List<Object>> rows, String statementId, CommandName commandName) {
        List nonNullableColumns = MetadataResultConstants.NON_NULLABLE_COLUMNS_MAP.getOrDefault((Object)commandName, new ArrayList());
        ArrayList<Nullable> nullableList = new ArrayList<Nullable>();
        for (ResultColumn column : columns) {
            if (nonNullableColumns.contains(column)) {
                nullableList.add(Nullable.NO_NULLS);
                continue;
            }
            nullableList.add(Nullable.NULLABLE);
        }
        return new DatabricksResultSet(new StatementStatus().setState(StatementState.SUCCEEDED), new StatementId(statementId), columns.stream().map(ResultColumn::getColumnName).collect(Collectors.toList()), columns.stream().map(ResultColumn::getColumnTypeString).collect(Collectors.toList()), columns.stream().map(ResultColumn::getColumnTypeInt).collect(Collectors.toList()), columns.stream().map(ResultColumn::getColumnPrecision).collect(Collectors.toList()), nullableList, rows, StatementType.METADATA);
    }

    private DatabricksResultSet buildResultSet(List<ResultColumn> columns, List<List<Object>> rows, String statementId, ResultSetMetaData metaData, CommandName commandName) throws SQLException {
        HashMap<String, Integer> metaDataColumnMap = new HashMap<String, Integer>();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            metaDataColumnMap.put(metaData.getColumnName(i), i);
        }
        ArrayList<ColumnMetadata> columnMetadataList = new ArrayList<ColumnMetadata>();
        List<ResultColumn> nonNullableColumns = MetadataResultConstants.NON_NULLABLE_COLUMNS_MAP.get((Object)commandName);
        for (ResultColumn column : columns) {
            String columnName = column.getColumnName();
            String resultSetColumnName = column.getResultSetColumnName();
            String typeText = column.getColumnTypeString();
            int typeInt = column.getColumnTypeInt();
            Integer metaColumnIndex = (Integer)metaDataColumnMap.get(resultSetColumnName);
            int nullable = nonNullableColumns != null && nonNullableColumns.contains(column) ? 0 : 1;
            int precision = metaColumnIndex != null && metaData.getPrecision(metaColumnIndex) != 0 && (typeInt == 3 || typeInt == 2) ? metaData.getPrecision(metaColumnIndex) : column.getColumnPrecision().intValue();
            int scale = metaColumnIndex != null && metaData.getScale(metaColumnIndex) != 0 && (typeInt == 3 || typeInt == 2) ? metaData.getScale(metaColumnIndex) : column.getColumnScale().intValue();
            ColumnMetadata columnMetadata = new ColumnMetadata.Builder().name(columnName).typeText(typeText).typeInt(typeInt).precision(precision).scale(scale).nullable(nullable).build();
            columnMetadataList.add(columnMetadata);
        }
        return new DatabricksResultSet(new StatementStatus().setState(StatementState.SUCCEEDED), new StatementId(statementId), columnMetadataList, rows, StatementType.METADATA);
    }

    public DatabricksResultSet getCatalogsResult(List<List<Object>> rows) {
        return this.buildResultSet(MetadataResultConstants.CATALOG_COLUMNS, this.getThriftRows(rows, MetadataResultConstants.CATALOG_COLUMNS), "getcatalogs-metadata", CommandName.LIST_CATALOGS);
    }

    public DatabricksResultSet getSchemasResult(List<List<Object>> rows) {
        return this.buildResultSet(MetadataResultConstants.SCHEMA_COLUMNS, this.getThriftRows(rows, MetadataResultConstants.SCHEMA_COLUMNS), "metadata-statement", CommandName.LIST_SCHEMAS);
    }

    public DatabricksResultSet getCrossRefsResult(List<List<Object>> rows) {
        return this.buildResultSet(MetadataResultConstants.CROSS_REFERENCE_COLUMNS, this.getThriftRows(rows, MetadataResultConstants.CROSS_REFERENCE_COLUMNS), "metadata-statement", CommandName.GET_CROSS_REFERENCE);
    }

    public DatabricksResultSet getImportedKeys(List<List<Object>> rows) {
        return this.buildResultSet(MetadataResultConstants.IMPORTED_KEYS_COLUMNS, this.getThriftRows(rows, MetadataResultConstants.IMPORTED_KEYS_COLUMNS), "metadata-statement", CommandName.GET_IMPORTED_KEYS);
    }

    public DatabricksResultSet getExportedKeys(List<List<Object>> rows) {
        return this.buildResultSet(MetadataResultConstants.EXPORTED_KEYS_COLUMNS, this.getThriftRows(rows, MetadataResultConstants.EXPORTED_KEYS_COLUMNS), "metadata-statement", CommandName.GET_EXPORTED_KEYS);
    }

    public DatabricksResultSet getResultSetWithGivenRowsAndColumns(List<ResultColumn> columns, List<List<Object>> rows, String statementId, CommandName commandName) {
        return this.buildResultSet(columns, rows, statementId, commandName);
    }

    public DatabricksResultSet getTablesResult(String catalog, String[] tableTypes, List<List<Object>> rows) {
        ArrayList<List<Object>> updatedRows = new ArrayList<List<Object>>();
        for (List<Object> row : rows) {
            if (catalog != null && !row.get(0).toString().equals(catalog)) continue;
            Object tableType = row.get(3);
            if (tableType == null || tableType.equals("")) {
                row.set(3, "TABLE");
            }
            if (tableTypes != null && tableTypes.length > 0 && !Arrays.asList(tableTypes).contains(row.get(3).toString())) continue;
            updatedRows.add(row);
        }
        updatedRows.sort(Comparator.comparing(r -> (String)r.get(3)).thenComparing(r -> (String)r.get(0)).thenComparing(r -> (String)r.get(1)).thenComparing(r -> (String)r.get(2)));
        return this.buildResultSet(MetadataResultConstants.TABLE_COLUMNS, this.getThriftRows(updatedRows, MetadataResultConstants.TABLE_COLUMNS), "gettables-metadata", CommandName.LIST_TABLES);
    }

    public DatabricksResultSet getColumnsResult(List<List<Object>> rows) {
        return this.buildResultSet(MetadataResultConstants.COLUMN_COLUMNS, this.getThriftRows(rows, MetadataResultConstants.COLUMN_COLUMNS), "metadata-statement", CommandName.LIST_COLUMNS);
    }

    List<List<Object>> getThriftRows(List<List<Object>> rows, List<ResultColumn> columns) {
        if (rows == null || rows.isEmpty()) {
            return new ArrayList<List<Object>>();
        }
        ArrayList<List<Object>> updatedRows = new ArrayList<List<Object>>();
        for (List<Object> row : rows) {
            ArrayList<Object> updatedRow = new ArrayList<Object>();
            String typeVal = null;
            int col_type_index = columns.indexOf(MetadataResultConstants.COLUMN_TYPE_COLUMN);
            if (col_type_index != -1) {
                typeVal = (String)row.get(col_type_index);
            }
            for (ResultColumn column : columns) {
                Object object;
                if (MetadataResultConstants.NULL_COLUMN_COLUMNS.contains(column) || MetadataResultConstants.NULL_TABLE_COLUMNS.contains(column)) {
                    updatedRow.add(null);
                    continue;
                }
                switch (column.getColumnName()) {
                    case "SQL_DATA_TYPE": {
                        if (typeVal == null) {
                            object = null;
                            break;
                        }
                        if (!this.ctx.isGeoSpatialSupportEnabled() && this.isGeospatialType(typeVal)) {
                            object = 12;
                            break;
                        }
                        if (!this.ctx.isComplexDatatypeSupportEnabled() && this.isComplexType(typeVal)) {
                            object = 12;
                            break;
                        }
                        object = this.getCode(this.stripBaseTypeName(typeVal));
                        break;
                    }
                    case "SQL_DATETIME_SUB": {
                        if (typeVal != null && (this.stripBaseTypeName(typeVal).contains("DATE") || this.stripBaseTypeName(typeVal).contains("TIMESTAMP"))) {
                            object = this.getCode(this.stripBaseTypeName(typeVal));
                            break;
                        }
                        object = null;
                        break;
                    }
                    case "ORDINAL_POSITION": {
                        int ordinalPositionIndex = columns.indexOf(MetadataResultConstants.ORDINAL_POSITION_COLUMN);
                        object = (Integer)row.get(ordinalPositionIndex) + 1;
                        break;
                    }
                    case "COLUMN_DEF": {
                        object = row.get(columns.indexOf(MetadataResultConstants.COLUMN_TYPE_COLUMN));
                        break;
                    }
                    default: {
                        int index = columns.indexOf(column);
                        if (index >= row.size()) {
                            object = null;
                            break;
                        }
                        object = row.get(index);
                        if (column.getColumnName().equals(MetadataResultConstants.IS_NULLABLE_COLUMN.getColumnName())) {
                            object = row.get(columns.indexOf(MetadataResultConstants.NULLABLE_COLUMN));
                            object = object.equals(0) ? "NO" : "YES";
                        }
                        if (column.getColumnName().equals(MetadataResultConstants.DECIMAL_DIGITS_COLUMN.getColumnName())) {
                            object = this.getUpdatedDecimalDigits(this.stripBaseTypeName(typeVal), object);
                        }
                        if (column.getColumnName().equals(MetadataResultConstants.NUM_PREC_RADIX_COLUMN.getColumnName()) && object == null) {
                            object = 0;
                        }
                        if (column.getColumnName().equals(MetadataResultConstants.REMARKS_COLUMN.getColumnName()) && object == null) {
                            object = "";
                        }
                        if (column.getColumnName().equals(MetadataResultConstants.DATA_TYPE_COLUMN.getColumnName())) {
                            object = !this.ctx.isComplexDatatypeSupportEnabled() && this.isComplexType(typeVal) ? Integer.valueOf(12) : Integer.valueOf(this.getCode(this.stripBaseTypeName(typeVal)));
                        }
                        if (column.getColumnName().equals(MetadataResultConstants.CHAR_OCTET_LENGTH_COLUMN.getColumnName()) && (object = Integer.valueOf(this.getCharOctetLength(typeVal))).equals(0)) {
                            object = null;
                        }
                        if (column.getColumnName().equals(MetadataResultConstants.BUFFER_LENGTH_COLUMN.getColumnName())) {
                            object = this.getBufferLength(typeVal);
                        }
                        if (column.getColumnName().equals(MetadataResultConstants.TABLE_TYPE_COLUMN.getColumnName()) && (object == null || object.equals(""))) {
                            object = "TABLE";
                        }
                        if (column.getColumnName().equals(MetadataResultConstants.COLUMN_TYPE_COLUMN.getColumnName())) {
                            object = typeVal != null && (typeVal.contains("measure") || typeVal.contains("ARRAY") || typeVal.contains("MAP") || typeVal.contains("STRUCT")) ? typeVal : this.stripBaseTypeName(typeVal);
                        }
                        if (!column.getColumnName().equals(MetadataResultConstants.COLUMN_SIZE_COLUMN.getColumnName())) break;
                        object = this.getColumnSize(typeVal);
                    }
                }
                updatedRow.add(object);
            }
            updatedRows.add(updatedRow);
        }
        return updatedRows;
    }

    public DatabricksResultSet getPrimaryKeysResult(List<List<Object>> rows) {
        return this.buildResultSet(MetadataResultConstants.PRIMARY_KEYS_COLUMNS, this.getThriftRows(rows, MetadataResultConstants.PRIMARY_KEYS_COLUMNS), "metadata-statement", CommandName.LIST_PRIMARY_KEYS);
    }

    public DatabricksResultSet getFunctionsResult(String catalog, List<List<Object>> rows) {
        if (rows != null) {
            rows.forEach(row -> row.set(MetadataResultConstants.FUNCTION_COLUMNS.indexOf(MetadataResultConstants.FUNCTION_CATALOG_COLUMN), catalog));
        }
        return this.buildResultSet(MetadataResultConstants.FUNCTION_COLUMNS, this.getThriftRows(rows, MetadataResultConstants.FUNCTION_COLUMNS), "getfunctions-metadata", CommandName.LIST_FUNCTIONS);
    }
}

