/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.model.core;

import com.databricks.jdbc.model.core.ExternalLink;
import java.util.Collections;
import java.util.List;

public class ChunkLinkFetchResult {
    private final List<ExternalLink> chunkLinks;
    private final boolean hasMore;
    private final long nextFetchIndex;
    private final long nextRowOffset;

    private ChunkLinkFetchResult(List<ExternalLink> chunkLinks, boolean hasMore, long nextFetchIndex, long nextRowOffset) {
        this.chunkLinks = chunkLinks;
        this.hasMore = hasMore;
        this.nextFetchIndex = nextFetchIndex;
        this.nextRowOffset = nextRowOffset;
    }

    public static ChunkLinkFetchResult of(List<ExternalLink> links, boolean hasMore, long nextFetchIndex, long nextRowOffset) {
        return new ChunkLinkFetchResult(links, hasMore, nextFetchIndex, nextRowOffset);
    }

    public static ChunkLinkFetchResult endOfStream() {
        return new ChunkLinkFetchResult(Collections.emptyList(), false, -1L, 0L);
    }

    public List<ExternalLink> getChunkLinks() {
        return this.chunkLinks;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public long getNextFetchIndex() {
        return this.nextFetchIndex;
    }

    public long getNextRowOffset() {
        return this.nextRowOffset;
    }

    public boolean isEndOfStream() {
        return !this.hasMore && this.chunkLinks.isEmpty();
    }
}

