/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable.page;

import be.quodlibet.boxable.page.PageProvider;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public class DefaultPageProvider
implements PageProvider<PDPage> {
    private final PDDocument document;
    private final PDRectangle size;
    private int currentPageIndex = -1;

    public DefaultPageProvider(PDDocument document, PDRectangle size) {
        this.document = document;
        this.size = size;
    }

    @Override
    public PDDocument getDocument() {
        return this.document;
    }

    @Override
    public PDPage createPage() {
        this.currentPageIndex = this.document.getNumberOfPages();
        return this.getCurrentPage();
    }

    @Override
    public PDPage nextPage() {
        this.currentPageIndex = this.currentPageIndex == -1 ? this.document.getNumberOfPages() : ++this.currentPageIndex;
        return this.getCurrentPage();
    }

    @Override
    public PDPage previousPage() {
        --this.currentPageIndex;
        if (this.currentPageIndex < 0) {
            this.currentPageIndex = 0;
        }
        return this.getCurrentPage();
    }

    private PDPage getCurrentPage() {
        if (this.currentPageIndex >= this.document.getNumberOfPages()) {
            PDPage newPage = new PDPage(this.size);
            this.document.addPage(newPage);
            return newPage;
        }
        return this.document.getPage(this.currentPageIndex);
    }
}

