/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.files;

public class MimeTypeUtils {
    private static String getRawMimeType(String ext) {
        switch (ext.toLowerCase()) {
            case "txt": {
                return "text/plain";
            }
            case "html": 
            case "htm": {
                return "text/html";
            }
            case "py": {
                return "text/x-python";
            }
            case "jl": {
                return "text/x-julia";
            }
            case "r": {
                return "text/x-rsrc";
            }
            case "scala": {
                return "text/x-scala";
            }
            case "sh": {
                return "text/x-sh";
            }
            case "sql": {
                return "text/x-sql";
            }
            case "md": {
                return "text/x-markdown";
            }
            case "csv": {
                return "text/csv";
            }
            case "json": {
                return "application/json";
            }
            case "js": {
                return "application/javascript";
            }
            case "jar": {
                return "application/java-archive";
            }
            case "pdf": {
                return "application/pdf";
            }
            case "xml": {
                return "application/xml";
            }
            case "tar": {
                return "application/x-tar";
            }
            case "bz": {
                return "application/x-bzip";
            }
            case "zip": {
                return "application/zip";
            }
            case "gz": 
            case "tar.gz": {
                return "application/x-gzip";
            }
            case "bmp": {
                return "image/bmp";
            }
            case "gif": {
                return "image/gif";
            }
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "png": {
                return "image/png";
            }
            case "svg": {
                return "image/svg+xml";
            }
            case "tiff": {
                return "image/tiff";
            }
            case "doc": {
                return "application/msword";
            }
            case "docx": {
                return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            }
        }
        return null;
    }

    public static MimeType fromExtension(String ext) {
        if (ext == null) {
            return null;
        }
        String raw = MimeTypeUtils.getRawMimeType(ext);
        if (raw == null) {
            return null;
        }
        return new MimeType(raw, ext);
    }

    public static class MimeType {
        public String mimeType;
        public String extension;

        public MimeType() {
        }

        public MimeType(String mimeType, String extension) {
            this.mimeType = mimeType;
            this.extension = extension;
        }
    }
}

