/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.resourceusage;

import com.dataiku.common.stereotype.PartOfPublicAPI;
import com.dataiku.dip.security.AuthCtx;

@PartOfPublicAPI
public class ComputeResourceUsageContext {
    public ComputeResourceUsageContextType type;
    public String authIdentifier;
    public String projectKey;
    public String jobId;
    public String activityId;
    public String activityType;
    public String runnableType;
    public String datasetName;
    public String recipeType;
    public String recipeName;
    public String scenarioId;
    public String stepId;
    public String triggerId;
    public String webappId;
    public String analysisId;
    public String llmId;
    public String toolId;
    public String savedModelId;
    public String savedModelVersionId;
    public String mesId;
    public String evaluationId;
    public String mlTaskId;
    public String sessionId;
    public String sqlNotebookId;
    public String jupyterNotebookId;
    public String jupyterSessionId;
    public String codeStudioId;
    public String codeStudioTemplateId;
    public String promptStudioId;
    public String insightId;
    public String clusterId;
    public String connection;
    public String apiDeployerInfraId;
    public String apiDeployerServiceId;
    public String apiDeployerDeploymentId;
    public String sparkConf;
    public String query;

    ComputeResourceUsageContext() {
    }

    public static ComputeResourceUsageContext forJobMainProcess(AuthCtx authCtx, String projectKey, String jobId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.JOB_MAIN_PROCESS;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.jobId = jobId;
        return ctx;
    }

    public static ComputeResourceUsageContext forJobDepsComputation(AuthCtx authCtx, String projectKey, String jobId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.JOB_DEPS_COMPUTATION;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.jobId = jobId;
        return ctx;
    }

    public static ComputeResourceUsageContext forJobActivity(AuthCtx authCtx, String projectKey, String jobId, String activityId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.JOB_ACTIVITY;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.jobId = jobId;
        ctx.activityId = activityId;
        return ctx;
    }

    public static ComputeResourceUsageContext forCDE(AuthCtx authCtx, String projectKey, String jobId, String activityId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.CONTAINERIZED_DSS_ENGINE;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.jobId = jobId;
        ctx.activityId = activityId;
        return ctx;
    }

    public static ComputeResourceUsageContext forContinuousActivity(AuthCtx authCtx, String projectKey, String activityId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.CONTINUOUS_ACTIVITY;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.activityId = activityId;
        return ctx;
    }

    public static ComputeResourceUsageContext forAnalysisMLTrain(AuthCtx authCtx, String projectKey, String analysisId, String mlTaskId, String sessionId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.ANALYSIS_ML_TRAIN;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.analysisId = analysisId;
        ctx.mlTaskId = mlTaskId;
        ctx.sessionId = sessionId;
        return ctx;
    }

    public static ComputeResourceUsageContext forHFModel(String projectKey, String llmId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.HF_MODEL;
        ctx.llmId = llmId;
        ctx.projectKey = projectKey;
        return ctx;
    }

    public static ComputeResourceUsageContext forRAGKernel(AuthCtx authCtx, String projectKey, String llmId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.type = ComputeResourceUsageContextType.RAG_KERNEL;
        ctx.projectKey = projectKey;
        ctx.llmId = llmId;
        return ctx;
    }

    public static ComputeResourceUsageContext forPythonAgentKernel(AuthCtx authCtx, String projectKey, String llmId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.type = ComputeResourceUsageContextType.PYTHON_AGENT_KERNEL;
        ctx.projectKey = projectKey;
        ctx.llmId = llmId;
        return ctx;
    }

    public static ComputeResourceUsageContext forPythonAgentTool(AuthCtx authCtx, String projectKey, String toolId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.type = ComputeResourceUsageContextType.PYTHON_AGENT_TOOL_KERNEL;
        ctx.projectKey = projectKey;
        ctx.toolId = toolId;
        return ctx;
    }

    public static ComputeResourceUsageContext forDocumentExtractionKernel(AuthCtx authCtx, String projectKey) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.type = ComputeResourceUsageContextType.DOCUMENT_EXTRACTION_KERNEL;
        ctx.projectKey = projectKey;
        return ctx;
    }

    public static ComputeResourceUsageContext forPIIGuardrailKernel(String projectKey) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.PII_GUARDRAIL_KERNEL;
        ctx.projectKey = projectKey;
        return ctx;
    }

    public static ComputeResourceUsageContext forSavedMLOperation(AuthCtx authCtx, String projectKey, String savedModelId, String savedModelVersionId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.SAVED_MODEL_OPERATION;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.savedModelId = savedModelId;
        ctx.savedModelVersionId = savedModelVersionId;
        return ctx;
    }

    public static ComputeResourceUsageContext forModelEvaluationOperation(AuthCtx authCtx, String projectKey, String id, String evaluationId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.MODEL_EVALUATION_OPERATION;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.mesId = id;
        ctx.evaluationId = evaluationId;
        return ctx;
    }

    public static ComputeResourceUsageContext forPooledSparkSQLConnection(AuthCtx authCtx) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.POOLED_SPARKSQL_CONNECTION;
        ctx.authIdentifier = authCtx.getIdentifier();
        return ctx;
    }

    public static ComputeResourceUsageContext forSQLNotebook(AuthCtx authCtx, String projectKey, String notebookId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.SQL_NOTEBOOK;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.sqlNotebookId = notebookId;
        return ctx;
    }

    public static ComputeResourceUsageContext forJupyterNotebookKernel(AuthCtx authCtx, String projectKey, String notebookId, String sessionId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.JUPYTER_NOTEBOOK_KERNEL;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.jupyterNotebookId = notebookId;
        ctx.jupyterSessionId = sessionId;
        return ctx;
    }

    public static ComputeResourceUsageContext forEDA(AuthCtx authCtx, String projectKey, String datasetSmartName) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.EDA;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.datasetName = datasetSmartName;
        return ctx;
    }

    public static ComputeResourceUsageContext forWebappBackend(AuthCtx authCtx, String projectKey, String webappId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.WEBAPP_BACKEND;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.webappId = webappId;
        return ctx;
    }

    public static ComputeResourceUsageContext forAPIDeployerDeployment(AuthCtx authCtx, String infra, String service, String deployment) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.API_DEPLOYER_DEPLOYMENT;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.apiDeployerInfraId = infra;
        ctx.apiDeployerServiceId = service;
        ctx.apiDeployerDeploymentId = deployment;
        return ctx;
    }

    public static ComputeResourceUsageContext forExternalDeploymentInfraOperation(AuthCtx authCtx, String connection) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.EXTERNAL_DEPLOYMENT_INFRA_OPERATION;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.connection = connection;
        return ctx;
    }

    public static ComputeResourceUsageContext forCodeStudio(AuthCtx authCtx, String projectKey, String codeStudioId, String templateId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.CODE_STUDIO;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.codeStudioId = codeStudioId;
        ctx.codeStudioTemplateId = templateId;
        return ctx;
    }

    public static ComputeResourceUsageContext forDatasetSampleBuild(AuthCtx authCtx, String projectKey, String datasetName) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.DATASET_SAMPLE_BUILD;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.datasetName = datasetName;
        return ctx;
    }

    public static ComputeResourceUsageContext forSqlStreaming(AuthCtx authCtx, String projectKey) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.SQL_STREAMING;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        return ctx;
    }

    public static ComputeResourceUsageContext forDatasetCharts(AuthCtx authCtx, String projectKey, String datasetName) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.DATASET_CHARTS;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.datasetName = datasetName;
        return ctx;
    }

    public static ComputeResourceUsageContext forMetrics(AuthCtx authCtx, String projectKey, String datasetName) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.METRICS;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.datasetName = datasetName;
        return ctx;
    }

    public static ComputeResourceUsageContext forDatasetClearing(AuthCtx authCtx, String projectKey, String datasetName) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.DATASET_CLEARING;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.datasetName = datasetName;
        return ctx;
    }

    public static ComputeResourceUsageContext forDatasetOrConnectionTesting(AuthCtx authCtx, String projectKey, String datasetName) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.DATASET_OR_CONNECTION_TESTING;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.datasetName = datasetName;
        return ctx;
    }

    public static ComputeResourceUsageContext forPromptStudio(AuthCtx authCtx, String projectKey, String promptStudioId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.PROMPT_STUDIO;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.promptStudioId = promptStudioId;
        return ctx;
    }

    public static ComputeResourceUsageContext forLLMAPI(AuthCtx authCtx, String projectKey) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.LLM_API;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        return ctx;
    }

    public static ComputeResourceUsageContext forScenarioTrigger(AuthCtx authCtx, String projectKey, String scenarioId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.SCENARIO_TRIGGER;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.scenarioId = scenarioId;
        return ctx;
    }

    public static ComputeResourceUsageContext forReadData(AuthCtx authCtx, String projectKey, String datasetName) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.READ_DATA;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.projectKey = projectKey;
        ctx.datasetName = datasetName;
        return ctx;
    }

    public static ComputeResourceUsageContext forMacro(AuthCtx authCtx, String runnableType, String projectKey, String scenarioId, String clusterId, String insightId) {
        ComputeResourceUsageContext ctx = new ComputeResourceUsageContext();
        ctx.type = ComputeResourceUsageContextType.MACRO;
        ctx.authIdentifier = authCtx.getIdentifier();
        ctx.runnableType = runnableType;
        ctx.projectKey = projectKey;
        ctx.scenarioId = scenarioId;
        ctx.clusterId = clusterId;
        ctx.insightId = insightId;
        return ctx;
    }

    @PartOfPublicAPI
    public static enum ComputeResourceUsageContextType {
        JOB_MAIN_PROCESS,
        JOB_DEPS_COMPUTATION,
        JOB_ACTIVITY,
        CONTINUOUS_ACTIVITY,
        SQL_NOTEBOOK,
        SQL_STREAMING,
        POOLED_SPARKSQL_CONNECTION,
        ANALYSIS_ML_TRAIN,
        SAVED_MODEL_OPERATION,
        MODEL_EVALUATION_OPERATION,
        JUPYTER_NOTEBOOK_KERNEL,
        WEBAPP_BACKEND,
        EDA,
        API_DEPLOYER_DEPLOYMENT,
        EXTERNAL_DEPLOYMENT_INFRA_OPERATION,
        CODE_STUDIO,
        DATASET_SAMPLE_BUILD,
        DATASET_CHARTS,
        DATASET_CLEARING,
        DATASET_OR_CONNECTION_TESTING,
        METRICS,
        PROMPT_STUDIO,
        CONTAINERIZED_DSS_ENGINE,
        SCENARIO_TRIGGER,
        READ_DATA,
        MACRO,
        HF_MODEL,
        LLM_API,
        RAG_KERNEL,
        PYTHON_AGENT_KERNEL,
        PYTHON_AGENT_TOOL_KERNEL,
        DOCUMENT_EXTRACTION_KERNEL,
        PII_GUARDRAIL_KERNEL,
        UNKNOWN;

    }
}

