/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.google.auth.oauth2;

import com.dataiku.dss.shadelibdatabricks.com.google.api.client.http.HttpResponseException;
import com.dataiku.dss.shadelibdatabricks.com.google.api.client.json.GenericJson;
import com.dataiku.dss.shadelibdatabricks.com.google.api.client.json.JsonParser;
import com.dataiku.dss.shadelibdatabricks.com.google.auth.oauth2.GoogleAuthException;
import com.dataiku.dss.shadelibdatabricks.com.google.auth.oauth2.OAuth2Utils;
import com.dataiku.dss.shadelibdatabricks.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelibdatabricks.javax.annotation.Nullable;
import java.io.IOException;

class OAuthException
extends GoogleAuthException {
    private final String errorCode;
    @Nullable
    private final String errorDescription;
    @Nullable
    private final String errorUri;

    OAuthException(String errorCode, @Nullable String errorDescription, @Nullable String errorUri) {
        this.errorCode = Preconditions.checkNotNull(errorCode);
        this.errorDescription = errorDescription;
        this.errorUri = errorUri;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder("Error code " + this.errorCode);
        if (this.errorDescription != null) {
            sb.append(": ").append(this.errorDescription);
        }
        if (this.errorUri != null) {
            sb.append(" - ").append(this.errorUri);
        }
        return sb.toString();
    }

    String getErrorCode() {
        return this.errorCode;
    }

    @Nullable
    String getErrorDescription() {
        return this.errorDescription;
    }

    @Nullable
    String getErrorUri() {
        return this.errorUri;
    }

    static OAuthException createFromHttpResponseException(HttpResponseException e) throws IOException {
        JsonParser parser = OAuth2Utils.JSON_FACTORY.createJsonParser(e.getContent());
        GenericJson errorResponse = parser.parseAndClose(GenericJson.class);
        String errorCode = (String)errorResponse.get("error");
        String errorDescription = null;
        String errorUri = null;
        if (errorResponse.containsKey("error_description")) {
            errorDescription = (String)errorResponse.get("error_description");
        }
        if (errorResponse.containsKey("error_uri")) {
            errorUri = (String)errorResponse.get("error_uri");
        }
        return new OAuthException(errorCode, errorDescription, errorUri);
    }
}

