/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateTagsRequestMarshaller
implements Marshaller<Request<CreateTagsRequest>, CreateTagsRequest> {
    @Override
    public Request<CreateTagsRequest> marshall(CreateTagsRequest createTagsRequest) {
        SdkInternalList createTagsRequestTagsList;
        if (createTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateTagsRequest> request = new DefaultRequest<CreateTagsRequest>(createTagsRequest, "AmazonEC2");
        request.addParameter("Action", "CreateTags");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList createTagsRequestResourcesList = (SdkInternalList)createTagsRequest.getResources();
        if (!createTagsRequestResourcesList.isEmpty() || !createTagsRequestResourcesList.isAutoConstruct()) {
            int resourcesListIndex = 1;
            for (String createTagsRequestResourcesListValue : createTagsRequestResourcesList) {
                if (createTagsRequestResourcesListValue != null) {
                    request.addParameter("ResourceId." + resourcesListIndex, StringUtils.fromString(createTagsRequestResourcesListValue));
                }
                ++resourcesListIndex;
            }
        }
        if (!(createTagsRequestTagsList = (SdkInternalList)createTagsRequest.getTags()).isEmpty() || !createTagsRequestTagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag createTagsRequestTagsListValue : createTagsRequestTagsList) {
                if (createTagsRequestTagsListValue.getKey() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Key", StringUtils.fromString(createTagsRequestTagsListValue.getKey()));
                }
                if (createTagsRequestTagsListValue.getValue() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Value", StringUtils.fromString(createTagsRequestTagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

