/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.commons.configuration2.beanutils;

import com.dataiku.dss.shadelib.org.apache.commons.configuration2.beanutils.BeanDeclaration;
import com.dataiku.dss.shadelib.org.apache.commons.configuration2.beanutils.ConstructorArg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class CombinedBeanDeclaration
implements BeanDeclaration {
    private final ArrayList<BeanDeclaration> childDeclarations;

    public CombinedBeanDeclaration(BeanDeclaration ... decl) {
        this.childDeclarations = new ArrayList<BeanDeclaration>(Arrays.asList(decl));
    }

    private <T> T findFirst(Function<? super BeanDeclaration, ? extends T> mapper) {
        return this.childDeclarations.stream().map(mapper).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private Map<String, Object> get(Function<? super BeanDeclaration, ? extends Map<String, Object>> mapper) {
        ArrayList temp = (ArrayList)this.childDeclarations.clone();
        Collections.reverse(temp);
        return temp.stream().map(mapper).filter(Objects::nonNull).collect(HashMap::new, HashMap::putAll, HashMap::putAll);
    }

    @Override
    public String getBeanClassName() {
        return this.findFirst(BeanDeclaration::getBeanClassName);
    }

    @Override
    public String getBeanFactoryName() {
        return this.findFirst(BeanDeclaration::getBeanFactoryName);
    }

    @Override
    public Object getBeanFactoryParameter() {
        return this.findFirst(BeanDeclaration::getBeanFactoryParameter);
    }

    @Override
    public Map<String, Object> getBeanProperties() {
        return this.get(BeanDeclaration::getBeanProperties);
    }

    @Override
    public Collection<ConstructorArg> getConstructorArgs() {
        for (BeanDeclaration d : this.childDeclarations) {
            Collection<ConstructorArg> args2 = d.getConstructorArgs();
            if (args2 == null || args2.isEmpty()) continue;
            return args2;
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Object> getNestedBeanDeclarations() {
        return this.get(BeanDeclaration::getNestedBeanDeclarations);
    }
}

