/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.hc.core5.http.impl.nio;

import com.dataiku.dss.shadelib.org.apache.hc.core5.annotation.Contract;
import com.dataiku.dss.shadelib.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.URIScheme;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.impl.nio.ServerHttp1IOEventHandler;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import com.dataiku.dss.shadelib.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import com.dataiku.dss.shadelib.org.apache.hc.core5.reactor.EndpointParameters;
import com.dataiku.dss.shadelib.org.apache.hc.core5.reactor.IOEventHandler;
import com.dataiku.dss.shadelib.org.apache.hc.core5.reactor.IOEventHandlerFactory;
import com.dataiku.dss.shadelib.org.apache.hc.core5.reactor.ProtocolIOSession;
import com.dataiku.dss.shadelib.org.apache.hc.core5.util.Args;
import com.dataiku.dss.shadelib.org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ServerHttp1IOEventHandlerFactory
implements IOEventHandlerFactory {
    private final ServerHttp1StreamDuplexerFactory streamDuplexerFactory;
    private final TlsStrategy tlsStrategy;
    private final Timeout handshakeTimeout;

    public ServerHttp1IOEventHandlerFactory(ServerHttp1StreamDuplexerFactory streamDuplexerFactory, TlsStrategy tlsStrategy, Timeout handshakeTimeout) {
        this.streamDuplexerFactory = Args.notNull(streamDuplexerFactory, "Stream duplexer factory");
        this.tlsStrategy = tlsStrategy;
        this.handshakeTimeout = handshakeTimeout;
    }

    @Override
    public IOEventHandler createHandler(ProtocolIOSession ioSession, Object attachment) {
        String endpointScheme = URIScheme.HTTP.id;
        if (this.tlsStrategy != null) {
            if (attachment instanceof EndpointParameters) {
                EndpointParameters params = (EndpointParameters)attachment;
                endpointScheme = params.getScheme();
                if (URIScheme.HTTPS.same(endpointScheme)) {
                    this.tlsStrategy.upgrade(ioSession, params, params.getAttachment(), this.handshakeTimeout, null);
                }
            } else {
                endpointScheme = URIScheme.HTTPS.id;
                this.tlsStrategy.upgrade(ioSession, null, attachment, this.handshakeTimeout, null);
            }
        }
        return new ServerHttp1IOEventHandler(this.streamDuplexerFactory.create(endpointScheme, ioSession));
    }
}

