/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseMetadataTableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataTableType;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScanContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.events.Listeners;
import com.dataiku.dss.shadelib.org.apache.iceberg.events.ScanEvent;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.ExpressionUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Function;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ParallelIterable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseAllMetadataTableScan
extends BaseMetadataTableScan {
    private static final Logger LOG = LoggerFactory.getLogger(BaseAllMetadataTableScan.class);

    BaseAllMetadataTableScan(Table table, Schema schema, MetadataTableType tableType) {
        super(table, schema, tableType);
    }

    BaseAllMetadataTableScan(Table table, Schema schema, MetadataTableType tableType, TableScanContext context) {
        super(table, schema, tableType, context);
    }

    @Override
    public TableScan useSnapshot(long scanSnapshotId) {
        throw new UnsupportedOperationException("Cannot select snapshot in table: " + String.valueOf((Object)this.tableType()));
    }

    @Override
    public TableScan useRef(String ref) {
        throw new UnsupportedOperationException("Cannot select ref in table: " + String.valueOf((Object)this.tableType()));
    }

    @Override
    public TableScan asOfTime(long timestampMillis) {
        throw new UnsupportedOperationException("Cannot select snapshot in table: " + String.valueOf((Object)this.tableType()));
    }

    @Override
    public CloseableIterable<FileScanTask> planFiles() {
        String metadataTableName = this.table().name() + "." + this.tableType().name().toLowerCase(Locale.ROOT);
        LOG.info("Scanning metadata table {} with filter {}.", (Object)metadataTableName, (Object)ExpressionUtil.toSanitizedString(this.filter()));
        Listeners.notifyAll(new ScanEvent(metadataTableName, 0L, this.filter(), this.schema()));
        return this.doPlanFiles();
    }

    protected CloseableIterable<ManifestFile> reachableManifests(Function<Snapshot, Iterable<ManifestFile>> toManifests) {
        CloseableIterable<ManifestFile> closeableIterable;
        Iterable<Snapshot> snapshots = this.table().snapshots();
        Iterable<Iterable<ManifestFile>> manifestIterables = Iterables.transform(snapshots, toManifests);
        ParallelIterable<ManifestFile> iterable = new ParallelIterable<ManifestFile>(manifestIterables, this.planExecutor());
        try {
            closeableIterable = CloseableIterable.withNoopClose(Sets.newHashSet(iterable));
        }
        catch (Throwable throwable) {
            try {
                try {
                    iterable.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close parallel iterable", e);
            }
        }
        iterable.close();
        return closeableIterable;
    }
}

