/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseTable;
import com.dataiku.dss.shadelib.org.apache.iceberg.BaseTableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataTableType;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScanContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.PropertyUtil;

abstract class BaseMetadataTableScan
extends BaseTableScan {
    private final MetadataTableType tableType;

    protected BaseMetadataTableScan(Table table, Schema schema, MetadataTableType tableType) {
        super(table, schema, TableScanContext.empty());
        this.tableType = tableType;
    }

    protected BaseMetadataTableScan(Table table, Schema schema, MetadataTableType tableType, TableScanContext context) {
        super(table, schema, context);
        this.tableType = tableType;
    }

    protected MetadataTableType tableType() {
        return this.tableType;
    }

    @Override
    public TableScan appendsBetween(long fromSnapshotId, long toSnapshotId) {
        throw new UnsupportedOperationException(String.format("Cannot incrementally scan table of type %s", new Object[]{this.tableType()}));
    }

    @Override
    public TableScan appendsAfter(long fromSnapshotId) {
        throw new UnsupportedOperationException(String.format("Cannot incrementally scan table of type %s", new Object[]{this.tableType()}));
    }

    @Override
    public long targetSplitSize() {
        long tableValue = ((BaseTable)this.table()).operations().current().propertyAsLong("read.split.metadata-target-size", 0x2000000L);
        return PropertyUtil.propertyAsLong(this.options(), "read.split.target-size", tableValue);
    }
}

