/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.MergingSnapshotProducer;
import com.dataiku.dss.shadelib.org.apache.iceberg.RewriteFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.DataFileSet;
import java.util.Set;

class BaseRewriteFiles
extends MergingSnapshotProducer<RewriteFiles>
implements RewriteFiles {
    private final DataFileSet replacedDataFiles = DataFileSet.create();
    private Long startingSnapshotId = null;

    BaseRewriteFiles(String tableName, TableOperations ops) {
        super(tableName, ops);
        this.failMissingDeletePaths();
    }

    @Override
    protected RewriteFiles self() {
        return this;
    }

    @Override
    protected String operation() {
        return "replace";
    }

    @Override
    public RewriteFiles deleteFile(DataFile dataFile) {
        this.replacedDataFiles.add(dataFile);
        this.delete(dataFile);
        return this.self();
    }

    @Override
    public RewriteFiles deleteFile(DeleteFile deleteFile) {
        this.delete(deleteFile);
        return this.self();
    }

    @Override
    public RewriteFiles addFile(DataFile dataFile) {
        this.add(dataFile);
        return this.self();
    }

    @Override
    public RewriteFiles addFile(DeleteFile deleteFile) {
        this.add(deleteFile);
        return this.self();
    }

    @Override
    public RewriteFiles addFile(DeleteFile deleteFile, long dataSequenceNumber) {
        this.add(deleteFile, dataSequenceNumber);
        return this.self();
    }

    @Override
    public RewriteFiles dataSequenceNumber(long sequenceNumber) {
        this.setNewDataFilesDataSequenceNumber(sequenceNumber);
        return this.self();
    }

    @Override
    public RewriteFiles rewriteFiles(Set<DataFile> filesToDelete, Set<DataFile> filesToAdd, long sequenceNumber) {
        this.setNewDataFilesDataSequenceNumber(sequenceNumber);
        return this.rewriteFiles(filesToDelete, ImmutableSet.of(), filesToAdd, ImmutableSet.of());
    }

    @Override
    public RewriteFiles rewriteFiles(Set<DataFile> dataFilesToReplace, Set<DeleteFile> deleteFilesToReplace, Set<DataFile> dataFilesToAdd, Set<DeleteFile> deleteFilesToAdd) {
        Preconditions.checkNotNull(dataFilesToReplace, "Replaced data files can't be null");
        Preconditions.checkNotNull(deleteFilesToReplace, "Replaced delete files can't be null");
        Preconditions.checkNotNull(dataFilesToAdd, "Added data files can't be null");
        Preconditions.checkNotNull(deleteFilesToAdd, "Added delete files can't be null");
        for (DataFile dataFile : dataFilesToReplace) {
            this.deleteFile(dataFile);
        }
        for (DeleteFile deleteFile : deleteFilesToReplace) {
            this.deleteFile(deleteFile);
        }
        for (DataFile dataFile : dataFilesToAdd) {
            this.addFile(dataFile);
        }
        for (DeleteFile deleteFile : deleteFilesToAdd) {
            this.addFile(deleteFile);
        }
        return this;
    }

    @Override
    public RewriteFiles validateFromSnapshot(long snapshotId) {
        this.startingSnapshotId = snapshotId;
        return this;
    }

    @Override
    public BaseRewriteFiles toBranch(String branch) {
        this.targetBranch(branch);
        return this;
    }

    @Override
    protected void validate(TableMetadata base, Snapshot parent) {
        this.validateReplacedAndAddedFiles();
        if (!this.replacedDataFiles.isEmpty()) {
            this.validateNoNewDeletesForDataFiles(base, this.startingSnapshotId, this.replacedDataFiles, parent);
        }
    }

    private void validateReplacedAndAddedFiles() {
        Preconditions.checkArgument(this.deletesDataFiles() || this.deletesDeleteFiles(), "Files to delete cannot be empty");
        Preconditions.checkArgument(this.deletesDataFiles() || !this.addsDataFiles(), "Data files to add must be empty because there's no data file to be rewritten");
        Preconditions.checkArgument(this.deletesDeleteFiles() || !this.addsDeleteFiles(), "Delete files to add must be empty because there's no delete file to be rewritten");
    }
}

