/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestContent;
import com.dataiku.dss.shadelib.org.apache.iceberg.Scan;
import com.dataiku.dss.shadelib.org.apache.iceberg.ScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.ScanTaskGroup;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.SystemConfigs;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScanContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Binder;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expressions;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.MetricsReporter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.TypeUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.PropertyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

abstract class BaseScan<ThisT, T extends ScanTask, G extends ScanTaskGroup<T>>
implements Scan<ThisT, T, G> {
    protected static final List<String> SCAN_COLUMNS = ImmutableList.of("snapshot_id", "file_path", "file_ordinal", "file_format", "block_size_in_bytes", "file_size_in_bytes", "record_count", "partition", "key_metadata", "split_offsets", "sort_order_id");
    private static final List<String> STATS_COLUMNS = ImmutableList.of("value_counts", "null_value_counts", "nan_value_counts", "lower_bounds", "upper_bounds", "column_sizes");
    protected static final List<String> SCAN_WITH_STATS_COLUMNS = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(SCAN_COLUMNS)).addAll(STATS_COLUMNS)).build();
    protected static final List<String> DELETE_SCAN_COLUMNS = ImmutableList.of("snapshot_id", "content", "file_path", "file_ordinal", "file_format", "block_size_in_bytes", "file_size_in_bytes", "record_count", "partition", "key_metadata", "split_offsets", "referenced_data_file", new String[]{"content_offset", "content_size_in_bytes", "equality_ids"});
    protected static final List<String> DELETE_SCAN_WITH_STATS_COLUMNS = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(DELETE_SCAN_COLUMNS)).addAll(STATS_COLUMNS)).build();
    protected static final boolean PLAN_SCANS_WITH_WORKER_POOL = SystemConfigs.SCAN_THREAD_POOL_ENABLED.value();
    private final Table table;
    private final Schema schema;
    private final TableScanContext context;

    protected BaseScan(Table table, Schema schema, TableScanContext context) {
        this.table = table;
        this.schema = schema;
        this.context = context;
    }

    public Table table() {
        return this.table;
    }

    protected FileIO io() {
        return this.table.io();
    }

    protected Schema tableSchema() {
        return this.schema;
    }

    protected TableScanContext context() {
        return this.context;
    }

    protected Map<String, String> options() {
        return this.context().options();
    }

    protected List<String> scanColumns() {
        return this.context.returnColumnStats() ? SCAN_WITH_STATS_COLUMNS : SCAN_COLUMNS;
    }

    protected boolean shouldReturnColumnStats() {
        return this.context().returnColumnStats();
    }

    protected Set<Integer> columnsToKeepStats() {
        return this.context().columnsToKeepStats();
    }

    protected boolean shouldIgnoreResiduals() {
        return this.context().ignoreResiduals();
    }

    protected Expression residualFilter() {
        return this.shouldIgnoreResiduals() ? Expressions.alwaysTrue() : this.filter();
    }

    protected boolean shouldPlanWithExecutor() {
        return PLAN_SCANS_WITH_WORKER_POOL || this.context().planWithCustomizedExecutor();
    }

    protected ExecutorService planExecutor() {
        return this.context().planExecutor();
    }

    protected abstract ThisT newRefinedScan(Table var1, Schema var2, TableScanContext var3);

    @Override
    public ThisT option(String property, String value) {
        return this.newRefinedScan(this.table, this.schema, this.context.withOption(property, value));
    }

    @Override
    public ThisT project(Schema projectedSchema) {
        return this.newRefinedScan(this.table, this.schema, this.context.project(projectedSchema));
    }

    @Override
    public ThisT caseSensitive(boolean caseSensitive) {
        return this.newRefinedScan(this.table, this.schema, this.context.setCaseSensitive(caseSensitive));
    }

    @Override
    public boolean isCaseSensitive() {
        return this.context().caseSensitive();
    }

    @Override
    public ThisT includeColumnStats() {
        return this.newRefinedScan(this.table, this.schema, this.context.shouldReturnColumnStats(true));
    }

    @Override
    public ThisT includeColumnStats(Collection<String> requestedColumns) {
        return this.newRefinedScan(this.table, this.schema, this.context.shouldReturnColumnStats(true).columnsToKeepStats(requestedColumns.stream().map(c -> this.schema.findField((String)c).fieldId()).collect(Collectors.toSet())));
    }

    @Override
    public ThisT select(Collection<String> columns) {
        return this.newRefinedScan(this.table, this.schema, this.context.selectColumns(columns));
    }

    @Override
    public ThisT filter(Expression expr) {
        return this.newRefinedScan(this.table, this.schema, this.context.filterRows(Expressions.and(this.context.rowFilter(), expr)));
    }

    @Override
    public Expression filter() {
        return this.context().rowFilter();
    }

    @Override
    public ThisT ignoreResiduals() {
        return this.newRefinedScan(this.table, this.schema, this.context.ignoreResiduals(true));
    }

    @Override
    public ThisT planWith(ExecutorService executorService) {
        return this.newRefinedScan(this.table, this.schema, this.context.planWith(executorService));
    }

    @Override
    public Schema schema() {
        return BaseScan.lazyColumnProjection(this.context, this.schema);
    }

    @Override
    public long targetSplitSize() {
        long tableValue = PropertyUtil.propertyAsLong(this.table().properties(), "read.split.target-size", 0x8000000L);
        return PropertyUtil.propertyAsLong(this.context.options(), "read.split.target-size", tableValue);
    }

    @Override
    public int splitLookback() {
        int tableValue = PropertyUtil.propertyAsInt(this.table().properties(), "read.split.planning-lookback", 10);
        return PropertyUtil.propertyAsInt(this.context.options(), "read.split.planning-lookback", tableValue);
    }

    @Override
    public long splitOpenFileCost() {
        long tableValue = PropertyUtil.propertyAsLong(this.table().properties(), "read.split.open-file-cost", 0x400000L);
        return PropertyUtil.propertyAsLong(this.context.options(), "read.split.open-file-cost", tableValue);
    }

    private static Schema lazyColumnProjection(TableScanContext context, Schema schema) {
        Collection<String> selectedColumns = context.selectedColumns();
        if (selectedColumns != null) {
            HashSet<Integer> requiredFieldIds = Sets.newHashSet();
            requiredFieldIds.addAll(Binder.boundReferences(schema.asStruct(), Collections.singletonList(context.rowFilter()), context.caseSensitive()));
            Set<Integer> selectedIds = context.caseSensitive() ? TypeUtil.getProjectedIds(schema.select(selectedColumns)) : TypeUtil.getProjectedIds(schema.caseInsensitiveSelect(selectedColumns));
            requiredFieldIds.addAll(selectedIds);
            return TypeUtil.project(schema, requiredFieldIds);
        }
        if (context.projectedSchema() != null) {
            return context.projectedSchema();
        }
        return schema;
    }

    @Override
    public ThisT metricsReporter(MetricsReporter reporter) {
        return this.newRefinedScan(this.table, this.schema, this.context.reportWith(reporter));
    }

    static List<String> scanColumns(ManifestContent content) {
        switch (content) {
            case DATA: {
                return SCAN_COLUMNS;
            }
            case DELETES: {
                return DELETE_SCAN_COLUMNS;
            }
        }
        throw new UnsupportedOperationException("Cannot read unknown manifest type: " + String.valueOf((Object)content));
    }
}

