/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestEntry;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestReader;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionStatisticsFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.StatisticsFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Catalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifier;
import com.dataiku.dss.shadelib.org.apache.iceberg.common.DynClasses;
import com.dataiku.dss.shadelib.org.apache.iceberg.common.DynConstructors;
import com.dataiku.dss.shadelib.org.apache.iceberg.common.DynMethods;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.RuntimeIOException;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.ValidationException;
import com.dataiku.dss.shadelib.org.apache.iceberg.hadoop.Configurable;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.StorageCredential;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.SupportsBulkOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.SupportsStorageCredentials;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.LoggingMetricsReporter;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.MetricsReporter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Joiner;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.MapMaker;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.PropertyUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.Tasks;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ThreadPools;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogUtil.class);
    public static final String ICEBERG_CATALOG_TYPE = "type";
    public static final String ICEBERG_CATALOG_TYPE_HADOOP = "hadoop";
    public static final String ICEBERG_CATALOG_TYPE_HIVE = "hive";
    public static final String ICEBERG_CATALOG_TYPE_REST = "rest";
    public static final String ICEBERG_CATALOG_TYPE_GLUE = "glue";
    public static final String ICEBERG_CATALOG_TYPE_NESSIE = "nessie";
    public static final String ICEBERG_CATALOG_TYPE_JDBC = "jdbc";
    public static final String ICEBERG_CATALOG_TYPE_BIGQUERY = "bigquery";
    public static final String ICEBERG_CATALOG_HADOOP = "com.dataiku.dss.shadelib.org.apache.iceberg.hadoop.HadoopCatalog";
    public static final String ICEBERG_CATALOG_HIVE = "com.dataiku.dss.shadelib.org.apache.iceberg.hive.HiveCatalog";
    public static final String ICEBERG_CATALOG_REST = "com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTCatalog";
    public static final String ICEBERG_CATALOG_GLUE = "com.dataiku.dss.shadelibawssk2.org.apache.iceberg.aws.glue.GlueCatalog";
    public static final String ICEBERG_CATALOG_NESSIE = "com.dataiku.dss.shadelib.org.apache.iceberg.nessie.NessieCatalog";
    public static final String ICEBERG_CATALOG_JDBC = "com.dataiku.dss.shadelib.org.apache.iceberg.jdbc.JdbcCatalog";
    public static final String ICEBERG_CATALOG_BIGQUERY = "com.dataiku.dss.shadelibgcp.org.apache.iceberg.gcp.bigquery.BigQueryMetastoreCatalog";

    private CatalogUtil() {
    }

    public static void dropTableData(FileIO io, TableMetadata metadata) {
        HashSet<String> manifestListsToDelete = Sets.newHashSet();
        HashSet<ManifestFile> manifestsToDelete = Sets.newHashSet();
        for (Snapshot snapshot : metadata.snapshots()) {
            Iterables.addAll(manifestsToDelete, snapshot.allManifests(io));
            if (snapshot.manifestListLocation() == null) continue;
            manifestListsToDelete.add(snapshot.manifestListLocation());
        }
        LOG.info("Manifests to delete: {}", (Object)Joiner.on(", ").join(manifestsToDelete));
        boolean gcEnabled = PropertyUtil.propertyAsBoolean(metadata.properties(), "gc.enabled", true);
        if (gcEnabled) {
            CatalogUtil.deleteFiles(io, manifestsToDelete);
        }
        CatalogUtil.deleteFiles(io, Iterables.transform(manifestsToDelete, ManifestFile::path), "manifest", true);
        CatalogUtil.deleteFiles(io, manifestListsToDelete, "manifest list", true);
        CatalogUtil.deleteFiles(io, Iterables.transform(metadata.previousFiles(), TableMetadata.MetadataLogEntry::file), "previous metadata", true);
        CatalogUtil.deleteFiles(io, Iterables.transform(metadata.statisticsFiles(), StatisticsFile::path), "statistics", true);
        CatalogUtil.deleteFiles(io, Iterables.transform(metadata.partitionStatisticsFiles(), PartitionStatisticsFile::path), "partition statistics", true);
        CatalogUtil.deleteFile(io, metadata.metadataFileLocation(), "metadata");
    }

    public static void dropViewMetadata(FileIO io, ViewMetadata metadata) {
        boolean gcEnabled = PropertyUtil.propertyAsBoolean(metadata.properties(), "gc.enabled", true);
        if (gcEnabled) {
            CatalogUtil.deleteFile(io, metadata.metadataFileLocation(), "metadata");
        }
    }

    private static void deleteFiles(FileIO io, Set<ManifestFile> allManifests) {
        ConcurrentMap deletedFiles = new MapMaker().concurrencyLevel(ThreadPools.WORKER_THREAD_POOL_SIZE).weakKeys().makeMap();
        Tasks.foreach(allManifests).noRetry().suppressFailureWhenFinished().executeWith(ThreadPools.getWorkerPool()).onFailure((item, exc) -> LOG.warn("Failed to get deleted files: this may cause orphaned data files", (Throwable)exc)).run(manifest -> {
            try (ManifestReader<?> reader = ManifestFiles.open(manifest, io);){
                ArrayList<String> pathsToDelete = Lists.newArrayList();
                for (ManifestEntry manifestEntry : reader.entries()) {
                    String path = manifestEntry.file().location().intern();
                    Boolean alreadyDeleted = deletedFiles.putIfAbsent(path, true);
                    if (alreadyDeleted != null && alreadyDeleted.booleanValue()) continue;
                    pathsToDelete.add(path);
                }
                String type = reader.isDeleteManifestReader() ? "delete" : "data";
                CatalogUtil.deleteFiles(io, pathsToDelete, type, false);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to read manifest file: %s", manifest.path());
            }
        });
    }

    public static void deleteFiles(FileIO io, Iterable<String> files, String type, boolean concurrent) {
        if (io instanceof SupportsBulkOperations) {
            try {
                SupportsBulkOperations bulkIO = (SupportsBulkOperations)io;
                bulkIO.deleteFiles(files);
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to bulk delete {} files", (Object)type, (Object)e);
            }
        } else if (concurrent) {
            CatalogUtil.deleteFiles(io, files, type);
        } else {
            files.forEach(file -> CatalogUtil.deleteFile(io, file, type));
        }
    }

    private static void deleteFiles(FileIO io, Iterable<String> files, String type) {
        Tasks.foreach(files).executeWith(ThreadPools.getWorkerPool()).noRetry().suppressFailureWhenFinished().onFailure((file, exc) -> LOG.warn("Failed to delete {} file {}", new Object[]{type, file, exc})).run(io::deleteFile);
    }

    private static void deleteFile(FileIO io, String file, String type) {
        try {
            io.deleteFile(file);
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to delete {} file {}", new Object[]{type, file, e});
        }
    }

    public static Catalog loadCatalog(String impl, String catalogName, Map<String, String> properties, Object hadoopConf) {
        Catalog catalog;
        DynConstructors.Ctor ctor;
        Preconditions.checkNotNull(impl, "Cannot initialize custom Catalog, impl class name is null");
        try {
            ctor = DynConstructors.builder(Catalog.class).impl(impl, new Class[0]).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize Catalog implementation %s: %s", impl, e.getMessage()), e);
        }
        try {
            catalog = (Catalog)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize Catalog, %s does not implement Catalog.", impl), e);
        }
        CatalogUtil.configureHadoopConf(catalog, hadoopConf);
        catalog.initialize(catalogName, properties);
        return catalog;
    }

    public static Catalog buildIcebergCatalog(String name, Map<String, String> options, Object conf) {
        String catalogImpl = options.get("catalog-impl");
        if (catalogImpl == null) {
            String catalogType = PropertyUtil.propertyAsString(options, ICEBERG_CATALOG_TYPE, ICEBERG_CATALOG_TYPE_HIVE);
            switch (catalogType.toLowerCase(Locale.ENGLISH)) {
                case "hive": {
                    catalogImpl = ICEBERG_CATALOG_HIVE;
                    break;
                }
                case "hadoop": {
                    catalogImpl = ICEBERG_CATALOG_HADOOP;
                    break;
                }
                case "rest": {
                    catalogImpl = ICEBERG_CATALOG_REST;
                    break;
                }
                case "glue": {
                    catalogImpl = ICEBERG_CATALOG_GLUE;
                    break;
                }
                case "nessie": {
                    catalogImpl = ICEBERG_CATALOG_NESSIE;
                    break;
                }
                case "jdbc": {
                    catalogImpl = ICEBERG_CATALOG_JDBC;
                    break;
                }
                case "bigquery": {
                    catalogImpl = ICEBERG_CATALOG_BIGQUERY;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown catalog type: " + catalogType);
                }
            }
        } else {
            String catalogType = options.get(ICEBERG_CATALOG_TYPE);
            Preconditions.checkArgument(catalogType == null, "Cannot create catalog %s, both type and catalog-impl are set: type=%s, catalog-impl=%s", (Object)name, (Object)catalogType, (Object)catalogImpl);
        }
        return CatalogUtil.loadCatalog(catalogImpl, name, options, conf);
    }

    public static FileIO loadFileIO(String impl, Map<String, String> properties, Object hadoopConf) {
        return CatalogUtil.loadFileIO(impl, properties, hadoopConf, ImmutableList.of());
    }

    public static FileIO loadFileIO(String impl, Map<String, String> properties, Object hadoopConf, List<StorageCredential> storageCredentials) {
        FileIO fileIO;
        DynConstructors.Ctor ctor;
        LOG.info("Loading custom FileIO implementation: {}", (Object)impl);
        try {
            ctor = DynConstructors.builder(FileIO.class).loader(CatalogUtil.class.getClassLoader()).impl(impl, new Class[0]).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize FileIO implementation %s: %s", impl, e.getMessage()), e);
        }
        try {
            fileIO = (FileIO)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize FileIO, %s does not implement FileIO.", impl), e);
        }
        CatalogUtil.configureHadoopConf(fileIO, hadoopConf);
        if (fileIO instanceof SupportsStorageCredentials) {
            ((SupportsStorageCredentials)((Object)fileIO)).setCredentials(storageCredentials);
        }
        fileIO.initialize(properties);
        return fileIO;
    }

    public static void configureHadoopConf(Object maybeConfigurable, Object conf) {
        DynMethods.BoundMethod setConf;
        Class configurationClass;
        Class configurableInterface;
        Preconditions.checkArgument(maybeConfigurable != null, "Cannot configure: null Configurable");
        if (conf == null) {
            return;
        }
        if (maybeConfigurable instanceof Configurable) {
            ((Configurable)maybeConfigurable).setConf(conf);
            return;
        }
        ClassLoader maybeConfigurableLoader = maybeConfigurable.getClass().getClassLoader();
        try {
            configurableInterface = DynClasses.builder().loader(maybeConfigurableLoader).impl("org.apache.hadoop.conf.Configurable").buildChecked();
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (!configurableInterface.isInstance(maybeConfigurable)) {
            return;
        }
        try {
            configurationClass = DynClasses.builder().loader(maybeConfigurableLoader).impl("org.apache.hadoop.conf.Configuration").buildChecked();
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Failed to load Configuration after loading Configurable", e);
        }
        ValidationException.check(configurationClass.isInstance(conf), "%s is not an instance of Configuration from the classloader for %s", conf, maybeConfigurable);
        try {
            setConf = DynMethods.builder("setConf").impl(configurableInterface, configurationClass).buildChecked().bind(maybeConfigurable);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("Failed to load Configuration.setConf after loading Configurable", e);
        }
        setConf.invoke(conf);
    }

    public static MetricsReporter loadMetricsReporter(Map<String, String> properties) {
        MetricsReporter reporter;
        DynConstructors.Ctor ctor;
        String impl = properties.get("metrics-reporter-impl");
        if (impl == null) {
            return LoggingMetricsReporter.instance();
        }
        LOG.info("Loading custom MetricsReporter implementation: {}", (Object)impl);
        try {
            ctor = DynConstructors.builder(MetricsReporter.class).loader(CatalogUtil.class.getClassLoader()).impl(impl, new Class[0]).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize MetricsReporter, missing no-arg constructor: %s", impl), e);
        }
        try {
            reporter = (MetricsReporter)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize MetricsReporter, %s does not implement MetricsReporter.", impl), e);
        }
        reporter.initialize(properties);
        return reporter;
    }

    public static String fullTableName(String catalogName, TableIdentifier identifier) {
        StringBuilder sb = new StringBuilder();
        if (catalogName.contains("/") || catalogName.contains(":")) {
            sb.append(catalogName);
            if (!catalogName.endsWith("/")) {
                sb.append("/");
            }
        } else {
            sb.append(catalogName).append(".");
        }
        for (String level : identifier.namespace().levels()) {
            sb.append(level).append(".");
        }
        sb.append(identifier.name());
        return sb.toString();
    }

    public static void deleteRemovedMetadataFiles(FileIO io, TableMetadata base, TableMetadata metadata) {
        if (base == null) {
            return;
        }
        boolean deleteAfterCommit = metadata.propertyAsBoolean("write.metadata.delete-after-commit.enabled", false);
        if (deleteAfterCommit) {
            HashSet<TableMetadata.MetadataLogEntry> removedPreviousMetadataFiles = Sets.newHashSet(base.previousFiles());
            removedPreviousMetadataFiles.removeAll(metadata.previousFiles());
            if (io instanceof SupportsBulkOperations) {
                ((SupportsBulkOperations)io).deleteFiles(Iterables.transform(removedPreviousMetadataFiles, TableMetadata.MetadataLogEntry::file));
            } else {
                Tasks.foreach(removedPreviousMetadataFiles).noRetry().suppressFailureWhenFinished().onFailure((previousMetadataFile, exc) -> LOG.warn("Delete failed for previous metadata file: {}", previousMetadataFile, (Object)exc)).run(previousMetadataFile -> io.deleteFile(previousMetadataFile.file()));
            }
        }
    }
}

