/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.ScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.SplitScanTaskIterator;

class FixedSizeSplitScanTaskIterator<T extends ScanTask>
implements SplitScanTaskIterator<T> {
    private final T parentTask;
    private final long splitSize;
    private final SplitScanTaskIterator.SplitScanTaskCreator<T> splitTaskCreator;
    private long offset;
    private long remainingLength;

    FixedSizeSplitScanTaskIterator(T parentTask, long parentTaskLength, long splitSize, SplitScanTaskIterator.SplitScanTaskCreator<T> splitTaskCreator) {
        this.parentTask = parentTask;
        this.splitSize = splitSize;
        this.splitTaskCreator = splitTaskCreator;
        this.offset = 0L;
        this.remainingLength = parentTaskLength;
    }

    @Override
    public boolean hasNext() {
        return this.remainingLength > 0L;
    }

    @Override
    public T next() {
        long length = Math.min(this.splitSize, this.remainingLength);
        T splitTask = this.splitTaskCreator.create(this.parentTask, this.offset, length);
        this.offset += length;
        this.remainingLength -= length;
        return splitTask;
    }
}

