/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.ManifestFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.avro.AvroSchemaUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ByteBuffers;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificData;

public class GenericPartitionFieldSummary
implements ManifestFile.PartitionFieldSummary,
StructLike,
IndexedRecord,
SpecificData.SchemaConstructable,
Serializable {
    private static final Schema AVRO_SCHEMA = AvroSchemaUtil.convert(ManifestFile.PartitionFieldSummary.getType());
    private transient Schema avroSchema;
    private int[] fromProjectionPos;
    private boolean containsNull = false;
    private Boolean containsNaN = null;
    private byte[] lowerBound = null;
    private byte[] upperBound = null;

    public GenericPartitionFieldSummary(Schema avroSchema) {
        this.avroSchema = avroSchema;
        List<Types.NestedField> fields = AvroSchemaUtil.convert(avroSchema).asNestedType().asStructType().fields();
        List<Types.NestedField> allFields = ManifestFile.PartitionFieldSummary.getType().fields();
        this.fromProjectionPos = new int[fields.size()];
        for (int i = 0; i < this.fromProjectionPos.length; ++i) {
            boolean found = false;
            for (int j = 0; j < allFields.size(); ++j) {
                if (fields.get(i).fieldId() != allFields.get(j).fieldId()) continue;
                found = true;
                this.fromProjectionPos[i] = j;
            }
            if (found) continue;
            throw new IllegalArgumentException("Cannot find projected field: " + String.valueOf(fields.get(i)));
        }
    }

    public GenericPartitionFieldSummary(boolean containsNull, boolean containsNaN, ByteBuffer lowerBound, ByteBuffer upperBound) {
        this.avroSchema = AVRO_SCHEMA;
        this.containsNull = containsNull;
        this.containsNaN = containsNaN;
        this.lowerBound = ByteBuffers.toByteArray(lowerBound);
        this.upperBound = ByteBuffers.toByteArray(upperBound);
        this.fromProjectionPos = null;
    }

    @VisibleForTesting
    GenericPartitionFieldSummary(boolean containsNull, ByteBuffer lowerBound, ByteBuffer upperBound) {
        this.avroSchema = AVRO_SCHEMA;
        this.containsNull = containsNull;
        this.lowerBound = ByteBuffers.toByteArray(lowerBound);
        this.upperBound = ByteBuffers.toByteArray(upperBound);
        this.fromProjectionPos = null;
    }

    private GenericPartitionFieldSummary(GenericPartitionFieldSummary toCopy) {
        this.avroSchema = toCopy.avroSchema;
        this.containsNull = toCopy.containsNull;
        this.containsNaN = toCopy.containsNaN;
        this.lowerBound = toCopy.lowerBound == null ? null : Arrays.copyOf(toCopy.lowerBound, toCopy.lowerBound.length);
        this.upperBound = toCopy.upperBound == null ? null : Arrays.copyOf(toCopy.upperBound, toCopy.upperBound.length);
        this.fromProjectionPos = toCopy.fromProjectionPos;
    }

    GenericPartitionFieldSummary() {
    }

    @Override
    public boolean containsNull() {
        return this.containsNull;
    }

    @Override
    public Boolean containsNaN() {
        return this.containsNaN;
    }

    @Override
    public ByteBuffer lowerBound() {
        return this.lowerBound != null ? ByteBuffer.wrap(this.lowerBound) : null;
    }

    @Override
    public ByteBuffer upperBound() {
        return this.upperBound != null ? ByteBuffer.wrap(this.upperBound) : null;
    }

    @Override
    public int size() {
        return ManifestFile.PartitionFieldSummary.getType().fields().size();
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        return javaClass.cast(this.get(pos));
    }

    public Object get(int i) {
        int pos = i;
        if (this.fromProjectionPos != null) {
            pos = this.fromProjectionPos[i];
        }
        switch (pos) {
            case 0: {
                return this.containsNull;
            }
            case 1: {
                return this.containsNaN;
            }
            case 2: {
                return this.lowerBound();
            }
            case 3: {
                return this.upperBound();
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + pos);
    }

    @Override
    public <T> void set(int i, T value) {
        int pos = i;
        if (this.fromProjectionPos != null) {
            pos = this.fromProjectionPos[i];
        }
        switch (pos) {
            case 0: {
                this.containsNull = (Boolean)value;
                return;
            }
            case 1: {
                this.containsNaN = (Boolean)value;
                return;
            }
            case 2: {
                this.lowerBound = ByteBuffers.toByteArray((ByteBuffer)value);
                return;
            }
            case 3: {
                this.upperBound = ByteBuffers.toByteArray((ByteBuffer)value);
                return;
            }
        }
    }

    public void put(int i, Object v) {
        this.set(i, v);
    }

    @Override
    public ManifestFile.PartitionFieldSummary copy() {
        return new GenericPartitionFieldSummary(this);
    }

    public Schema getSchema() {
        return this.avroSchema;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("contains_null", this.containsNull).add("contains_nan", this.containsNaN).add("lower_bound", this.lowerBound).add("upper_bound", this.upperBound).toString();
    }
}

