/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionStatisticsFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.SnapshotRef;
import com.dataiku.dss.shadelib.org.apache.iceberg.SnapshotRefType;
import com.dataiku.dss.shadelib.org.apache.iceberg.SortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.StatisticsFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.UnboundPartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.UnboundSortOrder;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedKey;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewVersion;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public interface MetadataUpdate
extends Serializable {
    default public void applyTo(TableMetadata.Builder metadataBuilder) {
        throw new UnsupportedOperationException(String.format("Cannot apply update %s to a table", this.getClass().getSimpleName()));
    }

    default public void applyTo(ViewMetadata.Builder viewMetadataBuilder) {
        throw new UnsupportedOperationException(String.format("Cannot apply update %s to a view", this.getClass().getSimpleName()));
    }

    public static class RemoveEncryptionKey
    implements MetadataUpdate {
        private final String keyId;

        public RemoveEncryptionKey(String keyId) {
            this.keyId = keyId;
        }

        public String keyId() {
            return this.keyId;
        }

        @Override
        public void applyTo(TableMetadata.Builder builder) {
            builder.removeEncryptionKey(this.keyId);
        }
    }

    public static class AddEncryptionKey
    implements MetadataUpdate {
        private final EncryptedKey key;

        public AddEncryptionKey(EncryptedKey key) {
            this.key = key;
        }

        public EncryptedKey key() {
            return this.key;
        }

        @Override
        public void applyTo(TableMetadata.Builder builder) {
            builder.addEncryptionKey(this.key);
        }
    }

    public static class SetCurrentViewVersion
    implements MetadataUpdate {
        private final int versionId;

        public SetCurrentViewVersion(int versionId) {
            this.versionId = versionId;
        }

        public int versionId() {
            return this.versionId;
        }

        @Override
        public void applyTo(ViewMetadata.Builder viewMetadataBuilder) {
            viewMetadataBuilder.setCurrentVersionId(this.versionId);
        }
    }

    public static class AddViewVersion
    implements MetadataUpdate {
        private final ViewVersion viewVersion;

        public AddViewVersion(ViewVersion viewVersion) {
            this.viewVersion = viewVersion;
        }

        public ViewVersion viewVersion() {
            return this.viewVersion;
        }

        @Override
        public void applyTo(ViewMetadata.Builder viewMetadataBuilder) {
            viewMetadataBuilder.addVersion(this.viewVersion);
        }
    }

    public static class SetLocation
    implements MetadataUpdate {
        private final String location;

        public SetLocation(String location) {
            this.location = location;
        }

        public String location() {
            return this.location;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.setLocation(this.location);
        }

        @Override
        public void applyTo(ViewMetadata.Builder viewMetadataBuilder) {
            viewMetadataBuilder.setLocation(this.location);
        }
    }

    public static class RemoveProperties
    implements MetadataUpdate {
        private final Set<String> removed;

        public RemoveProperties(Set<String> removed) {
            this.removed = removed;
        }

        public Set<String> removed() {
            return this.removed;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.removeProperties(this.removed);
        }

        @Override
        public void applyTo(ViewMetadata.Builder viewMetadataBuilder) {
            viewMetadataBuilder.removeProperties(this.removed);
        }
    }

    public static class SetProperties
    implements MetadataUpdate {
        private final Map<String, String> updated;

        public SetProperties(Map<String, String> updated) {
            this.updated = updated;
        }

        public Map<String, String> updated() {
            return this.updated;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.setProperties(this.updated);
        }

        @Override
        public void applyTo(ViewMetadata.Builder viewMetadataBuilder) {
            viewMetadataBuilder.setProperties(this.updated);
        }
    }

    public static class SetSnapshotRef
    implements MetadataUpdate {
        private final String refName;
        private final Long snapshotId;
        private final SnapshotRefType type;
        private final Integer minSnapshotsToKeep;
        private final Long maxSnapshotAgeMs;
        private final Long maxRefAgeMs;

        public SetSnapshotRef(String refName, Long snapshotId, SnapshotRefType type, Integer minSnapshotsToKeep, Long maxSnapshotAgeMs, Long maxRefAgeMs) {
            this.refName = refName;
            this.snapshotId = snapshotId;
            this.type = type;
            this.minSnapshotsToKeep = minSnapshotsToKeep;
            this.maxSnapshotAgeMs = maxSnapshotAgeMs;
            this.maxRefAgeMs = maxRefAgeMs;
        }

        public String name() {
            return this.refName;
        }

        public String type() {
            return this.type.name().toLowerCase(Locale.ROOT);
        }

        public long snapshotId() {
            return this.snapshotId;
        }

        public Integer minSnapshotsToKeep() {
            return this.minSnapshotsToKeep;
        }

        public Long maxSnapshotAgeMs() {
            return this.maxSnapshotAgeMs;
        }

        public Long maxRefAgeMs() {
            return this.maxRefAgeMs;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            SnapshotRef ref = SnapshotRef.builderFor(this.snapshotId, this.type).minSnapshotsToKeep(this.minSnapshotsToKeep).maxSnapshotAgeMs(this.maxSnapshotAgeMs).maxRefAgeMs(this.maxRefAgeMs).build();
            metadataBuilder.setRef(this.refName, ref);
        }
    }

    public static class RemoveSnapshotRef
    implements MetadataUpdate {
        private final String refName;

        public RemoveSnapshotRef(String refName) {
            this.refName = refName;
        }

        public String name() {
            return this.refName;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.removeRef(this.refName);
        }
    }

    public static class RemoveSnapshots
    implements MetadataUpdate {
        private final Set<Long> snapshotIds;

        public RemoveSnapshots(long snapshotId) {
            this.snapshotIds = ImmutableSet.of(Long.valueOf(snapshotId));
        }

        public RemoveSnapshots(Set<Long> snapshotIds) {
            this.snapshotIds = snapshotIds;
        }

        public Set<Long> snapshotIds() {
            return this.snapshotIds;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.removeSnapshots(this.snapshotIds);
        }
    }

    public static class AddSnapshot
    implements MetadataUpdate {
        private final Snapshot snapshot;

        public AddSnapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.addSnapshot(this.snapshot);
        }
    }

    public static class RemovePartitionStatistics
    implements MetadataUpdate {
        private final long snapshotId;

        public RemovePartitionStatistics(long snapshotId) {
            this.snapshotId = snapshotId;
        }

        public long snapshotId() {
            return this.snapshotId;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.removePartitionStatistics(this.snapshotId);
        }
    }

    public static class SetPartitionStatistics
    implements MetadataUpdate {
        private final PartitionStatisticsFile partitionStatisticsFile;

        public SetPartitionStatistics(PartitionStatisticsFile partitionStatisticsFile) {
            this.partitionStatisticsFile = partitionStatisticsFile;
        }

        public long snapshotId() {
            return this.partitionStatisticsFile.snapshotId();
        }

        public PartitionStatisticsFile partitionStatisticsFile() {
            return this.partitionStatisticsFile;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.setPartitionStatistics(this.partitionStatisticsFile);
        }
    }

    public static class RemoveStatistics
    implements MetadataUpdate {
        private final long snapshotId;

        public RemoveStatistics(long snapshotId) {
            this.snapshotId = snapshotId;
        }

        public long snapshotId() {
            return this.snapshotId;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.removeStatistics(this.snapshotId);
        }
    }

    public static class SetStatistics
    implements MetadataUpdate {
        private final StatisticsFile statisticsFile;

        public SetStatistics(StatisticsFile statisticsFile) {
            this.statisticsFile = statisticsFile;
        }

        public long snapshotId() {
            return this.statisticsFile.snapshotId();
        }

        public StatisticsFile statisticsFile() {
            return this.statisticsFile;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.setStatistics(this.statisticsFile);
        }
    }

    public static class SetDefaultSortOrder
    implements MetadataUpdate {
        private final int sortOrderId;

        public SetDefaultSortOrder(int sortOrderId) {
            this.sortOrderId = sortOrderId;
        }

        public int sortOrderId() {
            return this.sortOrderId;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.setDefaultSortOrder(this.sortOrderId);
        }
    }

    public static class AddSortOrder
    implements MetadataUpdate {
        private final UnboundSortOrder sortOrder;

        public AddSortOrder(SortOrder sortOrder) {
            this(sortOrder.toUnbound());
        }

        public AddSortOrder(UnboundSortOrder sortOrder) {
            this.sortOrder = sortOrder;
        }

        public UnboundSortOrder sortOrder() {
            return this.sortOrder;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.addSortOrder(this.sortOrder);
        }
    }

    public static class RemoveSchemas
    implements MetadataUpdate {
        private final Set<Integer> schemaIds;

        public RemoveSchemas(Set<Integer> schemaIds) {
            this.schemaIds = schemaIds;
        }

        public Set<Integer> schemaIds() {
            return this.schemaIds;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.removeSchemas(this.schemaIds);
        }
    }

    public static class RemovePartitionSpecs
    implements MetadataUpdate {
        private final Set<Integer> specIds;

        public RemovePartitionSpecs(Set<Integer> specIds) {
            this.specIds = specIds;
        }

        public Set<Integer> specIds() {
            return this.specIds;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.removeSpecs(this.specIds);
        }
    }

    public static class SetDefaultPartitionSpec
    implements MetadataUpdate {
        private final int specId;

        public SetDefaultPartitionSpec(int specId) {
            this.specId = specId;
        }

        public int specId() {
            return this.specId;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.setDefaultPartitionSpec(this.specId);
        }
    }

    public static class AddPartitionSpec
    implements MetadataUpdate {
        private final UnboundPartitionSpec spec;

        public AddPartitionSpec(PartitionSpec spec) {
            this(spec.toUnbound());
        }

        public AddPartitionSpec(UnboundPartitionSpec spec) {
            this.spec = spec;
        }

        public UnboundPartitionSpec spec() {
            return this.spec;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.addPartitionSpec(this.spec);
        }
    }

    public static class SetCurrentSchema
    implements MetadataUpdate {
        private final int schemaId;

        public SetCurrentSchema(int schemaId) {
            this.schemaId = schemaId;
        }

        public int schemaId() {
            return this.schemaId;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.setCurrentSchema(this.schemaId);
        }
    }

    public static class AddSchema
    implements MetadataUpdate {
        private final Schema schema;

        public AddSchema(Schema schema) {
            this.schema = schema;
        }

        public Schema schema() {
            return this.schema;
        }

        public int lastColumnId() {
            return this.schema.highestFieldId();
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.addSchema(this.schema);
        }

        @Override
        public void applyTo(ViewMetadata.Builder viewMetadataBuilder) {
            viewMetadataBuilder.addSchema(this.schema);
        }
    }

    public static class UpgradeFormatVersion
    implements MetadataUpdate {
        private final int formatVersion;

        public UpgradeFormatVersion(int formatVersion) {
            this.formatVersion = formatVersion;
        }

        public int formatVersion() {
            return this.formatVersion;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.upgradeFormatVersion(this.formatVersion);
        }

        @Override
        public void applyTo(ViewMetadata.Builder viewMetadataBuilder) {
            viewMetadataBuilder.upgradeFormatVersion(this.formatVersion);
        }
    }

    public static class AssignUUID
    implements MetadataUpdate {
        private final String uuid;

        public AssignUUID(String uuid) {
            this.uuid = uuid;
        }

        public String uuid() {
            return this.uuid;
        }

        @Override
        public void applyTo(TableMetadata.Builder metadataBuilder) {
            metadataBuilder.assignUUID(this.uuid);
        }

        @Override
        public void applyTo(ViewMetadata.Builder metadataBuilder) {
            metadataBuilder.assignUUID(this.uuid);
        }
    }
}

