/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg;

import com.dataiku.dss.shadelib.javax.annotation.Nullable;
import com.dataiku.dss.shadelib.org.apache.iceberg.ImmutableTableScanContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expressions;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.LoggingMetricsReporter;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.MetricsReporter;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.MetricsReporters;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ThreadPools;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.immutables.value.Value;

@Value.Immutable
abstract class TableScanContext {
    TableScanContext() {
    }

    @Nullable
    public abstract Long snapshotId();

    @Value.Default
    public Expression rowFilter() {
        return Expressions.alwaysTrue();
    }

    @Value.Default
    public boolean ignoreResiduals() {
        return false;
    }

    @Value.Default
    public boolean caseSensitive() {
        return true;
    }

    @Value.Default
    public boolean returnColumnStats() {
        return false;
    }

    @Nullable
    public abstract Set<Integer> columnsToKeepStats();

    @Nullable
    public abstract Collection<String> selectedColumns();

    @Nullable
    public abstract Schema projectedSchema();

    @Value.Default
    public Map<String, String> options() {
        return ImmutableMap.of();
    }

    @Nullable
    public abstract Long fromSnapshotId();

    @Value.Default
    public boolean fromSnapshotInclusive() {
        return false;
    }

    @Nullable
    public abstract Long toSnapshotId();

    @Value.Default
    public ExecutorService planExecutor() {
        return ThreadPools.getWorkerPool();
    }

    @Value.Derived
    boolean planWithCustomizedExecutor() {
        return !this.planExecutor().equals(ThreadPools.getWorkerPool());
    }

    @Value.Default
    public MetricsReporter metricsReporter() {
        return LoggingMetricsReporter.instance();
    }

    @Nullable
    public abstract String branch();

    TableScanContext useSnapshotId(Long scanSnapshotId) {
        return ImmutableTableScanContext.builder().from(this).snapshotId(scanSnapshotId).build();
    }

    TableScanContext filterRows(Expression filter) {
        return ImmutableTableScanContext.builder().from(this).rowFilter(filter).build();
    }

    TableScanContext ignoreResiduals(boolean shouldIgnoreResiduals) {
        return ImmutableTableScanContext.builder().from(this).ignoreResiduals(shouldIgnoreResiduals).build();
    }

    TableScanContext setCaseSensitive(boolean isCaseSensitive) {
        return ImmutableTableScanContext.builder().from(this).caseSensitive(isCaseSensitive).build();
    }

    TableScanContext shouldReturnColumnStats(boolean returnColumnStats) {
        return ImmutableTableScanContext.builder().from(this).returnColumnStats(returnColumnStats).build();
    }

    TableScanContext columnsToKeepStats(Set<Integer> columnsToKeepStats) {
        Preconditions.checkState(this.returnColumnStats(), "Cannot select columns to keep stats when column stats are not returned");
        return ImmutableTableScanContext.builder().from(this).columnsToKeepStats(columnsToKeepStats).build();
    }

    TableScanContext selectColumns(Collection<String> columns) {
        Preconditions.checkState(this.projectedSchema() == null, "Cannot select columns when projection schema is set");
        return ImmutableTableScanContext.builder().from(this).selectedColumns(columns).build();
    }

    TableScanContext project(Schema schema) {
        Preconditions.checkState(this.selectedColumns() == null, "Cannot set projection schema when columns are selected");
        return ImmutableTableScanContext.builder().from(this).projectedSchema(schema).build();
    }

    TableScanContext withOption(String property, String value) {
        return ImmutableTableScanContext.builder().from(this).putOptions(property, value).build();
    }

    TableScanContext fromSnapshotIdExclusive(long id) {
        return ImmutableTableScanContext.builder().from(this).fromSnapshotId(id).fromSnapshotInclusive(false).build();
    }

    TableScanContext fromSnapshotIdInclusive(long id) {
        return ImmutableTableScanContext.builder().from(this).fromSnapshotId(id).fromSnapshotInclusive(true).build();
    }

    TableScanContext toSnapshotId(long id) {
        return ImmutableTableScanContext.builder().from(this).toSnapshotId(id).build();
    }

    TableScanContext planWith(ExecutorService executor) {
        return ImmutableTableScanContext.builder().from(this).planExecutor(executor).build();
    }

    TableScanContext reportWith(MetricsReporter reporter) {
        return ImmutableTableScanContext.builder().from(this).metricsReporter(this.metricsReporter() instanceof LoggingMetricsReporter ? reporter : MetricsReporters.combine(this.metricsReporter(), reporter)).build();
    }

    TableScanContext useBranch(String ref) {
        return ImmutableTableScanContext.builder().from(this).branch(ref).build();
    }

    public static TableScanContext empty() {
        return ImmutableTableScanContext.builder().build();
    }
}

