/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.avro;

import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.avro.AvroSchemaUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.avro.LogicalMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.avro.Schema;

public abstract class AvroSchemaWithTypeVisitor<T> {
    private final Deque<String> recordLevels = Lists.newLinkedList();

    public static <T> T visit(Schema iSchema, org.apache.avro.Schema schema, AvroSchemaWithTypeVisitor<T> visitor) {
        return AvroSchemaWithTypeVisitor.visit(iSchema.asStruct(), schema, visitor);
    }

    public static <T> T visit(Type iType, org.apache.avro.Schema schema, AvroSchemaWithTypeVisitor<T> visitor) {
        switch (schema.getType()) {
            case RECORD: {
                return AvroSchemaWithTypeVisitor.visitRecord(iType != null ? iType.asStructType() : null, schema, visitor);
            }
            case UNION: {
                return AvroSchemaWithTypeVisitor.visitUnion(iType, schema, visitor);
            }
            case ARRAY: {
                return AvroSchemaWithTypeVisitor.visitArray(iType, schema, visitor);
            }
            case MAP: {
                Types.MapType map = iType != null ? iType.asMapType() : null;
                return visitor.map(map, schema, AvroSchemaWithTypeVisitor.visit(map != null ? map.valueType() : null, schema.getValueType(), visitor));
            }
        }
        return visitor.primitive(iType != null ? iType.asPrimitiveType() : null, schema);
    }

    private static <T> T visitRecord(Types.StructType struct, org.apache.avro.Schema record, AvroSchemaWithTypeVisitor<T> visitor) {
        String name = record.getFullName();
        Preconditions.checkState(!visitor.recordLevels.contains(name), "Cannot process recursive Avro record %s", (Object)name);
        visitor.recordLevels.push(name);
        List fields = record.getFields();
        ArrayList<String> names = Lists.newArrayListWithExpectedSize(fields.size());
        ArrayList<T> results = Lists.newArrayListWithExpectedSize(fields.size());
        for (Schema.Field field : fields) {
            int fieldId = AvroSchemaUtil.getFieldId(field);
            Types.NestedField iField = struct != null ? struct.field(fieldId) : null;
            names.add(field.name());
            results.add(AvroSchemaWithTypeVisitor.visit(iField != null ? iField.type() : null, field.schema(), visitor));
        }
        visitor.recordLevels.pop();
        return visitor.record(struct, record, names, results);
    }

    private static <T> T visitUnion(Type type, org.apache.avro.Schema union, AvroSchemaWithTypeVisitor<T> visitor) {
        List types = union.getTypes();
        ArrayList<T> options = Lists.newArrayListWithExpectedSize(types.size());
        for (org.apache.avro.Schema branch : types) {
            if (branch.getType() == Schema.Type.NULL) {
                options.add(AvroSchemaWithTypeVisitor.visit((Type)null, branch, visitor));
                continue;
            }
            options.add(AvroSchemaWithTypeVisitor.visit(type, branch, visitor));
        }
        return visitor.union(type, union, options);
    }

    private static <T> T visitArray(Type type, org.apache.avro.Schema array, AvroSchemaWithTypeVisitor<T> visitor) {
        if (array.getLogicalType() instanceof LogicalMap || type != null && type.isMapType()) {
            Preconditions.checkState(AvroSchemaUtil.isKeyValueSchema(array.getElementType()), "Cannot visit invalid logical map type: %s", (Object)array);
            Types.MapType map = type != null ? type.asMapType() : null;
            List keyValueFields = array.getElementType().getFields();
            return visitor.map(map, array, AvroSchemaWithTypeVisitor.visit(map != null ? map.keyType() : null, ((Schema.Field)keyValueFields.get(0)).schema(), visitor), AvroSchemaWithTypeVisitor.visit(map != null ? map.valueType() : null, ((Schema.Field)keyValueFields.get(1)).schema(), visitor));
        }
        Types.ListType list = type != null ? type.asListType() : null;
        return visitor.array(list, array, AvroSchemaWithTypeVisitor.visit(list != null ? list.elementType() : null, array.getElementType(), visitor));
    }

    public T record(Types.StructType iStruct, org.apache.avro.Schema record, List<String> names, List<T> fields) {
        return null;
    }

    public T union(Type iType, org.apache.avro.Schema union, List<T> options) {
        return null;
    }

    public T array(Types.ListType iList, org.apache.avro.Schema array, T element) {
        return null;
    }

    public T map(Types.MapType iMap, org.apache.avro.Schema map, T key, T value) {
        return null;
    }

    public T map(Types.MapType iMap, org.apache.avro.Schema map, T value) {
        return null;
    }

    public T primitive(Type.PrimitiveType iPrimitive, org.apache.avro.Schema primitive) {
        return null;
    }
}

