/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.avro;

import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.avro.AvroSchemaUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.avro.AvroSchemaVisitor;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.Schema;

public class RemoveIds
extends AvroSchemaVisitor<org.apache.avro.Schema> {
    @Override
    public org.apache.avro.Schema record(org.apache.avro.Schema record, List<String> names, List<org.apache.avro.Schema> types) {
        List fields = record.getFields();
        int length = fields.size();
        ArrayList<Schema.Field> newFields = Lists.newArrayListWithExpectedSize(length);
        for (int i = 0; i < length; ++i) {
            newFields.add(RemoveIds.copyField((Schema.Field)fields.get(i), types.get(i)));
        }
        return AvroSchemaUtil.copyRecord(record, newFields, null);
    }

    @Override
    public org.apache.avro.Schema map(org.apache.avro.Schema map, org.apache.avro.Schema valueType) {
        org.apache.avro.Schema result = org.apache.avro.Schema.createMap((org.apache.avro.Schema)valueType);
        for (Map.Entry prop : map.getObjectProps().entrySet()) {
            String key = (String)prop.getKey();
            if (key.equals("key-id") || key.equals("value-id")) continue;
            result.addProp(key, prop.getValue());
        }
        return result;
    }

    @Override
    public org.apache.avro.Schema array(org.apache.avro.Schema array, org.apache.avro.Schema element) {
        org.apache.avro.Schema result = org.apache.avro.Schema.createArray((org.apache.avro.Schema)element);
        for (Map.Entry prop : array.getObjectProps().entrySet()) {
            String key = (String)prop.getKey();
            if (key.equals("element-id")) continue;
            result.addProp(key, prop.getValue());
        }
        return result;
    }

    @Override
    public org.apache.avro.Schema variant(org.apache.avro.Schema variant, org.apache.avro.Schema metadata, org.apache.avro.Schema value) {
        return variant;
    }

    @Override
    public org.apache.avro.Schema primitive(org.apache.avro.Schema primitive) {
        return org.apache.avro.Schema.create((Schema.Type)primitive.getType());
    }

    @Override
    public org.apache.avro.Schema union(org.apache.avro.Schema union, List<org.apache.avro.Schema> options) {
        return org.apache.avro.Schema.createUnion(options);
    }

    private static Schema.Field copyField(Schema.Field field, org.apache.avro.Schema newSchema) {
        Schema.Field copy = new Schema.Field(field.name(), newSchema, field.doc(), field.defaultVal(), field.order());
        for (Map.Entry prop : field.getObjectProps().entrySet()) {
            String key = (String)prop.getKey();
            if (Objects.equals(key, "field-id")) continue;
            copy.addProp(key, prop.getValue());
        }
        return copy;
    }

    static org.apache.avro.Schema removeIds(Schema schema) {
        return AvroSchemaVisitor.visit(AvroSchemaUtil.convert(schema.asStruct(), "table"), new RemoveIds());
    }

    public static org.apache.avro.Schema removeIds(org.apache.avro.Schema schema) {
        return AvroSchemaVisitor.visit(schema, new RemoveIds());
    }
}

