/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.catalog;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifier;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import java.io.IOException;
import java.util.List;

public class TableIdentifierParser {
    private static final String NAMESPACE = "namespace";
    private static final String NAME = "name";

    private TableIdentifierParser() {
    }

    public static String toJson(TableIdentifier identifier) {
        return TableIdentifierParser.toJson(identifier, false);
    }

    public static String toJson(TableIdentifier identifier, boolean pretty) {
        return JsonUtil.generate(gen -> TableIdentifierParser.toJson(identifier, gen), pretty);
    }

    public static void toJson(TableIdentifier identifier, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName(NAMESPACE);
        generator.writeArray(identifier.namespace().levels(), 0, identifier.namespace().length());
        generator.writeStringField(NAME, identifier.name());
        generator.writeEndObject();
    }

    public static TableIdentifier fromJson(String json) {
        Preconditions.checkArgument(json != null, "Cannot parse table identifier from invalid JSON: null");
        Preconditions.checkArgument(!json.isEmpty(), "Cannot parse table identifier from invalid JSON: ''");
        return JsonUtil.parse(json, TableIdentifierParser::fromJson);
    }

    public static TableIdentifier fromJson(JsonNode node) {
        Preconditions.checkArgument(node != null && !node.isNull() && node.isObject(), "Cannot parse missing or non-object table identifier: %s", (Object)node);
        List<String> levels = JsonUtil.getStringListOrNull(NAMESPACE, node);
        String tableName = JsonUtil.getString(NAME, node);
        Namespace namespace = levels == null ? Namespace.empty() : Namespace.of(levels.toArray(new String[0]));
        return TableIdentifier.of(namespace, tableName);
    }
}

