/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.data;

import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.DateTimeUtil;
import org.apache.avro.generic.GenericData;

public class IdentityPartitionConverters {
    private IdentityPartitionConverters() {
    }

    public static Object convertConstant(Type type, Object value) {
        if (value == null) {
            return null;
        }
        switch (type.typeId()) {
            case STRING: {
                return value.toString();
            }
            case TIME: {
                return DateTimeUtil.timeFromMicros((Long)value);
            }
            case DATE: {
                return DateTimeUtil.dateFromDays((Integer)value);
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    return DateTimeUtil.timestamptzFromMicros((Long)value);
                }
                return DateTimeUtil.timestampFromMicros((Long)value);
            }
            case FIXED: {
                if (value instanceof GenericData.Fixed) {
                    return ((GenericData.Fixed)value).bytes();
                }
                return value;
            }
        }
        return value;
    }
}

