/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.data.parquet;

import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.GenericDataUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.Record;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.parquet.BaseParquetReaders;
import com.dataiku.dss.shadelib.org.apache.iceberg.parquet.ParquetValueReader;
import com.dataiku.dss.shadelib.org.apache.iceberg.parquet.ParquetValueReaders;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.dataiku.dss.shadelib.org.apache.parquet.column.ColumnDescriptor;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.LogicalTypeAnnotation;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.MessageType;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.PrimitiveType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GenericParquetReaders
extends BaseParquetReaders<Record> {
    private static final GenericParquetReaders INSTANCE = new GenericParquetReaders();
    private static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    private GenericParquetReaders() {
    }

    public static ParquetValueReader<Record> buildReader(Schema expectedSchema, MessageType fileSchema) {
        return INSTANCE.createReader(expectedSchema, fileSchema);
    }

    public static ParquetValueReader<Record> buildReader(Schema expectedSchema, MessageType fileSchema, Map<Integer, ?> idToConstant) {
        return INSTANCE.createReader(expectedSchema, fileSchema, idToConstant);
    }

    @Override
    protected ParquetValueReader<Record> createStructReader(List<ParquetValueReader<?>> fieldReaders, Types.StructType structType) {
        return ParquetValueReaders.recordReader(fieldReaders, structType);
    }

    @Override
    protected ParquetValueReader<?> fixedReader(ColumnDescriptor desc) {
        return new FixedReader(desc);
    }

    @Override
    protected ParquetValueReader<?> dateReader(ColumnDescriptor desc) {
        return new DateReader(desc);
    }

    @Override
    protected ParquetValueReader<?> timeReader(ColumnDescriptor desc) {
        LogicalTypeAnnotation time = desc.getPrimitiveType().getLogicalTypeAnnotation();
        Preconditions.checkArgument(time instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation, "Invalid time logical type: " + String.valueOf(time));
        LogicalTypeAnnotation.TimeUnit unit = ((LogicalTypeAnnotation.TimeLogicalTypeAnnotation)time).getUnit();
        switch (unit) {
            case MICROS: {
                return new TimeReader(desc);
            }
            case MILLIS: {
                return new TimeMillisReader(desc);
            }
        }
        throw new UnsupportedOperationException("Unsupported unit for time: " + String.valueOf((Object)unit));
    }

    @Override
    protected ParquetValueReader<?> timestampReader(ColumnDescriptor desc, boolean isAdjustedToUTC) {
        if (desc.getPrimitiveType().getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT96) {
            return new TimestampInt96Reader(desc);
        }
        LogicalTypeAnnotation timestamp = desc.getPrimitiveType().getLogicalTypeAnnotation();
        Preconditions.checkArgument(timestamp instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation, "Invalid timestamp logical type: " + String.valueOf(timestamp));
        LogicalTypeAnnotation.TimeUnit unit = ((LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)timestamp).getUnit();
        switch (unit) {
            case NANOS: {
                return isAdjustedToUTC ? new TimestamptzReader(desc, ChronoUnit.NANOS) : new TimestampReader(desc, ChronoUnit.NANOS);
            }
            case MICROS: {
                return isAdjustedToUTC ? new TimestamptzReader(desc, ChronoUnit.MICROS) : new TimestampReader(desc, ChronoUnit.MICROS);
            }
            case MILLIS: {
                return isAdjustedToUTC ? new TimestamptzMillisReader(desc) : new TimestampMillisReader(desc);
            }
        }
        throw new UnsupportedOperationException("Unsupported unit for timestamp: " + String.valueOf((Object)unit));
    }

    @Override
    protected Object convertConstant(Type type, Object value) {
        return GenericDataUtil.internalToGeneric(type, value);
    }

    private static class FixedReader
    extends ParquetValueReaders.PrimitiveReader<byte[]> {
        FixedReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public byte[] read(byte[] reuse) {
            if (reuse != null) {
                this.column.nextBinary().toByteBuffer().duplicate().get(reuse);
                return reuse;
            }
            return this.column.nextBinary().getBytes();
        }
    }

    private static class DateReader
    extends ParquetValueReaders.PrimitiveReader<LocalDate> {
        DateReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public LocalDate read(LocalDate reuse) {
            return EPOCH_DAY.plusDays(this.column.nextInteger());
        }
    }

    private static class TimeReader
    extends ParquetValueReaders.PrimitiveReader<LocalTime> {
        TimeReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public LocalTime read(LocalTime reuse) {
            return LocalTime.ofNanoOfDay(this.column.nextLong() * 1000L);
        }
    }

    private static class TimeMillisReader
    extends ParquetValueReaders.PrimitiveReader<LocalTime> {
        TimeMillisReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public LocalTime read(LocalTime reuse) {
            return LocalTime.ofNanoOfDay((long)this.column.nextInteger() * 1000000L);
        }
    }

    private static class TimestampInt96Reader
    extends ParquetValueReaders.PrimitiveReader<OffsetDateTime> {
        private static final long UNIX_EPOCH_JULIAN = 2440588L;

        TimestampInt96Reader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public OffsetDateTime read(OffsetDateTime reuse) {
            ByteBuffer byteBuffer = this.column.nextBinary().toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
            long timeOfDayNanos = byteBuffer.getLong();
            int julianDay = byteBuffer.getInt();
            return Instant.ofEpochMilli(TimeUnit.DAYS.toMillis((long)julianDay - 2440588L)).plusNanos(timeOfDayNanos).atOffset(ZoneOffset.UTC);
        }
    }

    private static class TimestamptzReader
    extends ParquetValueReaders.PrimitiveReader<OffsetDateTime> {
        private final ChronoUnit unit;

        TimestamptzReader(ColumnDescriptor desc, ChronoUnit unit) {
            super(desc);
            this.unit = unit;
        }

        @Override
        public OffsetDateTime read(OffsetDateTime reuse) {
            return EPOCH.plus(this.column.nextLong(), this.unit);
        }
    }

    private static class TimestampReader
    extends ParquetValueReaders.PrimitiveReader<LocalDateTime> {
        private final ChronoUnit unit;

        TimestampReader(ColumnDescriptor desc, ChronoUnit unit) {
            super(desc);
            this.unit = unit;
        }

        @Override
        public LocalDateTime read(LocalDateTime reuse) {
            return EPOCH.plus(this.column.nextLong(), this.unit).toLocalDateTime();
        }
    }

    private static class TimestamptzMillisReader
    extends ParquetValueReaders.PrimitiveReader<OffsetDateTime> {
        TimestamptzMillisReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public OffsetDateTime read(OffsetDateTime reuse) {
            return EPOCH.plus(this.column.nextLong() * 1000L, ChronoUnit.MICROS);
        }
    }

    private static class TimestampMillisReader
    extends ParquetValueReaders.PrimitiveReader<LocalDateTime> {
        TimestampMillisReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public LocalDateTime read(LocalDateTime reuse) {
            return EPOCH.plus(this.column.nextLong() * 1000L, ChronoUnit.MICROS).toLocalDateTime();
        }
    }
}

