/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.deletes;

import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileFormat;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.IcebergBuild;
import com.dataiku.dss.shadelib.org.apache.iceberg.MetadataColumns;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.BitmapPositionDeleteIndex;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.DVFileWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.deletes.PositionDeleteIndex;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedOutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DeleteWriteResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFileFactory;
import com.dataiku.dss.shadelib.org.apache.iceberg.puffin.Blob;
import com.dataiku.dss.shadelib.org.apache.iceberg.puffin.BlobMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.puffin.Puffin;
import com.dataiku.dss.shadelib.org.apache.iceberg.puffin.PuffinWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.CharSequenceSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ContentFileUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.StructLikeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;

public class BaseDVFileWriter
implements DVFileWriter {
    private static final String REFERENCED_DATA_FILE_KEY = "referenced-data-file";
    private static final String CARDINALITY_KEY = "cardinality";
    private final OutputFileFactory fileFactory;
    private final Function<String, PositionDeleteIndex> loadPreviousDeletes;
    private final Map<String, Deletes> deletesByPath = Maps.newHashMap();
    private final Map<String, BlobMetadata> blobsByPath = Maps.newHashMap();
    private DeleteWriteResult result = null;

    public BaseDVFileWriter(OutputFileFactory fileFactory, Function<String, PositionDeleteIndex> loadPreviousDeletes) {
        this.fileFactory = fileFactory;
        this.loadPreviousDeletes = loadPreviousDeletes;
    }

    @Override
    public void delete(String path, long pos, PartitionSpec spec, StructLike partition) {
        Deletes deletes = this.deletesByPath.computeIfAbsent(path, key -> new Deletes(path, spec, partition));
        PositionDeleteIndex positions = deletes.positions();
        positions.delete(pos);
    }

    @Override
    public DeleteWriteResult result() {
        Preconditions.checkState(this.result != null, "Cannot get result from unclosed writer");
        return this.result;
    }

    @Override
    public void close() throws IOException {
        if (this.result == null) {
            PuffinWriter writer;
            ArrayList<DeleteFile> dvs = Lists.newArrayList();
            CharSequenceSet referencedDataFiles = CharSequenceSet.empty();
            ArrayList<DeleteFile> rewrittenDeleteFiles = Lists.newArrayList();
            if (this.deletesByPath.isEmpty()) {
                this.result = new DeleteWriteResult(dvs, referencedDataFiles, rewrittenDeleteFiles);
                return;
            }
            try (PuffinWriter closeableWriter = writer = this.newWriter();){
                for (Deletes deletes : this.deletesByPath.values()) {
                    String path = deletes.path();
                    PositionDeleteIndex positions = deletes.positions();
                    PositionDeleteIndex previousPositions = this.loadPreviousDeletes.apply(path);
                    if (previousPositions != null) {
                        positions.merge(previousPositions);
                        for (DeleteFile previousDeleteFile : previousPositions.deleteFiles()) {
                            if (!ContentFileUtil.isFileScoped(previousDeleteFile)) continue;
                            rewrittenDeleteFiles.add(previousDeleteFile);
                        }
                    }
                    this.write(closeableWriter, deletes);
                    referencedDataFiles.add(path);
                }
            }
            String puffinPath = writer.location();
            long puffinFileSize = writer.fileSize();
            for (String path : this.deletesByPath.keySet()) {
                DeleteFile dv = this.createDV(puffinPath, puffinFileSize, path);
                dvs.add(dv);
            }
            this.result = new DeleteWriteResult(dvs, referencedDataFiles, rewrittenDeleteFiles);
        }
    }

    private DeleteFile createDV(String path, long size, String referencedDataFile) {
        Deletes deletes = this.deletesByPath.get(referencedDataFile);
        BlobMetadata blobMetadata = this.blobsByPath.get(referencedDataFile);
        return FileMetadata.deleteFileBuilder(deletes.spec()).ofPositionDeletes().withFormat(FileFormat.PUFFIN).withPath(path).withPartition(deletes.partition()).withFileSizeInBytes(size).withReferencedDataFile(referencedDataFile).withContentOffset(blobMetadata.offset()).withContentSizeInBytes(blobMetadata.length()).withRecordCount(deletes.positions().cardinality()).build();
    }

    private void write(PuffinWriter writer, Deletes deletes) {
        String path = deletes.path();
        PositionDeleteIndex positions = deletes.positions();
        BlobMetadata blobMetadata = writer.write(this.toBlob(positions, path));
        this.blobsByPath.put(path, blobMetadata);
    }

    private PuffinWriter newWriter() {
        EncryptedOutputFile outputFile = this.fileFactory.newOutputFile();
        return Puffin.write(outputFile).createdBy(IcebergBuild.fullVersion()).build();
    }

    private Blob toBlob(PositionDeleteIndex positions, String path) {
        return new Blob("deletion-vector-v1", ImmutableList.of(Integer.valueOf(MetadataColumns.ROW_POSITION.fieldId())), -1L, -1L, positions.serialize(), null, ImmutableMap.of(REFERENCED_DATA_FILE_KEY, path, CARDINALITY_KEY, String.valueOf(positions.cardinality())));
    }

    private static class Deletes {
        private final String path;
        private final PositionDeleteIndex positions;
        private final PartitionSpec spec;
        private final StructLike partition;

        private Deletes(String path, PartitionSpec spec, StructLike partition) {
            this.path = path;
            this.positions = new BitmapPositionDeleteIndex();
            this.spec = spec;
            this.partition = StructLikeUtil.copy(partition);
        }

        public String path() {
            return this.path;
        }

        public PositionDeleteIndex positions() {
            return this.positions;
        }

        public PartitionSpec spec() {
            return this.spec;
        }

        public StructLike partition() {
            return this.partition;
        }
    }
}

