/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.encryption;

import com.dataiku.dss.shadelib.org.apache.iceberg.CombinedScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptedInputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.EncryptionManager;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class InputFilesDecryptor {
    private final Map<String, InputFile> decryptedInputFiles;

    public InputFilesDecryptor(CombinedScanTask combinedTask, FileIO io, EncryptionManager encryption) {
        HashMap keyMetadata = Maps.newHashMap();
        combinedTask.files().stream().flatMap(fileScanTask -> Stream.concat(Stream.of((DataFile)fileScanTask.file()), fileScanTask.deletes().stream())).forEach(file -> keyMetadata.put(file.location(), file.keyMetadata()));
        Stream<EncryptedInputFile> encrypted = keyMetadata.entrySet().stream().map(entry -> EncryptedFiles.encryptedInput(io.newInputFile((String)entry.getKey()), (ByteBuffer)entry.getValue()));
        Iterable<InputFile> decryptedFiles = encryption.decrypt(encrypted::iterator);
        HashMap files = Maps.newHashMapWithExpectedSize(keyMetadata.size());
        decryptedFiles.forEach(decrypted -> files.putIfAbsent(decrypted.location(), decrypted));
        this.decryptedInputFiles = Collections.unmodifiableMap(files);
    }

    public InputFile getInputFile(FileScanTask task) {
        Preconditions.checkArgument(!task.isDataTask(), "Invalid task type");
        return this.decryptedInputFiles.get(((DataFile)task.file()).location());
    }

    public InputFile getInputFile(String location) {
        return this.decryptedInputFiles.get(location);
    }
}

